/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;

class SnsImpl {
    private SnsImpl() {
    }

    static SdkRequest modifyRequest(SdkRequest request, Context otelContext, TextMapPropagator messagingPropagator) {
        if (messagingPropagator == null) {
            return null;
        }
        if (request instanceof PublishRequest) {
            return SnsImpl.injectIntoPublishRequest((PublishRequest)request, otelContext, messagingPropagator);
        }
        return null;
    }

    private static SdkRequest injectIntoPublishRequest(PublishRequest request, Context otelContext, TextMapPropagator messagingPropagator) {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>(request.messageAttributes());
        if (!SnsImpl.injectIntoMessageAttributes(messageAttributes, otelContext, messagingPropagator)) {
            return request;
        }
        return (SdkRequest)request.toBuilder().messageAttributes(messageAttributes).build();
    }

    private static boolean injectIntoMessageAttributes(Map<String, MessageAttributeValue> messageAttributes, Context otelContext, TextMapPropagator messagingPropagator) {
        messagingPropagator.inject(otelContext, messageAttributes, (carrier, k, v) -> carrier.put(k, (MessageAttributeValue)MessageAttributeValue.builder().stringValue(v).dataType("String").build()));
        return messageAttributes.size() <= 10;
    }

    static {
        String string = SnsClient.class.getName();
    }
}

