/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkInstrumenterFactory;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetryBuilder;
import io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpResponse;

public class AwsSdkTelemetry {
    private final Instrumenter<ExecutionAttributes, SdkHttpResponse> requestInstrumenter;
    private final Instrumenter<ExecutionAttributes, SdkHttpResponse> consumerInstrumenter;
    private final boolean captureExperimentalSpanAttributes;
    @Nullable
    private final TextMapPropagator messagingPropagator;
    private final boolean useXrayPropagator;
    private final boolean recordIndividualHttpError;

    public static AwsSdkTelemetry create(OpenTelemetry openTelemetry) {
        return AwsSdkTelemetry.builder(openTelemetry).build();
    }

    public static AwsSdkTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new AwsSdkTelemetryBuilder(openTelemetry);
    }

    AwsSdkTelemetry(OpenTelemetry openTelemetry, boolean captureExperimentalSpanAttributes, boolean useMessagingPropagator, boolean useXrayPropagator, boolean recordIndividualHttpError) {
        this.useXrayPropagator = useXrayPropagator;
        this.requestInstrumenter = AwsSdkInstrumenterFactory.requestInstrumenter(openTelemetry, captureExperimentalSpanAttributes);
        this.consumerInstrumenter = AwsSdkInstrumenterFactory.consumerInstrumenter(openTelemetry, captureExperimentalSpanAttributes);
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.messagingPropagator = useMessagingPropagator ? openTelemetry.getPropagators().getTextMapPropagator() : null;
        this.recordIndividualHttpError = recordIndividualHttpError;
    }

    public ExecutionInterceptor newExecutionInterceptor() {
        return new TracingExecutionInterceptor(this.requestInstrumenter, this.consumerInstrumenter, this.captureExperimentalSpanAttributes, this.messagingPropagator, this.useXrayPropagator, this.recordIndividualHttpError);
    }
}

