/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ProgressListener;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.BufferAggregator;
import com.azure.storage.common.implementation.BufferStagingArea;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.azure.storage.file.datalake.implementation.models.LeaseAccessConditions;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathExpiryOptions;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathsFlushDataHeaders;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.ModelHelper;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.DownloadRetryOptions;
import com.azure.storage.file.datalake.models.FileExpirationOffset;
import com.azure.storage.file.datalake.models.FileQueryAsyncResponse;
import com.azure.storage.file.datalake.models.FileRange;
import com.azure.storage.file.datalake.models.FileReadAsyncResponse;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.options.DataLakeFileAppendOptions;
import com.azure.storage.file.datalake.options.DataLakeFileFlushOptions;
import com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import com.azure.storage.file.datalake.options.FileParallelUploadOptions;
import com.azure.storage.file.datalake.options.FileQueryOptions;
import com.azure.storage.file.datalake.options.FileScheduleDeletionOptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

@ServiceClient(builder=DataLakePathClientBuilder.class, isAsync=true)
public class DataLakeFileAsyncClient
extends DataLakePathAsyncClient {
    static final long MAX_APPEND_FILE_BYTES = 0xFA000000L;
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeFileAsyncClient.class);

    DataLakeFileAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String fileName, BlockBlobAsyncClient blockBlobAsyncClient, AzureSasCredential sasToken, CpkInfo customerProvidedKey, boolean isTokenCredentialAuthenticated) {
        super(pipeline, url, serviceVersion, accountName, fileSystemName, fileName, PathResourceType.FILE, blockBlobAsyncClient, sasToken, customerProvidedKey, isTokenCredentialAuthenticated);
    }

    DataLakeFileAsyncClient(DataLakePathAsyncClient pathAsyncClient) {
        super(pathAsyncClient.getHttpPipeline(), pathAsyncClient.getAccountUrl(), pathAsyncClient.getServiceVersion(), pathAsyncClient.getAccountName(), pathAsyncClient.getFileSystemName(), Utility.urlEncode((String)pathAsyncClient.pathName), PathResourceType.FILE, pathAsyncClient.getBlockBlobAsyncClient(), pathAsyncClient.getSasToken(), pathAsyncClient.getCpkInfo(), pathAsyncClient.isTokenCredentialAuthenticated());
    }

    public String getFileUrl() {
        return this.getPathUrl();
    }

    public String getFilePath() {
        return this.getObjectPath();
    }

    public String getFileName() {
        return this.getObjectName();
    }

    @Override
    public DataLakeFileAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new DataLakeFileAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), this.getObjectPath(), this.blockBlobAsyncClient, this.getSasToken(), finalCustomerProvidedKey, this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        return this.deleteWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(null, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions()).flatMap(FluxUtil::toMono);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteIfExistsWithResponse(DataLakePathDeleteOptions options) {
        try {
            options = options == null ? new DataLakePathDeleteOptions() : options;
            return this.deleteWithResponse(options.getRequestConditions()).map(response -> new SimpleResponse(response, (Object)true)).onErrorResume(t -> t instanceof DataLakeStorageException && ((DataLakeStorageException)((Object)((Object)t))).getStatusCode() == 404, t -> {
                HttpResponse response = ((DataLakeStorageException)((Object)((Object)t))).getResponse();
                return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions) {
        return this.upload(data, parallelTransferOptions, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> upload(BinaryData data, ParallelTransferOptions parallelTransferOptions) {
        return this.upload(data, parallelTransferOptions, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, boolean overwrite) {
        DataLakeRequestConditions requestConditions;
        Mono overwriteCheck;
        if (overwrite) {
            overwriteCheck = Mono.empty();
            requestConditions = null;
        } else {
            overwriteCheck = this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : Mono.empty());
            requestConditions = new DataLakeRequestConditions().setIfNoneMatch("*");
        }
        return overwriteCheck.then(this.uploadWithResponse(data, parallelTransferOptions, null, null, requestConditions)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> upload(BinaryData data, ParallelTransferOptions parallelTransferOptions, boolean overwrite) {
        DataLakeRequestConditions requestConditions;
        Mono overwriteCheck;
        if (overwrite) {
            overwriteCheck = Mono.empty();
            requestConditions = null;
        } else {
            overwriteCheck = this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : Mono.empty());
            requestConditions = new DataLakeRequestConditions().setIfNoneMatch("*");
        }
        return overwriteCheck.then(this.uploadWithResponse(new FileParallelUploadOptions(data).setParallelTransferOptions(parallelTransferOptions).setRequestConditions(requestConditions))).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> uploadWithResponse(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            return this.uploadWithResponse(new FileParallelUploadOptions(data).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> uploadWithResponse(FileParallelUploadOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            DataLakeRequestConditions validatedRequestConditions = options.getRequestConditions() == null ? new DataLakeRequestConditions() : options.getRequestConditions();
            DataLakeRequestConditions validatedUploadRequestConditions = new DataLakeRequestConditions().setLeaseId(validatedRequestConditions.getLeaseId());
            ParallelTransferOptions validatedParallelTransferOptions = ModelHelper.populateAndApplyDefaults(options.getParallelTransferOptions());
            long fileOffset = 0L;
            Function<Flux, Mono> uploadInChunksFunction = stream -> this.uploadInChunks((Flux<ByteBuffer>)stream, fileOffset, validatedParallelTransferOptions, options.getHeaders(), validatedUploadRequestConditions);
            BiFunction<Flux, Long, Mono> uploadFullMethod = (stream, length) -> this.uploadWithResponse((Flux<ByteBuffer>)stream, fileOffset, (long)length, options.getHeaders(), validatedUploadRequestConditions, validatedParallelTransferOptions.getProgressListener());
            BinaryData binaryData = options.getData();
            Flux data = binaryData != null ? binaryData.toFluxByteBuffer() : options.getDataFlux();
            data = UploadUtils.extractByteBuffer(data, (Long)options.getOptionalLength(), (Long)validatedParallelTransferOptions.getBlockSizeLong(), (InputStream)options.getDataStream());
            DataLakePathCreateOptions createOptions = new DataLakePathCreateOptions().setPermissions(options.getPermissions()).setUmask(options.getUmask()).setPathHttpHeaders(options.getHeaders()).setMetadata(options.getMetadata()).setRequestConditions(validatedRequestConditions).setEncryptionContext(options.getEncryptionContext());
            return this.createWithResponse(createOptions).then(UploadUtils.uploadFullOrChunked((Flux)data, (ParallelTransferOptions)validatedParallelTransferOptions, uploadInChunksFunction, uploadFullMethod));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<PathInfo>> uploadInChunks(Flux<ByteBuffer> data, long fileOffset, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders httpHeaders, DataLakeRequestConditions requestConditions) {
        BufferStagingArea stagingArea = new BufferStagingArea(parallelTransferOptions.getBlockSizeLong().longValue(), 0xFA000000L);
        Flux chunkedSource = UploadUtils.chunkSource(data, (ParallelTransferOptions)parallelTransferOptions);
        ProgressListener progressListener = parallelTransferOptions.getProgressListener();
        ProgressReporter progressReporter = progressListener == null ? null : ProgressReporter.withProgressListener((ProgressListener)progressListener);
        return chunkedSource.flatMapSequential(arg_0 -> ((BufferStagingArea)stagingArea).write(arg_0), 1, 1).concatWith((Publisher)Flux.defer(() -> ((BufferStagingArea)stagingArea).flush())).map(bufferAggregator -> Tuples.of((Object)bufferAggregator, (Object)bufferAggregator.length(), (Object)0L)).scan((result, source) -> {
            BufferAggregator bufferAggregator = (BufferAggregator)source.getT1();
            long currentBufferLength = bufferAggregator.length();
            long lastBytesWritten = (Long)result.getT2();
            long lastOffset = (Long)result.getT3();
            return Tuples.of((Object)bufferAggregator, (Object)currentBufferLength, (Object)(lastBytesWritten + lastOffset));
        }).flatMapSequential(tuple3 -> {
            BufferAggregator bufferAggregator = (BufferAggregator)tuple3.getT1();
            long currentBufferLength = bufferAggregator.length();
            long currentOffset = (Long)tuple3.getT3() + fileOffset;
            long offset = currentBufferLength + currentOffset;
            Contexts appendContexts = Contexts.empty();
            if (progressReporter != null) {
                appendContexts.setHttpRequestProgressReporter(progressReporter.createChild());
            }
            return this.appendWithResponse((Flux<ByteBuffer>)bufferAggregator.asFlux(), currentOffset, currentBufferLength, new DataLakeFileAppendOptions().setLeaseId(requestConditions.getLeaseId()), appendContexts.getContext()).map(resp -> offset).flux();
        }, parallelTransferOptions.getMaxConcurrency().intValue(), 1).last().flatMap(length -> this.flushWithResponse((long)length, false, false, httpHeaders, requestConditions));
    }

    private Mono<Response<PathInfo>> uploadWithResponse(Flux<ByteBuffer> data, long fileOffset, long length, PathHttpHeaders httpHeaders, DataLakeRequestConditions requestConditions, ProgressListener progressListener) {
        Contexts appendContexts = Contexts.empty();
        if (progressListener != null) {
            appendContexts.setHttpRequestProgressReporter(ProgressReporter.withProgressListener((ProgressListener)progressListener));
        }
        return this.appendWithResponse(data, fileOffset, length, new DataLakeFileAppendOptions().setLeaseId(requestConditions.getLeaseId()), appendContexts.getContext()).flatMap(resp -> this.flushWithResponse(fileOffset + length, false, false, httpHeaders, requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath) {
        return this.uploadFromFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath, boolean overwrite) {
        Mono overwriteCheck = Mono.empty();
        DataLakeRequestConditions requestConditions = null;
        if (!overwrite) {
            if (UploadUtils.shouldUploadInChunks((String)filePath, (Long)0x6400000L, (ClientLogger)LOGGER)) {
                overwriteCheck = this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("File already exists. Specify overwrite to true to force update the file.")) : Mono.empty());
            }
            requestConditions = new DataLakeRequestConditions().setIfNoneMatch("*");
        }
        return overwriteCheck.then(this.uploadFromFile(filePath, null, null, null, requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        return this.uploadFromFileWithResponse(filePath, parallelTransferOptions, headers, metadata, requestConditions).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> uploadFromFileWithResponse(String filePath, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        Long originalBlockSize = parallelTransferOptions == null ? null : parallelTransferOptions.getBlockSizeLong();
        DataLakeRequestConditions validatedRequestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        DataLakeRequestConditions validatedUploadRequestConditions = new DataLakeRequestConditions().setLeaseId(validatedRequestConditions.getLeaseId());
        ParallelTransferOptions finalParallelTransferOptions = ModelHelper.populateAndApplyDefaults(parallelTransferOptions);
        long fileOffset = 0L;
        try {
            return Mono.using(() -> UploadUtils.uploadFileResourceSupplier((String)filePath, (ClientLogger)LOGGER), channel -> {
                try {
                    long fileSize = channel.size();
                    if (fileSize == 0L) {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Size of the file must be greater than 0."));
                    }
                    if (UploadUtils.shouldUploadInChunks((String)filePath, (Long)finalParallelTransferOptions.getMaxSingleUploadSizeLong(), (ClientLogger)LOGGER)) {
                        return this.createWithResponse(null, null, headers, metadata, validatedRequestConditions).then(this.uploadFileChunks(fileOffset, fileSize, finalParallelTransferOptions, originalBlockSize, headers, validatedUploadRequestConditions, (AsynchronousFileChannel)channel));
                    }
                    return this.createWithResponse(null, null, headers, metadata, validatedRequestConditions).then(this.uploadWithResponse((Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)channel), fileOffset, fileSize, headers, validatedUploadRequestConditions, finalParallelTransferOptions.getProgressListener()));
                }
                catch (IOException ex) {
                    return Mono.error((Throwable)ex);
                }
            }, channel -> UploadUtils.uploadFileCleanup((AsynchronousFileChannel)channel, (ClientLogger)LOGGER));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<PathInfo>> uploadFileChunks(long fileOffset, long fileSize, ParallelTransferOptions parallelTransferOptions, Long originalBlockSize, PathHttpHeaders headers, DataLakeRequestConditions requestConditions, AsynchronousFileChannel channel) {
        ProgressListener progressListener = parallelTransferOptions.getProgressListener();
        ProgressReporter progressReporter = progressListener == null ? null : ProgressReporter.withProgressListener((ProgressListener)progressListener);
        return Flux.fromIterable(DataLakeFileAsyncClient.sliceFile(fileSize, originalBlockSize, parallelTransferOptions.getBlockSizeLong())).flatMap(chunk -> {
            Flux data = FluxUtil.readFile((AsynchronousFileChannel)channel, (long)chunk.getOffset(), (long)chunk.getCount());
            Contexts appendContexts = Contexts.empty();
            if (progressReporter != null) {
                appendContexts.setHttpRequestProgressReporter(progressReporter.createChild());
            }
            return this.appendWithResponse((Flux<ByteBuffer>)data, fileOffset + chunk.getOffset(), (long)chunk.getCount(), new DataLakeFileAppendOptions().setLeaseId(requestConditions.getLeaseId()), appendContexts.getContext());
        }, parallelTransferOptions.getMaxConcurrency().intValue()).then(Mono.defer(() -> this.flushWithResponse(fileSize, false, false, headers, requestConditions)));
    }

    private static List<FileRange> sliceFile(long fileSize, Long originalBlockSize, long blockSize) {
        ArrayList<FileRange> ranges = new ArrayList<FileRange>();
        if (fileSize > 0x6400000L && originalBlockSize == null) {
            blockSize = 0x800000L;
        }
        for (long pos = 0L; pos < fileSize; pos += blockSize) {
            long count = blockSize;
            if (pos + count > fileSize) {
                count = fileSize - pos;
            }
            ranges.add(new FileRange(pos, count));
        }
        return ranges;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> append(Flux<ByteBuffer> data, long fileOffset, long length) {
        return this.appendWithResponse(data, fileOffset, length, new DataLakeFileAppendOptions(), null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> append(BinaryData data, long fileOffset) {
        return this.appendWithResponse(data, fileOffset, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendWithResponse(Flux<ByteBuffer> data, long fileOffset, long length, byte[] contentMd5, String leaseId) {
        DataLakeFileAppendOptions appendOptions = new DataLakeFileAppendOptions().setLeaseId(leaseId).setContentHash(contentMd5).setFlush(null);
        try {
            return FluxUtil.withContext(context -> this.appendWithResponse(data, fileOffset, length, appendOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendWithResponse(Flux<ByteBuffer> data, long fileOffset, long length, DataLakeFileAppendOptions appendOptions) {
        return this.appendWithResponse(data, fileOffset, length, appendOptions, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendWithResponse(BinaryData data, long fileOffset, byte[] contentMd5, String leaseId) {
        try {
            Objects.requireNonNull(data);
            Flux fluxData = data.toFluxByteBuffer();
            long length = data.getLength();
            DataLakeFileAppendOptions options = new DataLakeFileAppendOptions().setLeaseId(leaseId).setContentHash(contentMd5).setFlush(null);
            return FluxUtil.withContext(context -> this.appendWithResponse((Flux<ByteBuffer>)fluxData, fileOffset, length, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendWithResponse(BinaryData data, long fileOffset, DataLakeFileAppendOptions appendOptions) {
        Objects.requireNonNull(data);
        Flux fluxData = data.toFluxByteBuffer();
        long length = data.getLength();
        return this.appendWithResponse((Flux<ByteBuffer>)fluxData, fileOffset, length, appendOptions, null);
    }

    Mono<Response<Void>> appendWithResponse(Flux<ByteBuffer> data, long fileOffset, long length, DataLakeFileAppendOptions appendOptions, Context context) {
        appendOptions = appendOptions == null ? new DataLakeFileAppendOptions() : appendOptions;
        LeaseAccessConditions leaseAccessConditions = new LeaseAccessConditions().setLeaseId(appendOptions.getLeaseId());
        PathHttpHeaders headers = new PathHttpHeaders().setTransactionalContentHash(appendOptions.getContentMd5());
        context = context == null ? Context.NONE : context;
        Long leaseDuration = appendOptions.getLeaseDuration() != null ? Long.valueOf(appendOptions.getLeaseDuration().intValue()) : null;
        return this.dataLakeStorage.getPaths().appendDataNoCustomHeadersWithResponseAsync(data, (Long)fileOffset, null, (Long)length, null, appendOptions.getLeaseAction(), leaseDuration, appendOptions.getProposedLeaseId(), null, appendOptions.isFlush(), headers, leaseAccessConditions, this.getCpkInfo(), context).map(response -> new SimpleResponse(response, null));
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> flush(long position) {
        return this.flush(position, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> flush(long position, boolean overwrite) {
        DataLakeRequestConditions requestConditions = null;
        if (!overwrite) {
            requestConditions = new DataLakeRequestConditions().setIfNoneMatch("*");
        }
        return this.flushWithResponse(position, false, false, null, requestConditions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> flushWithResponse(long position, boolean retainUncommittedData, boolean close, PathHttpHeaders httpHeaders, DataLakeRequestConditions requestConditions) {
        DataLakeFileFlushOptions flushOptions = new DataLakeFileFlushOptions().setUncommittedDataRetained(retainUncommittedData).setClose(close).setPathHttpHeaders(httpHeaders).setRequestConditions(requestConditions);
        try {
            return FluxUtil.withContext(context -> this.flushWithResponse(position, flushOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> flushWithResponse(long position, DataLakeFileFlushOptions flushOptions) {
        try {
            return FluxUtil.withContext(context -> this.flushWithResponse(position, flushOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<PathInfo>> flushWithResponse(long position, DataLakeFileFlushOptions flushOptions, Context context) {
        PathHttpHeaders httpHeaders = flushOptions.getPathHttpHeaders() == null ? new PathHttpHeaders() : flushOptions.getPathHttpHeaders();
        DataLakeRequestConditions requestConditions = flushOptions.getRequestConditions() == null ? new DataLakeRequestConditions() : flushOptions.getRequestConditions();
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        Long leaseDuration = flushOptions.getLeaseDuration() != null ? Long.valueOf(flushOptions.getLeaseDuration().intValue()) : null;
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().flushDataWithResponseAsync(null, position, flushOptions.isUncommittedDataRetained(), flushOptions.isClose(), 0L, flushOptions.getLeaseAction(), leaseDuration, flushOptions.getProposedLeaseId(), null, httpHeaders, lac, mac, this.getCpkInfo(), context).map(response -> new SimpleResponse((Response)response, (Object)new PathInfo(((PathsFlushDataHeaders)response.getDeserializedHeaders()).getETag(), ((PathsFlushDataHeaders)response.getDeserializedHeaders()).getLastModified(), ((PathsFlushDataHeaders)response.getDeserializedHeaders()).isXMsRequestServerEncrypted() != null, ((PathsFlushDataHeaders)response.getDeserializedHeaders()).getXMsEncryptionKeySha256())));
    }

    public Flux<ByteBuffer> read() {
        return this.readWithResponse(null, null, null, false).flatMapMany(ResponseBase::getValue);
    }

    public Mono<FileReadAsyncResponse> readWithResponse(FileRange range, DownloadRetryOptions options, DataLakeRequestConditions requestConditions, boolean getRangeContentMd5) {
        return this.blockBlobAsyncClient.downloadWithResponse(Transforms.toBlobRange(range), Transforms.toBlobDownloadRetryOptions(options), Transforms.toBlobRequestConditions(requestConditions), getRangeContentMd5).map(Transforms::toFileReadAsyncResponse).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathProperties> readToFile(String filePath) {
        return this.readToFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathProperties> readToFile(String filePath, boolean overwrite) {
        HashSet<OpenOption> openOptions = null;
        if (overwrite) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        return this.readToFileWithResponse(filePath, null, null, null, null, false, openOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathProperties>> readToFileWithResponse(String filePath, FileRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions options, DataLakeRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions) {
        return this.blockBlobAsyncClient.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(Transforms.toBlobRange(range)).setParallelTransferOptions(parallelTransferOptions).setDownloadRetryOptions(Transforms.toBlobDownloadRetryOptions(options)).setRequestConditions(Transforms.toBlobRequestConditions(requestConditions)).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)Transforms.toPathProperties((BlobProperties)response.getValue(), response)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileAsyncClient> rename(String destinationFileSystem, String destinationPath) {
        return this.renameWithResponse(destinationFileSystem, destinationPath, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileAsyncClient>> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.renameWithResponse(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, (Context)context)).map(response -> new SimpleResponse(response, (Object)new DataLakeFileAsyncClient((DataLakePathAsyncClient)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public Flux<ByteBuffer> query(String expression) {
        try {
            return this.queryWithResponse(new FileQueryOptions(expression)).flatMapMany(ResponseBase::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.fluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public Mono<FileQueryAsyncResponse> queryWithResponse(FileQueryOptions queryOptions) {
        return this.blockBlobAsyncClient.queryWithResponse(Transforms.toBlobQueryOptions(queryOptions)).map(Transforms::toFileQueryAsyncResponse).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> scheduleDeletion(FileScheduleDeletionOptions options) {
        return this.scheduleDeletionWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> scheduleDeletionWithResponse(FileScheduleDeletionOptions options) {
        try {
            return FluxUtil.withContext(context -> this.scheduleDeletionWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> scheduleDeletionWithResponse(FileScheduleDeletionOptions options, Context context) {
        PathExpiryOptions pathExpiryOptions;
        context = context == null ? Context.NONE : context;
        String expiresOn = null;
        if (options != null && options.getExpiresOn() != null) {
            pathExpiryOptions = PathExpiryOptions.ABSOLUTE;
            expiresOn = new DateTimeRfc1123(options.getExpiresOn()).toString();
        } else if (options != null && options.getTimeToExpire() != null) {
            pathExpiryOptions = options.getExpiryRelativeTo() == FileExpirationOffset.CREATION_TIME ? PathExpiryOptions.RELATIVE_TO_CREATION : PathExpiryOptions.RELATIVE_TO_NOW;
            expiresOn = Long.toString(options.getTimeToExpire().toMillis());
        } else {
            pathExpiryOptions = PathExpiryOptions.NEVER_EXPIRE;
        }
        return this.blobDataLakeStorage.getPaths().setExpiryWithResponseAsync(pathExpiryOptions, null, null, expiresOn, context).map(rb -> new SimpleResponse((Response)rb, null));
    }
}

