/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.type.ListTypeInfo;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.PrimitiveCategory;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.util.HiveBucketingV1;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;

final class HiveBucketingV2 {
    private HiveBucketingV2() {
    }

    static int getBucketHashCode(List<TypeInfo> types, Page page, int position) {
        Preconditions.checkArgument((types.size() <= page.getChannelCount() ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < types.size(); ++i) {
            int fieldHash = HiveBucketingV2.hash(types.get(i), page.getBlock(i), position);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    static int getBucketHashCode(List<TypeInfo> types, Object[] values) {
        Preconditions.checkArgument((types.size() == values.length ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < values.length; ++i) {
            int fieldHash = HiveBucketingV2.hash(types.get(i), values[i]);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    private static int hash(TypeInfo type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type trinoType = Objects.requireNonNull(HiveTypeTranslator.fromPrimitiveType(typeInfo));
                if (trinoType.equals(BooleanType.BOOLEAN)) {
                    return BooleanType.BOOLEAN.getBoolean(block, position) ? 1 : 0;
                }
                if (trinoType.equals(TinyintType.TINYINT)) {
                    return TinyintType.TINYINT.getByte(block, position);
                }
                if (trinoType.equals(SmallintType.SMALLINT)) {
                    return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(SmallintType.SMALLINT.getShort(block, position)));
                }
                if (trinoType.equals(IntegerType.INTEGER)) {
                    return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(IntegerType.INTEGER.getInt(block, position)));
                }
                if (trinoType.equals(BigintType.BIGINT)) {
                    return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(BigintType.BIGINT.getLong(block, position)));
                }
                if (trinoType.equals(RealType.REAL)) {
                    return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(Float.floatToRawIntBits(Float.floatToIntBits(RealType.REAL.getFloat(block, position)))));
                }
                if (trinoType.equals(DoubleType.DOUBLE)) {
                    return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(Double.doubleToRawLongBits(Double.doubleToLongBits(DoubleType.DOUBLE.getDouble(block, position)))));
                }
                if (trinoType instanceof VarcharType) {
                    VarcharType varcharType = (VarcharType)trinoType;
                    return HiveBucketingV2.murmur3(varcharType.getSlice(block, position).getBytes());
                }
                if (trinoType.equals(DateType.DATE)) {
                    return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(DateType.DATE.getInt(block, position)));
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory);
            }
            case LIST: {
                return HiveBucketingV2.hashOfList((ListTypeInfo)type, (Block)block.getObject(position, Block.class));
            }
            case MAP: {
                return HiveBucketingV2.hashOfMap((MapTypeInfo)type, (SqlMap)block.getObject(position, SqlMap.class));
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory());
    }

    private static int hash(TypeInfo type, Object value) {
        if (value == null) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return (Boolean)value != false ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)((Long)value));
                    }
                    case SHORT: {
                        return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(Shorts.checkedCast((long)((Long)value))));
                    }
                    case INT: {
                        return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(Math.toIntExact((Long)value)));
                    }
                    case LONG: {
                        return HiveBucketingV2.murmur3(HiveBucketingV2.bytes((Long)value));
                    }
                    case FLOAT: {
                        return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(Float.floatToRawIntBits(Float.floatToIntBits(Float.intBitsToFloat(Math.toIntExact((Long)value))))));
                    }
                    case DOUBLE: {
                        return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(Double.doubleToRawLongBits(Double.doubleToLongBits((Double)value))));
                    }
                    case STRING: {
                        return HiveBucketingV2.murmur3(((Slice)value).getBytes());
                    }
                    case VARCHAR: {
                        return HiveBucketingV2.murmur3(((Slice)value).getBytes());
                    }
                    case DATE: {
                        return HiveBucketingV2.murmur3(HiveBucketingV2.bytes(Math.toIntExact((Long)value)));
                    }
                    case TIMESTAMP: {
                        break;
                    }
                    case DECIMAL: 
                    case CHAR: 
                    case BINARY: 
                    case TIMESTAMPLOCALTZ: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_DAY_TIME: {
                        break;
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory);
            }
            case LIST: {
                return HiveBucketingV2.hashOfList((ListTypeInfo)type, (Block)value);
            }
            case MAP: {
                return HiveBucketingV2.hashOfMap((MapTypeInfo)type, (SqlMap)value);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory());
    }

    private static int hashOfMap(MapTypeInfo type, SqlMap sqlMap) {
        TypeInfo keyTypeInfo = type.getMapKeyTypeInfo();
        TypeInfo valueTypeInfo = type.getMapValueTypeInfo();
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        int result = 0;
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            result += HiveBucketingV2.hash(keyTypeInfo, rawKeyBlock, rawOffset + i) ^ HiveBucketingV1.hash(valueTypeInfo, rawValueBlock, rawOffset + i);
        }
        return result;
    }

    private static int hashOfList(ListTypeInfo type, Block singleListBlock) {
        TypeInfo elementTypeInfo = type.getListElementTypeInfo();
        int result = 0;
        for (int i = 0; i < singleListBlock.getPositionCount(); ++i) {
            result = result * 31 + HiveBucketingV2.hash(elementTypeInfo, singleListBlock, i);
        }
        return result;
    }

    private static byte[] bytes(short value) {
        return new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private static byte[] bytes(int value) {
        return new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private static byte[] bytes(long value) {
        return new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }

    private static int murmur3(byte[] data) {
        int length = data.length;
        int hash = 104729;
        int blocks = length / 4;
        for (int block = 0; block < blocks; ++block) {
            int i = block * 4;
            int k = Ints.fromBytes((byte)data[i + 3], (byte)data[i + 2], (byte)data[i + 1], (byte)data[i]);
            k *= -862048943;
            k = Integer.rotateLeft(k, 15);
            hash ^= (k *= 461845907);
            hash = Integer.rotateLeft(hash, 13) * 5 + -430675100;
        }
        int idx = blocks * 4;
        int k1 = 0;
        switch (length - idx) {
            case 3: {
                k1 ^= data[idx + 2] << 16;
            }
            case 2: {
                k1 ^= data[idx + 1] << 8;
            }
            case 1: {
                k1 ^= data[idx];
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                hash ^= (k1 *= 461845907);
            }
        }
        hash ^= length;
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return hash;
    }
}

