/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Inject;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.security.LegacyAccessControlMetastore;
import io.trino.spi.connector.ConnectorSecurityContext;
import java.util.Objects;
import java.util.Optional;

public class SemiTransactionalLegacyAccessControlMetastore
implements LegacyAccessControlMetastore {
    private final HiveTransactionManager transactionManager;

    @Inject
    public SemiTransactionalLegacyAccessControlMetastore(HiveTransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    @Override
    public Optional<Table> getTable(ConnectorSecurityContext context, String databaseName, String tableName) {
        SemiTransactionalHiveMetastore metastore = this.transactionManager.get(context.getTransactionHandle(), context.getIdentity()).getMetastore();
        return metastore.getTable(databaseName, tableName);
    }
}

