/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.security.LegacyAccessControlMetastore;
import io.trino.plugin.hive.security.LegacySecurityConfig;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class LegacyAccessControl
implements ConnectorAccessControl {
    private final LegacyAccessControlMetastore accessControlMetastore;
    private final boolean allowDropTable;
    private final boolean allowRenameTable;
    private final boolean allowCommentTable;
    private final boolean allowCommentColumn;
    private final boolean allowAddColumn;
    private final boolean allowDropColumn;
    private final boolean allowRenameColumn;

    @Inject
    public LegacyAccessControl(LegacyAccessControlMetastore accessControlMetastore, LegacySecurityConfig securityConfig) {
        this.accessControlMetastore = Objects.requireNonNull(accessControlMetastore, "accessControlMetastore is null");
        this.allowDropTable = securityConfig.getAllowDropTable();
        this.allowRenameTable = securityConfig.getAllowRenameTable();
        this.allowCommentTable = securityConfig.getAllowCommentTable();
        this.allowCommentColumn = securityConfig.getAllowCommentColumn();
        this.allowAddColumn = securityConfig.getAllowAddColumn();
        this.allowDropColumn = securityConfig.getAllowDropColumn();
        this.allowRenameColumn = securityConfig.getAllowRenameColumn();
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName, Map<String, Object> properties) {
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, TrinoPrincipal principal) {
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        Optional<Table> target;
        if (!this.allowDropTable) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
        if ((target = this.accessControlMetastore.getTable(context, tableName.getSchemaName(), tableName.getTableName())).isEmpty()) {
            AccessDeniedException.denyDropTable((String)tableName.toString(), (String)"Table not found");
        }
        String tableOwner = target.get().getOwner().orElse(null);
        if (!context.getIdentity().getUser().equals(tableOwner)) {
            AccessDeniedException.denyDropTable((String)tableName.toString(), (String)String.format("Owner of the table ('%s') is different from session user ('%s')", tableOwner, context.getIdentity().getUser()));
        }
    }

    public void checkCanTruncateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.allowRenameTable) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanSetTableProperties(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Optional<Object>> properties) {
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowCommentTable) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
    }

    public void checkCanSetViewComment(ConnectorSecurityContext context, SchemaTableName viewName) {
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowCommentColumn) {
            AccessDeniedException.denyCommentColumn((String)tableName.toString());
        }
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public Map<SchemaTableName, Set<String>> filterColumns(ConnectorSecurityContext context, Map<SchemaTableName, Set<String>> tableColumns) {
        return tableColumns;
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowAddColumn) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowDropColumn) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowRenameColumn) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanAlterColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanSetTableAuthorization(ConnectorSecurityContext context, SchemaTableName tableName, TrinoPrincipal principal) {
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanUpdateTableColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> updatedColumns) {
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
    }

    public void checkCanSetViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, TrinoPrincipal principal) {
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> properties) {
    }

    public void checkCanRefreshMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
    }

    public void checkCanDropMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
    }

    public void checkCanRenameMaterializedView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
    }

    public void checkCanSetMaterializedViewProperties(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Optional<Object>> properties) {
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanDenySchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee) {
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal revokee, boolean grantOption) {
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanDenyTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee) {
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role) {
    }

    public void checkCanShowRoles(ConnectorSecurityContext context) {
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context) {
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
    }

    public void checkCanExecuteTableProcedure(ConnectorSecurityContext context, SchemaTableName tableName, String procedure) {
    }

    public boolean canExecuteFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        return !function.getSchemaName().equals("system");
    }

    public boolean canCreateViewWithExecuteFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        return this.canExecuteFunction(context, function);
    }

    public void checkCanShowFunctions(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaFunctionName> filterFunctions(ConnectorSecurityContext context, Set<SchemaFunctionName> functionNames) {
        return functionNames;
    }

    public void checkCanCreateFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
    }

    public void checkCanDropFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
    }

    public List<ViewExpression> getRowFilters(ConnectorSecurityContext context, SchemaTableName tableName) {
        return ImmutableList.of();
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        return Optional.empty();
    }
}

