/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;

public class InvalidProjectionException
extends TrinoException {
    public InvalidProjectionException(String columnName, Type columnType) {
        this(columnName, "Unsupported column type: " + columnType.getDisplayName());
    }

    public InvalidProjectionException(String columnName, String message) {
        this(InvalidProjectionException.invalidProjectionMessage(columnName, message));
    }

    public InvalidProjectionException(String message) {
        super((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, message);
    }

    public static String invalidProjectionMessage(String columnName, String message) {
        return String.format("Column projection for column '%s' failed. %s", columnName, message);
    }
}

