/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.base.util.UncheckedCloseable;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveInsertTableHandle;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateEmptyPartitionProcedure
implements Provider<Procedure> {
    private static final MethodHandle CREATE_EMPTY_PARTITION;
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateJsonCodec;

    @Inject
    public CreateEmptyPartitionProcedure(TransactionalMetadataFactory hiveMetadataFactory, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateJsonCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
    }

    public Procedure get() {
        return new Procedure("system", "create_empty_partition", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("PARTITION_COLUMNS", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new Procedure.Argument("PARTITION_VALUES", (Type)new ArrayType((Type)VarcharType.VARCHAR))), CREATE_EMPTY_PARTITION.bindTo(this));
    }

    public void createEmptyPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schema, String table, List<String> partitionColumnNames, List<String> partitionValues) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doCreateEmptyPartition(session, accessControl, schema, table, partitionColumnNames, partitionValues);
        }
    }

    private void doCreateEmptyPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, List<String> partitionColumnNames, List<String> partitionValues) {
        Procedures.checkProcedureArgument((schemaName != null ? 1 : 0) != 0, (String)"schema_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((tableName != null ? 1 : 0) != 0, (String)"table_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((partitionColumnNames != null ? 1 : 0) != 0, (String)"partition_columns cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((partitionValues != null ? 1 : 0) != 0, (String)"partition_values cannot be null", (Object[])new Object[0]);
        TransactionalMetadata hiveMetadata = this.hiveMetadataFactory.create(session.getIdentity(), true);
        hiveMetadata.beginQuery(session);
        try (UncheckedCloseable ignore = () -> hiveMetadata.cleanupQuery(session);){
            HiveTableHandle tableHandle = (HiveTableHandle)hiveMetadata.getTableHandle(session, new SchemaTableName(schemaName, tableName));
            if (tableHandle == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, String.format("Table '%s' does not exist", new SchemaTableName(schemaName, tableName)));
            }
            accessControl.checkCanInsertIntoTable(null, new SchemaTableName(schemaName, tableName));
            List actualPartitionColumnNames = (List)tableHandle.getPartitionColumns().stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
            if (!Objects.equals(partitionColumnNames, actualPartitionColumnNames)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Provided partition column names do not match actual partition column names: " + actualPartitionColumnNames);
            }
            HiveMetastoreClosure metastore = hiveMetadata.getMetastore().unsafeGetRawHiveMetastoreClosure();
            if (metastore.getPartition(schemaName, tableName, partitionValues).isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Partition already exists");
            }
            HiveInsertTableHandle hiveInsertTableHandle = (HiveInsertTableHandle)hiveMetadata.beginInsert(session, tableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES);
            String partitionName = HiveUtil.makePartName(actualPartitionColumnNames, partitionValues);
            LocationService.WriteInfo writeInfo = this.locationService.getPartitionWriteInfo(hiveInsertTableHandle.getLocationHandle(), Optional.empty(), partitionName);
            Slice serializedPartitionUpdate = Slices.wrappedBuffer((byte[])this.partitionUpdateJsonCodec.toJsonBytes((Object)new PartitionUpdate(partitionName, PartitionUpdate.UpdateMode.NEW, writeInfo.writePath().toString(), writeInfo.targetPath().toString(), (List<String>)ImmutableList.of(), 0L, 0L, 0L)));
            hiveMetadata.finishInsert(session, hiveInsertTableHandle, (Collection)ImmutableList.of((Object)serializedPartitionUpdate), (Collection)ImmutableList.of());
            hiveMetadata.commit();
        }
    }

    static {
        try {
            CREATE_EMPTY_PARTITION = MethodHandles.lookup().unreflect(CreateEmptyPartitionProcedure.class.getMethod("createEmptyPartition", ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, List.class, List.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

