/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.parquet.ChunkReader;
import io.trino.parquet.DiskRange;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.reader.ChunkedInputStream;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MemoryParquetDataSource
implements ParquetDataSource {
    private final ParquetDataSourceId id;
    private final long readTimeNanos;
    private final long readBytes;
    private final LocalMemoryContext memoryUsage;
    @Nullable
    private Slice data;

    public MemoryParquetDataSource(TrinoInputFile inputFile, AggregatedMemoryContext memoryContext, FileFormatDataSourceStats stats) throws IOException {
        try (TrinoInput input = inputFile.newInput();){
            long readStart = System.nanoTime();
            this.data = input.readTail(Math.toIntExact(inputFile.length()));
            this.readTimeNanos = System.nanoTime() - readStart;
            stats.readDataBytesPerSecond(this.data.length(), this.readTimeNanos);
        }
        this.memoryUsage = memoryContext.newLocalMemoryContext(MemoryParquetDataSource.class.getSimpleName());
        this.memoryUsage.setBytes((long)this.data.length());
        this.readBytes = this.data.length();
        this.id = new ParquetDataSourceId(inputFile.location().toString());
    }

    public ParquetDataSourceId getId() {
        return this.id;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getEstimatedSize() {
        return this.readBytes;
    }

    public Slice readTail(int length) {
        int readSize = Math.min(this.data.length(), length);
        return this.readFully(this.data.length() - readSize, readSize);
    }

    public final Slice readFully(long position, int length) {
        return this.data.slice(Math.toIntExact(position), length);
    }

    public <K> Map<K, ChunkedInputStream> planRead(ListMultimap<K, DiskRange> diskRanges, AggregatedMemoryContext memoryContext) {
        Objects.requireNonNull(diskRanges, "diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : diskRanges.asMap().entrySet()) {
            List chunkReaders = (List)((Collection)entry.getValue()).stream().map(diskRange -> new ChunkReader(){
                final /* synthetic */ DiskRange val$diskRange;
                {
                    this.val$diskRange = diskRange;
                }

                public long getDiskOffset() {
                    return this.val$diskRange.getOffset();
                }

                public Slice read() {
                    return MemoryParquetDataSource.this.data.slice(Math.toIntExact(this.val$diskRange.getOffset()), Math.toIntExact(this.val$diskRange.getLength()));
                }

                public void free() {
                }
            }).collect(ImmutableList.toImmutableList());
            builder.put(entry.getKey(), (Object)new ChunkedInputStream((Collection)chunkReaders));
        }
        return builder.buildOrThrow();
    }

    public void close() throws IOException {
        this.data = null;
        this.memoryUsage.close();
    }

    public final String toString() {
        return this.id.toString();
    }
}

