/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.trino.orc.OrcWriteValidation;
import io.trino.orc.OrcWriterOptions;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;

@DefunctConfig(value={"hive.orc.optimized-writer.enabled"})
public class OrcWriterConfig {
    private OrcWriterOptions options = new OrcWriterOptions();
    private double defaultBloomFilterFpp = 0.05;
    private double validationPercentage;
    private OrcWriteValidation.OrcWriteValidationMode validationMode = OrcWriteValidation.OrcWriteValidationMode.BOTH;

    public OrcWriterOptions toOrcWriterOptions() {
        return this.options;
    }

    public DataSize getStripeMinSize() {
        return this.options.getStripeMinSize();
    }

    @Config(value="hive.orc.writer.stripe-min-size")
    public OrcWriterConfig setStripeMinSize(DataSize stripeMinSize) {
        this.options = this.options.withStripeMinSize(stripeMinSize);
        return this;
    }

    public DataSize getStripeMaxSize() {
        return this.options.getStripeMaxSize();
    }

    @Config(value="hive.orc.writer.stripe-max-size")
    public OrcWriterConfig setStripeMaxSize(DataSize stripeMaxSize) {
        this.options = this.options.withStripeMaxSize(stripeMaxSize);
        return this;
    }

    public int getStripeMaxRowCount() {
        return this.options.getStripeMaxRowCount();
    }

    @Config(value="hive.orc.writer.stripe-max-rows")
    public OrcWriterConfig setStripeMaxRowCount(int stripeMaxRowCount) {
        this.options = this.options.withStripeMaxRowCount(stripeMaxRowCount);
        return this;
    }

    public int getRowGroupMaxRowCount() {
        return this.options.getRowGroupMaxRowCount();
    }

    @Config(value="hive.orc.writer.row-group-max-rows")
    public OrcWriterConfig setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
        this.options = this.options.withRowGroupMaxRowCount(rowGroupMaxRowCount);
        return this;
    }

    public DataSize getDictionaryMaxMemory() {
        return this.options.getDictionaryMaxMemory();
    }

    @Config(value="hive.orc.writer.dictionary-max-memory")
    public OrcWriterConfig setDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
        this.options = this.options.withDictionaryMaxMemory(dictionaryMaxMemory);
        return this;
    }

    public DataSize getStringStatisticsLimit() {
        return this.options.getMaxStringStatisticsLimit();
    }

    @Config(value="hive.orc.writer.string-statistics-limit")
    public OrcWriterConfig setStringStatisticsLimit(DataSize stringStatisticsLimit) {
        this.options = this.options.withMaxStringStatisticsLimit(stringStatisticsLimit);
        return this;
    }

    public DataSize getMaxCompressionBufferSize() {
        return this.options.getMaxCompressionBufferSize();
    }

    @Config(value="hive.orc.writer.max-compression-buffer-size")
    public OrcWriterConfig setMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
        this.options = this.options.withMaxCompressionBufferSize(maxCompressionBufferSize);
        return this;
    }

    public double getDefaultBloomFilterFpp() {
        return this.options.getBloomFilterFpp();
    }

    @Config(value="hive.orc.default-bloom-filter-fpp")
    @ConfigDescription(value="ORC Bloom filter false positive probability")
    public OrcWriterConfig setDefaultBloomFilterFpp(double defaultBloomFilterFpp) {
        this.options = this.options.withBloomFilterFpp(defaultBloomFilterFpp);
        return this;
    }

    @Deprecated
    public boolean isUseLegacyVersion() {
        return this.options.getWriterIdentification() == OrcWriterOptions.WriterIdentification.LEGACY_HIVE_COMPATIBLE;
    }

    @Deprecated
    @LegacyConfig(value={"hive.orc.writer.use-legacy-version-number"}, replacedBy="hive.orc.writer.writer-identification")
    @ConfigDescription(value="Write ORC files with a version number that is readable by Hive 2.0.0 to 2.2.0")
    public OrcWriterConfig setUseLegacyVersion(boolean useLegacyVersion) {
        this.options = this.options.withWriterIdentification(useLegacyVersion ? OrcWriterOptions.WriterIdentification.LEGACY_HIVE_COMPATIBLE : OrcWriterOptions.WriterIdentification.TRINO);
        return this;
    }

    @NotNull
    public OrcWriterOptions.WriterIdentification getWriterIdentification() {
        return this.options.getWriterIdentification();
    }

    @Config(value="hive.orc.writer.writer-identification")
    public OrcWriterConfig setWriterIdentification(OrcWriterOptions.WriterIdentification writerIdentification) {
        this.options = this.options.withWriterIdentification(writerIdentification);
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="100.0") double getValidationPercentage() {
        return this.validationPercentage;
    }

    @Config(value="hive.orc.writer.validation-percentage")
    @ConfigDescription(value="Percentage of ORC files to validate after write by re-reading the whole file")
    public OrcWriterConfig setValidationPercentage(double validationPercentage) {
        this.validationPercentage = validationPercentage;
        return this;
    }

    @NotNull
    public OrcWriteValidation.OrcWriteValidationMode getValidationMode() {
        return this.validationMode;
    }

    @Config(value="hive.orc.writer.validation-mode")
    @ConfigDescription(value="Level of detail in ORC validation. Lower levels require more memory.")
    public OrcWriterConfig setValidationMode(OrcWriteValidation.OrcWriteValidationMode validationMode) {
        this.validationMode = validationMode;
        return this;
    }
}

