/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import io.trino.orc.metadata.OrcType;
import io.trino.plugin.hive.coercions.BooleanCoercer;
import io.trino.plugin.hive.coercions.DateCoercer;
import io.trino.plugin.hive.coercions.DoubleToVarcharCoercer;
import io.trino.plugin.hive.coercions.IntegerNumberToDoubleCoercer;
import io.trino.plugin.hive.coercions.TimestampCoercer;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.coercions.VarcharToDoubleCoercer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;

public final class OrcTypeTranslator {
    private OrcTypeTranslator() {
    }

    public static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercer(OrcType.OrcTypeKind fromOrcType, Type toTrinoType) {
        if (fromOrcType == OrcType.OrcTypeKind.TIMESTAMP) {
            if (toTrinoType instanceof VarcharType) {
                VarcharType varcharType = (VarcharType)toTrinoType;
                return Optional.of(new TimestampCoercer.LongTimestampToVarcharCoercer(TimestampType.TIMESTAMP_NANOS, varcharType));
            }
            if (toTrinoType instanceof DateType) {
                DateType toDateType = (DateType)toTrinoType;
                return Optional.of(new TimestampCoercer.LongTimestampToDateCoercer(TimestampType.TIMESTAMP_NANOS, toDateType));
            }
            return Optional.empty();
        }
        if (OrcTypeTranslator.isVarcharType(fromOrcType)) {
            if (toTrinoType instanceof TimestampType) {
                TimestampType timestampType = (TimestampType)toTrinoType;
                if (timestampType.isShort()) {
                    return Optional.of(new TimestampCoercer.VarcharToShortTimestampCoercer(VarcharType.createUnboundedVarcharType(), timestampType));
                }
                return Optional.of(new TimestampCoercer.VarcharToLongTimestampCoercer(VarcharType.createUnboundedVarcharType(), timestampType));
            }
            if (toTrinoType instanceof DateType) {
                DateType toDateType = (DateType)toTrinoType;
                return Optional.of(new DateCoercer.VarcharToDateCoercer(VarcharType.createUnboundedVarcharType(), toDateType));
            }
            if (toTrinoType instanceof DoubleType) {
                return Optional.of(new VarcharToDoubleCoercer(VarcharType.createUnboundedVarcharType(), true));
            }
            return Optional.empty();
        }
        if (fromOrcType == OrcType.OrcTypeKind.DOUBLE && toTrinoType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)toTrinoType;
            return Optional.of(new DoubleToVarcharCoercer(varcharType, true));
        }
        if (fromOrcType == OrcType.OrcTypeKind.BOOLEAN && toTrinoType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)toTrinoType;
            return Optional.of(new BooleanCoercer.BooleanToVarcharCoercer(varcharType));
        }
        if (toTrinoType instanceof DoubleType) {
            if (fromOrcType == OrcType.OrcTypeKind.BYTE) {
                return Optional.of(new IntegerNumberToDoubleCoercer<TinyintType>(TinyintType.TINYINT));
            }
            if (fromOrcType == OrcType.OrcTypeKind.SHORT) {
                return Optional.of(new IntegerNumberToDoubleCoercer<SmallintType>(SmallintType.SMALLINT));
            }
            if (fromOrcType == OrcType.OrcTypeKind.INT) {
                return Optional.of(new IntegerNumberToDoubleCoercer<IntegerType>(IntegerType.INTEGER));
            }
            if (fromOrcType == OrcType.OrcTypeKind.LONG) {
                return Optional.of(new IntegerNumberToDoubleCoercer<BigintType>(BigintType.BIGINT));
            }
        }
        return Optional.empty();
    }

    private static boolean isVarcharType(OrcType.OrcTypeKind orcTypeKind) {
        return orcTypeKind == OrcType.OrcTypeKind.STRING || orcTypeKind == OrcType.OrcTypeKind.VARCHAR;
    }
}

