/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;

public class MetastoreKerberosConfig {
    private String hiveMetastoreServicePrincipal;
    private String hiveMetastoreClientPrincipal;
    private String hiveMetastoreClientKeytab;
    private String hiveMetastoreCredentialCachePath;

    @NotNull
    public String getHiveMetastoreServicePrincipal() {
        return this.hiveMetastoreServicePrincipal;
    }

    @Config(value="hive.metastore.service.principal")
    @ConfigDescription(value="Hive Metastore service principal")
    public MetastoreKerberosConfig setHiveMetastoreServicePrincipal(String hiveMetastoreServicePrincipal) {
        this.hiveMetastoreServicePrincipal = hiveMetastoreServicePrincipal;
        return this;
    }

    @NotNull
    public String getHiveMetastoreClientPrincipal() {
        return this.hiveMetastoreClientPrincipal;
    }

    @Config(value="hive.metastore.client.principal")
    @ConfigDescription(value="Hive Metastore client principal")
    public MetastoreKerberosConfig setHiveMetastoreClientPrincipal(String hiveMetastoreClientPrincipal) {
        this.hiveMetastoreClientPrincipal = hiveMetastoreClientPrincipal;
        return this;
    }

    public @NotNull Optional<@FileExists String> getHiveMetastoreClientKeytab() {
        return Optional.ofNullable(this.hiveMetastoreClientKeytab);
    }

    @Config(value="hive.metastore.client.keytab")
    @ConfigDescription(value="Hive Metastore client keytab location")
    public MetastoreKerberosConfig setHiveMetastoreClientKeytab(String hiveMetastoreClientKeytab) {
        this.hiveMetastoreClientKeytab = hiveMetastoreClientKeytab;
        return this;
    }

    public @NotNull Optional<@FileExists String> getHiveMetastoreClientCredentialCacheLocation() {
        return Optional.ofNullable(this.hiveMetastoreCredentialCachePath);
    }

    @Config(value="hive.metastore.client.credential-cache.location")
    @ConfigDescription(value="Hive Metastore client credential cache location")
    public MetastoreKerberosConfig setHiveMetastoreClientCredentialCacheLocation(String hiveMetastoreCredentialCachePath) {
        this.hiveMetastoreCredentialCachePath = hiveMetastoreCredentialCachePath;
        return this;
    }

    @AssertTrue(message="Exactly one of `hive.metastore.client.keytab` or `hive.metastore.client.credential-cache.location` must be specified")
    public @AssertTrue(message="Exactly one of `hive.metastore.client.keytab` or `hive.metastore.client.credential-cache.location` must be specified") boolean isConfigValid() {
        return this.getHiveMetastoreClientKeytab().isPresent() ^ this.getHiveMetastoreClientCredentialCacheLocation().isPresent();
    }
}

