/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableMap;
import io.trino.hive.thrift.metastore.DataOperationType;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.AcidTransactionOwner;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;

public interface HiveMetastore {
    public Optional<Database> getDatabase(String var1);

    public List<String> getAllDatabases();

    public Optional<Table> getTable(String var1, String var2);

    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type var1);

    public PartitionStatistics getTableStatistics(Table var1);

    public Map<String, PartitionStatistics> getPartitionStatistics(Table var1, List<Partition> var2);

    public void updateTableStatistics(String var1, String var2, AcidTransaction var3, Function<PartitionStatistics, PartitionStatistics> var4);

    default public void updatePartitionStatistics(Table table, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.updatePartitionStatistics(table, (Map<String, Function<PartitionStatistics, PartitionStatistics>>)ImmutableMap.of((Object)partitionName, update));
    }

    public void updatePartitionStatistics(Table var1, Map<String, Function<PartitionStatistics, PartitionStatistics>> var2);

    public List<String> getAllTables(String var1);

    public Optional<List<SchemaTableName>> getAllTables();

    public Map<String, RelationType> getRelationTypes(String var1);

    public Optional<Map<SchemaTableName, RelationType>> getRelationTypes();

    public List<String> getTablesWithParameter(String var1, String var2, String var3);

    public List<String> getAllViews(String var1);

    public Optional<List<SchemaTableName>> getAllViews();

    public void createDatabase(Database var1);

    public void dropDatabase(String var1, boolean var2);

    public void renameDatabase(String var1, String var2);

    public void setDatabaseOwner(String var1, HivePrincipal var2);

    public void createTable(Table var1, PrincipalPrivileges var2);

    public void dropTable(String var1, String var2, boolean var3);

    public void replaceTable(String var1, String var2, Table var3, PrincipalPrivileges var4);

    public void renameTable(String var1, String var2, String var3, String var4);

    public void commentTable(String var1, String var2, Optional<String> var3);

    public void setTableOwner(String var1, String var2, HivePrincipal var3);

    public void commentColumn(String var1, String var2, String var3, Optional<String> var4);

    public void addColumn(String var1, String var2, String var3, HiveType var4, String var5);

    public void renameColumn(String var1, String var2, String var3, String var4);

    public void dropColumn(String var1, String var2, String var3);

    public Optional<Partition> getPartition(Table var1, List<String> var2);

    public Optional<List<String>> getPartitionNamesByFilter(String var1, String var2, List<String> var3, TupleDomain<String> var4);

    public Map<String, Optional<Partition>> getPartitionsByNames(Table var1, List<String> var2);

    public void addPartitions(String var1, String var2, List<PartitionWithStatistics> var3);

    public void dropPartition(String var1, String var2, List<String> var3, boolean var4);

    public void alterPartition(String var1, String var2, PartitionWithStatistics var3);

    public void createRole(String var1, String var2);

    public void dropRole(String var1);

    public Set<String> listRoles();

    public void grantRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public void revokeRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public Set<RoleGrant> listRoleGrants(HivePrincipal var1);

    public void grantTablePrivileges(String var1, String var2, String var3, HivePrincipal var4, HivePrincipal var5, Set<HivePrivilegeInfo.HivePrivilege> var6, boolean var7);

    public void revokeTablePrivileges(String var1, String var2, String var3, HivePrincipal var4, HivePrincipal var5, Set<HivePrivilegeInfo.HivePrivilege> var6, boolean var7);

    public Set<HivePrivilegeInfo> listTablePrivileges(String var1, String var2, Optional<String> var3, Optional<HivePrincipal> var4);

    default public void checkSupportsTransactions() {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, this.getClass().getSimpleName() + " does not support ACID tables");
    }

    default public long openTransaction(AcidTransactionOwner transactionOwner) {
        throw new UnsupportedOperationException();
    }

    default public void commitTransaction(long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void abortTransaction(long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void sendTransactionHeartbeat(long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void acquireSharedReadLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        throw new UnsupportedOperationException();
    }

    default public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        throw new UnsupportedOperationException();
    }

    default public Optional<String> getConfigValue(String name) {
        return Optional.empty();
    }

    default public long allocateWriteId(String dbName, String tableName, long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        throw new UnsupportedOperationException();
    }

    default public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        throw new UnsupportedOperationException();
    }

    default public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        throw new UnsupportedOperationException();
    }

    default public void alterTransactionalTable(Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        throw new UnsupportedOperationException();
    }

    public boolean functionExists(String var1, String var2, String var3);

    public Collection<LanguageFunction> getFunctions(String var1);

    public Collection<LanguageFunction> getFunctions(String var1, String var2);

    public void createFunction(String var1, String var2, LanguageFunction var3);

    public void replaceFunction(String var1, String var2, LanguageFunction var3);

    public void dropFunction(String var1, String var2, String var3);
}

