/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;

public class VarcharCoercer
extends TypeCoercer<VarcharType, VarcharType> {
    public VarcharCoercer(VarcharType fromType, VarcharType toType) {
        super(fromType, toType);
        Preconditions.checkArgument((boolean)CoercionUtils.narrowerThan(toType, fromType), (Object)"Coercer to a wider varchar type should not be required");
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        Slice value = ((VarcharType)this.fromType).getSlice(block, position);
        ((VarcharType)this.toType).writeSlice(blockBuilder, Varchars.truncateToLength((Slice)value, (VarcharType)((VarcharType)this.toType)));
    }
}

