/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;

public class IntegerNumberToVarcharCoercer<F extends Type>
extends TypeCoercer<F, VarcharType> {
    public IntegerNumberToVarcharCoercer(F fromType, VarcharType toType) {
        super(fromType, toType);
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        long value = this.fromType.getLong(block, position);
        Slice converted = Slices.utf8Slice((String)String.valueOf(value));
        if (!((VarcharType)this.toType).isUnbounded() && SliceUtf8.countCodePoints((Slice)converted) > ((VarcharType)this.toType).getBoundedLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Varchar representation of %s exceeds %s bounds", value, this.toType));
        }
        ((VarcharType)this.toType).writeSlice(blockBuilder, converted);
    }
}

