/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;

public class FloatToDoubleCoercer
extends TypeCoercer<RealType, DoubleType> {
    public FloatToDoubleCoercer() {
        super(RealType.REAL, DoubleType.DOUBLE);
    }

    @Override
    public Block apply(Block block) {
        if (block instanceof LongArrayBlock) {
            return block;
        }
        return super.apply(block);
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        DoubleType.DOUBLE.writeDouble(blockBuilder, (double)RealType.REAL.getFloat(block, position));
    }
}

