/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DateType;
import io.trino.spi.type.VarcharType;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class DateCoercer {
    private static final long START_OF_MODERN_ERA_DAYS = LocalDate.of(1900, 1, 1).toEpochDay();

    private DateCoercer() {
    }

    public static class VarcharToDateCoercer
    extends TypeCoercer<VarcharType, DateType> {
        public VarcharToDateCoercer(VarcharType fromType, DateType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            String value = ((VarcharType)this.fromType).getSlice(block, position).toStringUtf8();
            try {
                LocalDate localDate = DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)value, LocalDate::from);
                if (localDate.toEpochDay() < START_OF_MODERN_ERA_DAYS) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_TIMESTAMP_COERCION, "Coercion on historical dates is not supported");
                }
                ((DateType)this.toType).writeLong(blockBuilder, localDate.toEpochDay());
            }
            catch (DateTimeParseException ignored) {
                throw new IllegalArgumentException("Invalid date value: " + value + " is not a valid date");
            }
        }
    }
}

