/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;

public class SchemaAlreadyExistsException
extends TrinoException {
    private final String schemaName;

    public SchemaAlreadyExistsException(String schemaName) {
        this(schemaName, null);
    }

    public SchemaAlreadyExistsException(String schemaName, Throwable cause) {
        this(schemaName, String.format("Schema already exists: '%s'", schemaName), cause);
    }

    public SchemaAlreadyExistsException(String schemaName, String message, Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, message, cause);
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }
}

