/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import java.util.UUID;

public class HiveTransactionHandle
implements ConnectorTransactionHandle {
    private final boolean autoCommit;
    private final UUID uuid;

    public HiveTransactionHandle(boolean autoCommit) {
        this(autoCommit, UUID.randomUUID());
    }

    @JsonCreator
    public HiveTransactionHandle(@JsonProperty(value="autoCommit") boolean autoCommit, @JsonProperty(value="uuid") UUID uuid) {
        this.autoCommit = autoCommit;
        this.uuid = Objects.requireNonNull(uuid, "uuid is null");
    }

    @JsonProperty
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @JsonProperty
    public UUID getUuid() {
        return this.uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTransactionHandle that = (HiveTransactionHandle)o;
        return this.autoCommit == that.autoCommit && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.autoCommit, this.uuid);
    }

    public String toString() {
        return this.uuid.toString();
    }
}

