/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public final class HiveToTrinoTranslator {
    private final PeekingIterator<Character> input;
    private final StringBuilder output = new StringBuilder();

    public static String translateHiveViewToTrino(String hiveStatement) {
        HiveToTrinoTranslator translator = new HiveToTrinoTranslator(hiveStatement);
        return translator.translateQuotedLiterals();
    }

    private HiveToTrinoTranslator(String hiveQl) {
        this.input = Iterators.peekingIterator((Iterator)Lists.charactersOf((String)hiveQl).iterator());
    }

    private String translateQuotedLiterals() {
        block4: while (this.input.hasNext()) {
            char c = ((Character)this.input.next()).charValue();
            switch (c) {
                case '\"': 
                case '\'': {
                    this.translateString(c);
                    continue block4;
                }
                case '`': {
                    this.translateQuotedIdentifier();
                    continue block4;
                }
            }
            this.output.append(c);
        }
        return this.output.toString();
    }

    private void translateString(char delimiter) {
        StringBuilder string = new StringBuilder(String.valueOf(delimiter));
        while (this.input.hasNext()) {
            char c = ((Character)this.input.next()).charValue();
            if (c == delimiter) {
                string.append(delimiter);
                String unescaped = HiveToTrinoTranslator.unescapeSqlString(string.toString());
                this.output.append("'");
                this.output.append(unescaped.replace("'", "''"));
                this.output.append("'");
                return;
            }
            string.append(c);
            if (c != '\\') continue;
            if (!this.input.hasNext()) break;
            string.append(this.input.next());
        }
        throw HiveToTrinoTranslator.hiveViewParseError("unexpected end of input in string");
    }

    private void translateQuotedIdentifier() {
        this.output.append('\"');
        while (this.input.hasNext()) {
            char c = ((Character)this.input.next()).charValue();
            if (c == '\"') {
                this.output.append("\"\"");
                continue;
            }
            if (c == '`' && this.input.hasNext() && ((Character)this.input.peek()).charValue() == '`') {
                this.output.append('`');
                this.input.next();
                continue;
            }
            if (c == '`') {
                this.output.append('\"');
                return;
            }
            this.output.append(c);
        }
        throw HiveToTrinoTranslator.hiveViewParseError("unexpected end of input in identifier");
    }

    private static TrinoException hiveViewParseError(String message) {
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_VIEW_TRANSLATION_ERROR, "Error translating Hive view to Trino: " + message);
    }

    public static String unescapeSqlString(String b) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(b.length());
        for (int i = 0; i < b.length(); ++i) {
            char currentChar = b.charAt(i);
            if (enclosure == null) {
                if (currentChar != '\'' && b.charAt(i) != '\"') continue;
                enclosure = Character.valueOf(currentChar);
                continue;
            }
            if (enclosure.equals(Character.valueOf(currentChar))) {
                enclosure = null;
                continue;
            }
            if (currentChar == '\\' && i + 6 < b.length() && b.charAt(i + 1) == 'u') {
                int code = 0;
                int base = i + 2;
                for (int j = 0; j < 4; ++j) {
                    int digit = Character.digit(b.charAt(j + base), 16);
                    code = (code << 4) + digit;
                }
                sb.append((char)code);
                i += 5;
                continue;
            }
            if (currentChar == '\\' && i + 4 < b.length()) {
                char i1 = b.charAt(i + 1);
                char i2 = b.charAt(i + 2);
                char i3 = b.charAt(i + 3);
                if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                    byte value = (byte)(i3 - 48 + (i2 - 48) * 8 + (i1 - 48) * 8 * 8);
                    sb.append(new String(new byte[]{value}, StandardCharsets.UTF_8));
                    i += 3;
                    continue;
                }
            }
            if (currentChar == '\\' && i + 2 < b.length()) {
                char n = b.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("\\%");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }
}

