/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Verify;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveWritableTableHandle;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.HivePageSinkMetadata;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveTableExecuteHandle
extends HiveWritableTableHandle
implements ConnectorTableExecuteHandle {
    private final String procedureName;
    private final Optional<String> writeDeclarationId;
    private final Optional<Long> maxScannedFileSize;

    @JsonCreator
    public HiveTableExecuteHandle(@JsonProperty(value="procedureName") String procedureName, @JsonProperty(value="writeDeclarationId") Optional<String> writeDeclarationId, @JsonProperty(value="maxScannedFileSize") Optional<Long> maxScannedFileSize, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="inputColumns") List<HiveColumnHandle> inputColumns, @JsonProperty(value="pageSinkMetadata") HivePageSinkMetadata pageSinkMetadata, @JsonProperty(value="locationHandle") LocationHandle locationHandle, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="tableStorageFormat") HiveStorageFormat tableStorageFormat, @JsonProperty(value="partitionStorageFormat") HiveStorageFormat partitionStorageFormat, @JsonProperty(value="transaction") AcidTransaction transaction, @JsonProperty(value="retriesEnabled") boolean retriesEnabled) {
        super(schemaName, tableName, inputColumns, pageSinkMetadata, locationHandle, bucketProperty, tableStorageFormat, partitionStorageFormat, transaction, retriesEnabled);
        Verify.verify((boolean)bucketProperty.isEmpty(), (String)"bucketed tables not supported yet", (Object[])new Object[0]);
        this.procedureName = Objects.requireNonNull(procedureName, "procedureName is null");
        this.writeDeclarationId = Objects.requireNonNull(writeDeclarationId, "writeDeclarationId is null");
        this.maxScannedFileSize = Objects.requireNonNull(maxScannedFileSize, "maxScannedFileSize is null");
    }

    @JsonProperty
    public String getProcedureName() {
        return this.procedureName;
    }

    @JsonProperty
    public Optional<String> getWriteDeclarationId() {
        return this.writeDeclarationId;
    }

    @JsonProperty
    public Optional<Long> getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    public HiveTableExecuteHandle withWriteDeclarationId(String writeDeclarationId) {
        return new HiveTableExecuteHandle(this.procedureName, Optional.of(writeDeclarationId), this.maxScannedFileSize, this.getSchemaName(), this.getTableName(), this.getInputColumns(), this.getPageSinkMetadata(), this.getLocationHandle(), this.getBucketProperty(), this.getTableStorageFormat(), this.getPartitionStorageFormat(), this.getTransaction(), this.isRetriesEnabled());
    }

    @Override
    public String toString() {
        return this.procedureName + "(" + this.getSchemaName() + "." + this.getTableName() + ")";
    }
}

