/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;

public class HiveLocationService
implements LocationService {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final boolean temporaryStagingDirectoryEnabled;
    private final String temporaryStagingDirectoryPath;

    @Inject
    public HiveLocationService(TrinoFileSystemFactory fileSystemFactory, HiveConfig hiveConfig) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.temporaryStagingDirectoryEnabled = hiveConfig.isTemporaryStagingDirectoryEnabled();
        this.temporaryStagingDirectoryPath = hiveConfig.getTemporaryStagingDirectoryPath();
    }

    @Override
    public Location forNewTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName) {
        Location targetPath;
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        if (HiveWriteUtils.directoryExists(fileSystem, targetPath = HiveWriteUtils.getTableDefaultLocation(metastore, fileSystem, schemaName, tableName)).orElse(false).booleanValue()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        return targetPath;
    }

    @Override
    public LocationHandle forNewTableAsSelect(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName, Optional<Location> externalLocation) {
        Optional<Location> writePath;
        Location targetPath;
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        if (HiveWriteUtils.directoryExists(fileSystem, targetPath = externalLocation.orElseGet(() -> HiveWriteUtils.getTableDefaultLocation(metastore, fileSystem, schemaName, tableName))).orElse(false).booleanValue()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        if (this.temporaryStagingDirectoryEnabled && externalLocation.isEmpty() && (writePath = HiveWriteUtils.createTemporaryPath(fileSystem, session.getIdentity(), targetPath, this.temporaryStagingDirectoryPath)).isPresent()) {
            return new LocationHandle(targetPath, writePath.get(), LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
    }

    @Override
    public LocationHandle forExistingTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        Optional<Location> writePath;
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        Location targetPath = Location.of((String)table.getStorage().getLocation());
        if (this.temporaryStagingDirectoryEnabled && !AcidTables.isTransactionalTable(table.getParameters()) && (writePath = HiveWriteUtils.createTemporaryPath(fileSystem, session.getIdentity(), targetPath, this.temporaryStagingDirectoryPath)).isPresent()) {
            return new LocationHandle(targetPath, writePath.get(), LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
    }

    @Override
    public LocationHandle forOptimize(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        Location targetPath = Location.of((String)table.getStorage().getLocation());
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
    }

    @Override
    public LocationService.WriteInfo getQueryWriteInfo(LocationHandle locationHandle) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getTableWriteInfo(LocationHandle locationHandle, boolean overwrite) {
        if (overwrite && locationHandle.getWriteMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Overwriting unpartitioned table not supported when writing directly to target directory");
        }
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getPartitionWriteInfo(LocationHandle locationHandle, Optional<Partition> partition, String partitionName) {
        if (partition.isPresent()) {
            LocationHandle.WriteMode writeMode = locationHandle.getWriteMode();
            Location targetPath = Location.of((String)partition.get().getStorage().getLocation());
            Location writePath = HiveLocationService.getPartitionWritePath(locationHandle, partitionName, writeMode, targetPath);
            return new LocationService.WriteInfo(targetPath, writePath, writeMode);
        }
        return new LocationService.WriteInfo(locationHandle.getTargetPath().appendPath(partitionName), locationHandle.getWritePath().appendPath(partitionName), locationHandle.getWriteMode());
    }

    private static Location getPartitionWritePath(LocationHandle locationHandle, String partitionName, LocationHandle.WriteMode writeMode, Location targetPath) {
        return switch (writeMode) {
            default -> throw new IncompatibleClassChangeError();
            case LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY -> locationHandle.getWritePath().appendPath(partitionName);
            case LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY -> targetPath;
            case LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY -> throw new UnsupportedOperationException(String.format("inserting into existing partition is not supported for %s", new Object[]{writeMode}));
        };
    }
}

