/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.trino.plugin.base.Versions;
import io.trino.plugin.hive.InternalHiveConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;

public class HiveConnectorFactory
implements ConnectorFactory {
    private final Module module;

    public HiveConnectorFactory() {
        this(Modules.EMPTY_MODULE);
    }

    public HiveConnectorFactory(Module module) {
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public String getName() {
        return "hive";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        return InternalHiveConnectorFactory.createConnector(catalogName, config, context, this.module);
    }
}

