/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.projection.ApplyProjectionUtil;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.spi.connector.ColumnHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class HiveApplyProjectionUtil {
    private HiveApplyProjectionUtil() {
    }

    public static Optional<String> find(Map<String, ColumnHandle> assignments, ApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn) {
        HiveColumnHandle variableColumn = (HiveColumnHandle)assignments.get(projectedColumn.getVariable().getName());
        if (variableColumn == null) {
            return Optional.empty();
        }
        String baseColumnName = variableColumn.getBaseColumnName();
        List variableColumnIndices = variableColumn.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
        ImmutableList projectionIndices = ImmutableList.builder().addAll((Iterable)variableColumnIndices).addAll((Iterable)projectedColumn.getDereferenceIndices()).build();
        for (Map.Entry<String, ColumnHandle> entry : assignments.entrySet()) {
            HiveColumnHandle column = (HiveColumnHandle)entry.getValue();
            if (!column.getBaseColumnName().equals(baseColumnName) || !column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of()).equals(projectionIndices)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }
}

