/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Iterator;
import java.util.Objects;

public class ConcurrentLazyQueue<E> {
    @GuardedBy(value="this")
    private final Iterator<E> iterator;

    public ConcurrentLazyQueue(Iterator<E> iterator) {
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
    }

    public synchronized boolean isEmpty() {
        return !this.iterator.hasNext();
    }

    public synchronized E poll() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        return this.iterator.next();
    }
}

