/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class Int32ShortDecimalValueWriter
extends PrimitiveValueWriter {
    private final DecimalType decimalType;

    public Int32ShortDecimalValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.decimalType = (DecimalType)Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((this.decimalType.getPrecision() <= 9 ? 1 : 0) != 0, (String)"decimalType precision %s must be <= 9", (int)this.decimalType.getPrecision());
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            int value = Math.toIntExact(this.decimalType.getLong(block, i));
            this.getValueWriter().writeInteger(value);
            this.getStatistics().updateStats(value);
        }
    }
}

