/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.repdef;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.apache.parquet.column.values.ValuesWriter;

public interface DefLevelWriterProvider {
    public DefinitionLevelWriter getDefinitionLevelWriter(Optional<DefinitionLevelWriter> var1, ValuesWriter var2);

    public static DefinitionLevelWriter getRootDefinitionLevelWriter(List<DefLevelWriterProvider> defLevelWriterProviders, ValuesWriter encoder) {
        DefinitionLevelWriter rootDefinitionLevelWriter = ((DefLevelWriterProvider)Iterables.getLast(defLevelWriterProviders)).getDefinitionLevelWriter(Optional.empty(), encoder);
        for (int nestedLevel = defLevelWriterProviders.size() - 2; nestedLevel >= 0; --nestedLevel) {
            DefinitionLevelWriter nestedWriter = rootDefinitionLevelWriter;
            rootDefinitionLevelWriter = defLevelWriterProviders.get(nestedLevel).getDefinitionLevelWriter(Optional.of(nestedWriter), encoder);
        }
        return rootDefinitionLevelWriter;
    }

    public static interface DefinitionLevelWriter {
        public ValuesCount writeDefinitionLevels(int var1);

        public ValuesCount writeDefinitionLevels();
    }

    public record ValuesCount(int totalValuesCount, int maxDefinitionLevelValuesCount) {
    }
}

