/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.writer.repdef.DefLevelWriterProvider;
import io.trino.parquet.writer.repdef.RepLevelWriterProvider;
import io.trino.spi.block.Block;
import java.util.List;
import java.util.Objects;

public class ColumnChunk {
    private final Block block;
    private final List<DefLevelWriterProvider> defLevelWriterProviders;
    private final List<RepLevelWriterProvider> repLevelWriterProviders;

    ColumnChunk(Block block) {
        this(block, (List<DefLevelWriterProvider>)ImmutableList.of(), (List<RepLevelWriterProvider>)ImmutableList.of());
    }

    ColumnChunk(Block block, List<DefLevelWriterProvider> defLevelWriterProviders, List<RepLevelWriterProvider> repLevelWriterProviders) {
        this.block = Objects.requireNonNull(block, "block is null");
        this.defLevelWriterProviders = ImmutableList.copyOf(defLevelWriterProviders);
        this.repLevelWriterProviders = ImmutableList.copyOf(repLevelWriterProviders);
    }

    List<DefLevelWriterProvider> getDefLevelWriterProviders() {
        return this.defLevelWriterProviders;
    }

    public List<RepLevelWriterProvider> getRepLevelWriterProviders() {
        return this.repLevelWriterProviders;
    }

    public Block getBlock() {
        return this.block;
    }
}

