/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.airlift.slice.Slice;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.flat.BitPackingUtils;
import io.trino.parquet.reader.flat.FlatDefinitionLevelDecoder;
import java.util.Arrays;
import java.util.Objects;

public class NullsDecoder
implements FlatDefinitionLevelDecoder {
    private SimpleSliceInputStream input;
    private boolean isRle;
    private int valuesLeftInGroup;
    private boolean rleValue;
    private byte bitPackedValue;
    private int bitPackedValueOffset;

    @Override
    public void init(Slice input) {
        this.input = new SimpleSliceInputStream(Objects.requireNonNull(input, "input is null"));
    }

    @Override
    public int readNext(boolean[] values, int offset, int length) {
        int nonNullCount = 0;
        while (length > 0) {
            int leftToRead;
            int chunkSize;
            if (this.valuesLeftInGroup == 0) {
                this.readGroupHeader();
            }
            if (this.isRle) {
                chunkSize = Math.min(length, this.valuesLeftInGroup);
                if (this.rleValue) {
                    Arrays.fill(values, offset, offset + chunkSize, true);
                }
                nonNullCount += ParquetReaderUtils.castToByteNegate(this.rleValue) * chunkSize;
                this.valuesLeftInGroup -= chunkSize;
                length -= chunkSize;
                offset += chunkSize;
                continue;
            }
            if (this.bitPackedValueOffset != 0) {
                int remainingBits = 8 - this.bitPackedValueOffset;
                int chunkSize2 = Math.min(remainingBits, length);
                nonNullCount += BitPackingUtils.unpack(values, offset, this.bitPackedValue, this.bitPackedValueOffset, this.bitPackedValueOffset + chunkSize2);
                this.valuesLeftInGroup -= chunkSize2;
                this.bitPackedValueOffset = (this.bitPackedValueOffset + chunkSize2) % 8;
                offset += chunkSize2;
                length -= chunkSize2;
                continue;
            }
            for (leftToRead = chunkSize = Math.min(length, this.valuesLeftInGroup); leftToRead >= 64; leftToRead -= 64) {
                nonNullCount += BitPackingUtils.unpack(values, offset, this.input.readLong() ^ 0xFFFFFFFFFFFFFFFFL);
                offset += 64;
            }
            while (leftToRead >= 8) {
                nonNullCount += BitPackingUtils.unpack(values, offset, ~this.input.readByte());
                offset += 8;
                leftToRead -= 8;
            }
            if (leftToRead > 0) {
                this.bitPackedValue = ~this.input.readByte();
                nonNullCount += BitPackingUtils.unpack(values, offset, this.bitPackedValue, 0, leftToRead);
                this.bitPackedValueOffset += leftToRead;
                offset += leftToRead;
            }
            this.valuesLeftInGroup -= chunkSize;
            length -= chunkSize;
        }
        return nonNullCount;
    }

    @Override
    public int skip(int length) {
        int nonNullCount = 0;
        while (length > 0) {
            int leftToRead;
            int chunkSize;
            if (this.valuesLeftInGroup == 0) {
                this.readGroupHeader();
            }
            if (this.isRle) {
                chunkSize = Math.min(length, this.valuesLeftInGroup);
                nonNullCount += ParquetReaderUtils.castToByteNegate(this.rleValue) * chunkSize;
                this.valuesLeftInGroup -= chunkSize;
                length -= chunkSize;
                continue;
            }
            if (this.bitPackedValueOffset != 0) {
                int remainingBits = 8 - this.bitPackedValueOffset;
                int chunkSize2 = Math.min(remainingBits, length);
                int remainingPackedValue = (this.bitPackedValue & 0xFF) >>> this.bitPackedValueOffset;
                nonNullCount += chunkSize2 - BitPackingUtils.bitCount((byte)(remainingPackedValue & (1 << chunkSize2) - 1));
                this.valuesLeftInGroup -= chunkSize2;
                this.bitPackedValueOffset = (this.bitPackedValueOffset + chunkSize2) % 8;
                length -= chunkSize2;
                continue;
            }
            for (leftToRead = chunkSize = Math.min(length, this.valuesLeftInGroup); leftToRead >= 64; leftToRead -= 64) {
                nonNullCount += Long.bitCount(this.input.readLong());
            }
            while (leftToRead >= 8) {
                nonNullCount += BitPackingUtils.bitCount(this.input.readByte());
                leftToRead -= 8;
            }
            if (leftToRead > 0) {
                byte packedValue = this.input.readByte();
                nonNullCount += BitPackingUtils.bitCount((byte)(packedValue & (1 << leftToRead) - 1));
                this.bitPackedValue = ~packedValue;
                this.bitPackedValueOffset += leftToRead;
            }
            this.valuesLeftInGroup -= chunkSize;
            length -= chunkSize;
        }
        return nonNullCount;
    }

    private void readGroupHeader() {
        int header = ParquetReaderUtils.readUleb128Int(this.input);
        this.isRle = (header & 1) == 0;
        this.valuesLeftInGroup = header >>> 1;
        if (this.isRle) {
            this.rleValue = this.input.readByte() == 0;
        } else {
            this.valuesLeftInGroup *= 8;
        }
    }
}

