/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.LongBitUnpacker;

public final class LongBitUnpackers {
    private static final LongBitUnpacker[] UNPACKERS = new LongBitUnpacker[]{new Unpacker1(), new Unpacker2(), new Unpacker3(), new Unpacker4(), new Unpacker5(), new Unpacker6(), new Unpacker7(), new Unpacker8(), new Unpacker9(), new Unpacker10(), new Unpacker11(), new Unpacker12(), new Unpacker13(), new Unpacker14(), new Unpacker15(), new Unpacker16(), new Unpacker17(), new Unpacker18(), new Unpacker19(), new Unpacker20(), new Unpacker21(), new Unpacker22(), new Unpacker23(), new Unpacker24(), new Unpacker25(), new Unpacker26(), new Unpacker27(), new Unpacker28(), new Unpacker29(), new Unpacker30(), new Unpacker31(), new Unpacker32(), new Unpacker33(), new Unpacker34(), new Unpacker35(), new Unpacker36(), new Unpacker37(), new Unpacker38(), new Unpacker39(), new Unpacker40(), new Unpacker41(), new Unpacker42(), new Unpacker43(), new Unpacker44(), new Unpacker45(), new Unpacker46(), new Unpacker47(), new Unpacker48(), new Unpacker49(), new Unpacker50(), new Unpacker51(), new Unpacker52(), new Unpacker53(), new Unpacker54(), new Unpacker55(), new Unpacker56(), new Unpacker57(), new Unpacker58(), new Unpacker59(), new Unpacker60(), new Unpacker61(), new Unpacker62(), new Unpacker63(), new Unpacker64()};

    public static LongBitUnpacker getLongBitUnpacker(int bitWidth) {
        Preconditions.checkArgument((bitWidth > 0 && bitWidth <= 64 ? 1 : 0) != 0, (String)"bitWidth %s should be in the range 1-64", (int)bitWidth);
        return UNPACKERS[bitWidth - 1];
    }

    private LongBitUnpackers() {
    }

    private static final class Unpacker1
    implements LongBitUnpacker {
        private Unpacker1() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker1.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            output[outputOffset] = (long)v0 & 1L;
            output[outputOffset + 1] = (long)(v0 >>> 1) & 1L;
            output[outputOffset + 2] = (long)(v0 >>> 2) & 1L;
            output[outputOffset + 3] = (long)(v0 >>> 3) & 1L;
            output[outputOffset + 4] = (long)(v0 >>> 4) & 1L;
            output[outputOffset + 5] = (long)(v0 >>> 5) & 1L;
            output[outputOffset + 6] = (long)(v0 >>> 6) & 1L;
            output[outputOffset + 7] = (long)(v0 >>> 7) & 1L;
            output[outputOffset + 8] = (long)(v0 >>> 8) & 1L;
            output[outputOffset + 9] = (long)(v0 >>> 9) & 1L;
            output[outputOffset + 10] = (long)(v0 >>> 10) & 1L;
            output[outputOffset + 11] = (long)(v0 >>> 11) & 1L;
            output[outputOffset + 12] = (long)(v0 >>> 12) & 1L;
            output[outputOffset + 13] = (long)(v0 >>> 13) & 1L;
            output[outputOffset + 14] = (long)(v0 >>> 14) & 1L;
            output[outputOffset + 15] = (long)(v0 >>> 15) & 1L;
            output[outputOffset + 16] = (long)(v0 >>> 16) & 1L;
            output[outputOffset + 17] = (long)(v0 >>> 17) & 1L;
            output[outputOffset + 18] = (long)(v0 >>> 18) & 1L;
            output[outputOffset + 19] = (long)(v0 >>> 19) & 1L;
            output[outputOffset + 20] = (long)(v0 >>> 20) & 1L;
            output[outputOffset + 21] = (long)(v0 >>> 21) & 1L;
            output[outputOffset + 22] = (long)(v0 >>> 22) & 1L;
            output[outputOffset + 23] = (long)(v0 >>> 23) & 1L;
            output[outputOffset + 24] = (long)(v0 >>> 24) & 1L;
            output[outputOffset + 25] = (long)(v0 >>> 25) & 1L;
            output[outputOffset + 26] = (long)(v0 >>> 26) & 1L;
            output[outputOffset + 27] = (long)(v0 >>> 27) & 1L;
            output[outputOffset + 28] = (long)(v0 >>> 28) & 1L;
            output[outputOffset + 29] = (long)(v0 >>> 29) & 1L;
            output[outputOffset + 30] = (long)(v0 >>> 30) & 1L;
            output[outputOffset + 31] = (long)(v0 >>> 31) & 1L;
        }
    }

    private static final class Unpacker2
    implements LongBitUnpacker {
        private Unpacker2() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker2.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            output[outputOffset] = v0 & 3L;
            output[outputOffset + 1] = v0 >>> 2 & 3L;
            output[outputOffset + 2] = v0 >>> 4 & 3L;
            output[outputOffset + 3] = v0 >>> 6 & 3L;
            output[outputOffset + 4] = v0 >>> 8 & 3L;
            output[outputOffset + 5] = v0 >>> 10 & 3L;
            output[outputOffset + 6] = v0 >>> 12 & 3L;
            output[outputOffset + 7] = v0 >>> 14 & 3L;
            output[outputOffset + 8] = v0 >>> 16 & 3L;
            output[outputOffset + 9] = v0 >>> 18 & 3L;
            output[outputOffset + 10] = v0 >>> 20 & 3L;
            output[outputOffset + 11] = v0 >>> 22 & 3L;
            output[outputOffset + 12] = v0 >>> 24 & 3L;
            output[outputOffset + 13] = v0 >>> 26 & 3L;
            output[outputOffset + 14] = v0 >>> 28 & 3L;
            output[outputOffset + 15] = v0 >>> 30 & 3L;
            output[outputOffset + 16] = v0 >>> 32 & 3L;
            output[outputOffset + 17] = v0 >>> 34 & 3L;
            output[outputOffset + 18] = v0 >>> 36 & 3L;
            output[outputOffset + 19] = v0 >>> 38 & 3L;
            output[outputOffset + 20] = v0 >>> 40 & 3L;
            output[outputOffset + 21] = v0 >>> 42 & 3L;
            output[outputOffset + 22] = v0 >>> 44 & 3L;
            output[outputOffset + 23] = v0 >>> 46 & 3L;
            output[outputOffset + 24] = v0 >>> 48 & 3L;
            output[outputOffset + 25] = v0 >>> 50 & 3L;
            output[outputOffset + 26] = v0 >>> 52 & 3L;
            output[outputOffset + 27] = v0 >>> 54 & 3L;
            output[outputOffset + 28] = v0 >>> 56 & 3L;
            output[outputOffset + 29] = v0 >>> 58 & 3L;
            output[outputOffset + 30] = v0 >>> 60 & 3L;
            output[outputOffset + 31] = v0 >>> 62 & 3L;
        }
    }

    private static final class Unpacker3
    implements LongBitUnpacker {
        private Unpacker3() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker3.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            output[outputOffset] = v0 & 7L;
            output[outputOffset + 1] = v0 >>> 3 & 7L;
            output[outputOffset + 2] = v0 >>> 6 & 7L;
            output[outputOffset + 3] = v0 >>> 9 & 7L;
            output[outputOffset + 4] = v0 >>> 12 & 7L;
            output[outputOffset + 5] = v0 >>> 15 & 7L;
            output[outputOffset + 6] = v0 >>> 18 & 7L;
            output[outputOffset + 7] = v0 >>> 21 & 7L;
            output[outputOffset + 8] = v0 >>> 24 & 7L;
            output[outputOffset + 9] = v0 >>> 27 & 7L;
            output[outputOffset + 10] = v0 >>> 30 & 7L;
            output[outputOffset + 11] = v0 >>> 33 & 7L;
            output[outputOffset + 12] = v0 >>> 36 & 7L;
            output[outputOffset + 13] = v0 >>> 39 & 7L;
            output[outputOffset + 14] = v0 >>> 42 & 7L;
            output[outputOffset + 15] = v0 >>> 45 & 7L;
            output[outputOffset + 16] = v0 >>> 48 & 7L;
            output[outputOffset + 17] = v0 >>> 51 & 7L;
            output[outputOffset + 18] = v0 >>> 54 & 7L;
            output[outputOffset + 19] = v0 >>> 57 & 7L;
            output[outputOffset + 20] = v0 >>> 60 & 7L;
            output[outputOffset + 21] = v0 >>> 63 & 1L | ((long)v1 & 3L) << 1;
            output[outputOffset + 22] = (long)(v1 >>> 2) & 7L;
            output[outputOffset + 23] = (long)(v1 >>> 5) & 7L;
            output[outputOffset + 24] = (long)(v1 >>> 8) & 7L;
            output[outputOffset + 25] = (long)(v1 >>> 11) & 7L;
            output[outputOffset + 26] = (long)(v1 >>> 14) & 7L;
            output[outputOffset + 27] = (long)(v1 >>> 17) & 7L;
            output[outputOffset + 28] = (long)(v1 >>> 20) & 7L;
            output[outputOffset + 29] = (long)(v1 >>> 23) & 7L;
            output[outputOffset + 30] = (long)(v1 >>> 26) & 7L;
            output[outputOffset + 31] = (long)(v1 >>> 29) & 7L;
        }
    }

    private static final class Unpacker4
    implements LongBitUnpacker {
        private Unpacker4() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker4.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            output[outputOffset] = v0 & 0xFL;
            output[outputOffset + 1] = v0 >>> 4 & 0xFL;
            output[outputOffset + 2] = v0 >>> 8 & 0xFL;
            output[outputOffset + 3] = v0 >>> 12 & 0xFL;
            output[outputOffset + 4] = v0 >>> 16 & 0xFL;
            output[outputOffset + 5] = v0 >>> 20 & 0xFL;
            output[outputOffset + 6] = v0 >>> 24 & 0xFL;
            output[outputOffset + 7] = v0 >>> 28 & 0xFL;
            output[outputOffset + 8] = v0 >>> 32 & 0xFL;
            output[outputOffset + 9] = v0 >>> 36 & 0xFL;
            output[outputOffset + 10] = v0 >>> 40 & 0xFL;
            output[outputOffset + 11] = v0 >>> 44 & 0xFL;
            output[outputOffset + 12] = v0 >>> 48 & 0xFL;
            output[outputOffset + 13] = v0 >>> 52 & 0xFL;
            output[outputOffset + 14] = v0 >>> 56 & 0xFL;
            output[outputOffset + 15] = v0 >>> 60 & 0xFL;
            output[outputOffset + 16] = v1 & 0xFL;
            output[outputOffset + 17] = v1 >>> 4 & 0xFL;
            output[outputOffset + 18] = v1 >>> 8 & 0xFL;
            output[outputOffset + 19] = v1 >>> 12 & 0xFL;
            output[outputOffset + 20] = v1 >>> 16 & 0xFL;
            output[outputOffset + 21] = v1 >>> 20 & 0xFL;
            output[outputOffset + 22] = v1 >>> 24 & 0xFL;
            output[outputOffset + 23] = v1 >>> 28 & 0xFL;
            output[outputOffset + 24] = v1 >>> 32 & 0xFL;
            output[outputOffset + 25] = v1 >>> 36 & 0xFL;
            output[outputOffset + 26] = v1 >>> 40 & 0xFL;
            output[outputOffset + 27] = v1 >>> 44 & 0xFL;
            output[outputOffset + 28] = v1 >>> 48 & 0xFL;
            output[outputOffset + 29] = v1 >>> 52 & 0xFL;
            output[outputOffset + 30] = v1 >>> 56 & 0xFL;
            output[outputOffset + 31] = v1 >>> 60 & 0xFL;
        }
    }

    private static final class Unpacker5
    implements LongBitUnpacker {
        private Unpacker5() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker5.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            int v2 = input.readInt();
            output[outputOffset] = v0 & 0x1FL;
            output[outputOffset + 1] = v0 >>> 5 & 0x1FL;
            output[outputOffset + 2] = v0 >>> 10 & 0x1FL;
            output[outputOffset + 3] = v0 >>> 15 & 0x1FL;
            output[outputOffset + 4] = v0 >>> 20 & 0x1FL;
            output[outputOffset + 5] = v0 >>> 25 & 0x1FL;
            output[outputOffset + 6] = v0 >>> 30 & 0x1FL;
            output[outputOffset + 7] = v0 >>> 35 & 0x1FL;
            output[outputOffset + 8] = v0 >>> 40 & 0x1FL;
            output[outputOffset + 9] = v0 >>> 45 & 0x1FL;
            output[outputOffset + 10] = v0 >>> 50 & 0x1FL;
            output[outputOffset + 11] = v0 >>> 55 & 0x1FL;
            output[outputOffset + 12] = v0 >>> 60 & 0xFL | (v1 & 1L) << 4;
            output[outputOffset + 13] = v1 >>> 1 & 0x1FL;
            output[outputOffset + 14] = v1 >>> 6 & 0x1FL;
            output[outputOffset + 15] = v1 >>> 11 & 0x1FL;
            output[outputOffset + 16] = v1 >>> 16 & 0x1FL;
            output[outputOffset + 17] = v1 >>> 21 & 0x1FL;
            output[outputOffset + 18] = v1 >>> 26 & 0x1FL;
            output[outputOffset + 19] = v1 >>> 31 & 0x1FL;
            output[outputOffset + 20] = v1 >>> 36 & 0x1FL;
            output[outputOffset + 21] = v1 >>> 41 & 0x1FL;
            output[outputOffset + 22] = v1 >>> 46 & 0x1FL;
            output[outputOffset + 23] = v1 >>> 51 & 0x1FL;
            output[outputOffset + 24] = v1 >>> 56 & 0x1FL;
            output[outputOffset + 25] = v1 >>> 61 & 7L | ((long)v2 & 3L) << 3;
            output[outputOffset + 26] = (long)(v2 >>> 2) & 0x1FL;
            output[outputOffset + 27] = (long)(v2 >>> 7) & 0x1FL;
            output[outputOffset + 28] = (long)(v2 >>> 12) & 0x1FL;
            output[outputOffset + 29] = (long)(v2 >>> 17) & 0x1FL;
            output[outputOffset + 30] = (long)(v2 >>> 22) & 0x1FL;
            output[outputOffset + 31] = (long)(v2 >>> 27) & 0x1FL;
        }
    }

    private static final class Unpacker6
    implements LongBitUnpacker {
        private Unpacker6() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker6.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            output[outputOffset] = v0 & 0x3FL;
            output[outputOffset + 1] = v0 >>> 6 & 0x3FL;
            output[outputOffset + 2] = v0 >>> 12 & 0x3FL;
            output[outputOffset + 3] = v0 >>> 18 & 0x3FL;
            output[outputOffset + 4] = v0 >>> 24 & 0x3FL;
            output[outputOffset + 5] = v0 >>> 30 & 0x3FL;
            output[outputOffset + 6] = v0 >>> 36 & 0x3FL;
            output[outputOffset + 7] = v0 >>> 42 & 0x3FL;
            output[outputOffset + 8] = v0 >>> 48 & 0x3FL;
            output[outputOffset + 9] = v0 >>> 54 & 0x3FL;
            output[outputOffset + 10] = v0 >>> 60 & 0xFL | (v1 & 3L) << 4;
            output[outputOffset + 11] = v1 >>> 2 & 0x3FL;
            output[outputOffset + 12] = v1 >>> 8 & 0x3FL;
            output[outputOffset + 13] = v1 >>> 14 & 0x3FL;
            output[outputOffset + 14] = v1 >>> 20 & 0x3FL;
            output[outputOffset + 15] = v1 >>> 26 & 0x3FL;
            output[outputOffset + 16] = v1 >>> 32 & 0x3FL;
            output[outputOffset + 17] = v1 >>> 38 & 0x3FL;
            output[outputOffset + 18] = v1 >>> 44 & 0x3FL;
            output[outputOffset + 19] = v1 >>> 50 & 0x3FL;
            output[outputOffset + 20] = v1 >>> 56 & 0x3FL;
            output[outputOffset + 21] = v1 >>> 62 & 3L | (v2 & 0xFL) << 2;
            output[outputOffset + 22] = v2 >>> 4 & 0x3FL;
            output[outputOffset + 23] = v2 >>> 10 & 0x3FL;
            output[outputOffset + 24] = v2 >>> 16 & 0x3FL;
            output[outputOffset + 25] = v2 >>> 22 & 0x3FL;
            output[outputOffset + 26] = v2 >>> 28 & 0x3FL;
            output[outputOffset + 27] = v2 >>> 34 & 0x3FL;
            output[outputOffset + 28] = v2 >>> 40 & 0x3FL;
            output[outputOffset + 29] = v2 >>> 46 & 0x3FL;
            output[outputOffset + 30] = v2 >>> 52 & 0x3FL;
            output[outputOffset + 31] = v2 >>> 58 & 0x3FL;
        }
    }

    private static final class Unpacker7
    implements LongBitUnpacker {
        private Unpacker7() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker7.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            int v3 = input.readInt();
            output[outputOffset] = v0 & 0x7FL;
            output[outputOffset + 1] = v0 >>> 7 & 0x7FL;
            output[outputOffset + 2] = v0 >>> 14 & 0x7FL;
            output[outputOffset + 3] = v0 >>> 21 & 0x7FL;
            output[outputOffset + 4] = v0 >>> 28 & 0x7FL;
            output[outputOffset + 5] = v0 >>> 35 & 0x7FL;
            output[outputOffset + 6] = v0 >>> 42 & 0x7FL;
            output[outputOffset + 7] = v0 >>> 49 & 0x7FL;
            output[outputOffset + 8] = v0 >>> 56 & 0x7FL;
            output[outputOffset + 9] = v0 >>> 63 & 1L | (v1 & 0x3FL) << 1;
            output[outputOffset + 10] = v1 >>> 6 & 0x7FL;
            output[outputOffset + 11] = v1 >>> 13 & 0x7FL;
            output[outputOffset + 12] = v1 >>> 20 & 0x7FL;
            output[outputOffset + 13] = v1 >>> 27 & 0x7FL;
            output[outputOffset + 14] = v1 >>> 34 & 0x7FL;
            output[outputOffset + 15] = v1 >>> 41 & 0x7FL;
            output[outputOffset + 16] = v1 >>> 48 & 0x7FL;
            output[outputOffset + 17] = v1 >>> 55 & 0x7FL;
            output[outputOffset + 18] = v1 >>> 62 & 3L | (v2 & 0x1FL) << 2;
            output[outputOffset + 19] = v2 >>> 5 & 0x7FL;
            output[outputOffset + 20] = v2 >>> 12 & 0x7FL;
            output[outputOffset + 21] = v2 >>> 19 & 0x7FL;
            output[outputOffset + 22] = v2 >>> 26 & 0x7FL;
            output[outputOffset + 23] = v2 >>> 33 & 0x7FL;
            output[outputOffset + 24] = v2 >>> 40 & 0x7FL;
            output[outputOffset + 25] = v2 >>> 47 & 0x7FL;
            output[outputOffset + 26] = v2 >>> 54 & 0x7FL;
            output[outputOffset + 27] = v2 >>> 61 & 7L | ((long)v3 & 0xFL) << 3;
            output[outputOffset + 28] = (long)(v3 >>> 4) & 0x7FL;
            output[outputOffset + 29] = (long)(v3 >>> 11) & 0x7FL;
            output[outputOffset + 30] = (long)(v3 >>> 18) & 0x7FL;
            output[outputOffset + 31] = (long)(v3 >>> 25) & 0x7FL;
        }
    }

    private static final class Unpacker8
    implements LongBitUnpacker {
        private Unpacker8() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker8.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            output[outputOffset] = v0 & 0xFFL;
            output[outputOffset + 1] = v0 >>> 8 & 0xFFL;
            output[outputOffset + 2] = v0 >>> 16 & 0xFFL;
            output[outputOffset + 3] = v0 >>> 24 & 0xFFL;
            output[outputOffset + 4] = v0 >>> 32 & 0xFFL;
            output[outputOffset + 5] = v0 >>> 40 & 0xFFL;
            output[outputOffset + 6] = v0 >>> 48 & 0xFFL;
            output[outputOffset + 7] = v0 >>> 56 & 0xFFL;
            output[outputOffset + 8] = v1 & 0xFFL;
            output[outputOffset + 9] = v1 >>> 8 & 0xFFL;
            output[outputOffset + 10] = v1 >>> 16 & 0xFFL;
            output[outputOffset + 11] = v1 >>> 24 & 0xFFL;
            output[outputOffset + 12] = v1 >>> 32 & 0xFFL;
            output[outputOffset + 13] = v1 >>> 40 & 0xFFL;
            output[outputOffset + 14] = v1 >>> 48 & 0xFFL;
            output[outputOffset + 15] = v1 >>> 56 & 0xFFL;
            output[outputOffset + 16] = v2 & 0xFFL;
            output[outputOffset + 17] = v2 >>> 8 & 0xFFL;
            output[outputOffset + 18] = v2 >>> 16 & 0xFFL;
            output[outputOffset + 19] = v2 >>> 24 & 0xFFL;
            output[outputOffset + 20] = v2 >>> 32 & 0xFFL;
            output[outputOffset + 21] = v2 >>> 40 & 0xFFL;
            output[outputOffset + 22] = v2 >>> 48 & 0xFFL;
            output[outputOffset + 23] = v2 >>> 56 & 0xFFL;
            output[outputOffset + 24] = v3 & 0xFFL;
            output[outputOffset + 25] = v3 >>> 8 & 0xFFL;
            output[outputOffset + 26] = v3 >>> 16 & 0xFFL;
            output[outputOffset + 27] = v3 >>> 24 & 0xFFL;
            output[outputOffset + 28] = v3 >>> 32 & 0xFFL;
            output[outputOffset + 29] = v3 >>> 40 & 0xFFL;
            output[outputOffset + 30] = v3 >>> 48 & 0xFFL;
            output[outputOffset + 31] = v3 >>> 56 & 0xFFL;
        }
    }

    private static final class Unpacker9
    implements LongBitUnpacker {
        private Unpacker9() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker9.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            int v4 = input.readInt();
            output[outputOffset] = v0 & 0x1FFL;
            output[outputOffset + 1] = v0 >>> 9 & 0x1FFL;
            output[outputOffset + 2] = v0 >>> 18 & 0x1FFL;
            output[outputOffset + 3] = v0 >>> 27 & 0x1FFL;
            output[outputOffset + 4] = v0 >>> 36 & 0x1FFL;
            output[outputOffset + 5] = v0 >>> 45 & 0x1FFL;
            output[outputOffset + 6] = v0 >>> 54 & 0x1FFL;
            output[outputOffset + 7] = v0 >>> 63 & 1L | (v1 & 0xFFL) << 1;
            output[outputOffset + 8] = v1 >>> 8 & 0x1FFL;
            output[outputOffset + 9] = v1 >>> 17 & 0x1FFL;
            output[outputOffset + 10] = v1 >>> 26 & 0x1FFL;
            output[outputOffset + 11] = v1 >>> 35 & 0x1FFL;
            output[outputOffset + 12] = v1 >>> 44 & 0x1FFL;
            output[outputOffset + 13] = v1 >>> 53 & 0x1FFL;
            output[outputOffset + 14] = v1 >>> 62 & 3L | (v2 & 0x7FL) << 2;
            output[outputOffset + 15] = v2 >>> 7 & 0x1FFL;
            output[outputOffset + 16] = v2 >>> 16 & 0x1FFL;
            output[outputOffset + 17] = v2 >>> 25 & 0x1FFL;
            output[outputOffset + 18] = v2 >>> 34 & 0x1FFL;
            output[outputOffset + 19] = v2 >>> 43 & 0x1FFL;
            output[outputOffset + 20] = v2 >>> 52 & 0x1FFL;
            output[outputOffset + 21] = v2 >>> 61 & 7L | (v3 & 0x3FL) << 3;
            output[outputOffset + 22] = v3 >>> 6 & 0x1FFL;
            output[outputOffset + 23] = v3 >>> 15 & 0x1FFL;
            output[outputOffset + 24] = v3 >>> 24 & 0x1FFL;
            output[outputOffset + 25] = v3 >>> 33 & 0x1FFL;
            output[outputOffset + 26] = v3 >>> 42 & 0x1FFL;
            output[outputOffset + 27] = v3 >>> 51 & 0x1FFL;
            output[outputOffset + 28] = v3 >>> 60 & 0xFL | ((long)v4 & 0x1FL) << 4;
            output[outputOffset + 29] = (long)(v4 >>> 5) & 0x1FFL;
            output[outputOffset + 30] = (long)(v4 >>> 14) & 0x1FFL;
            output[outputOffset + 31] = (long)(v4 >>> 23) & 0x1FFL;
        }
    }

    private static final class Unpacker10
    implements LongBitUnpacker {
        private Unpacker10() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker10.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            output[outputOffset] = v0 & 0x3FFL;
            output[outputOffset + 1] = v0 >>> 10 & 0x3FFL;
            output[outputOffset + 2] = v0 >>> 20 & 0x3FFL;
            output[outputOffset + 3] = v0 >>> 30 & 0x3FFL;
            output[outputOffset + 4] = v0 >>> 40 & 0x3FFL;
            output[outputOffset + 5] = v0 >>> 50 & 0x3FFL;
            output[outputOffset + 6] = v0 >>> 60 & 0xFL | (v1 & 0x3FL) << 4;
            output[outputOffset + 7] = v1 >>> 6 & 0x3FFL;
            output[outputOffset + 8] = v1 >>> 16 & 0x3FFL;
            output[outputOffset + 9] = v1 >>> 26 & 0x3FFL;
            output[outputOffset + 10] = v1 >>> 36 & 0x3FFL;
            output[outputOffset + 11] = v1 >>> 46 & 0x3FFL;
            output[outputOffset + 12] = v1 >>> 56 & 0xFFL | (v2 & 3L) << 8;
            output[outputOffset + 13] = v2 >>> 2 & 0x3FFL;
            output[outputOffset + 14] = v2 >>> 12 & 0x3FFL;
            output[outputOffset + 15] = v2 >>> 22 & 0x3FFL;
            output[outputOffset + 16] = v2 >>> 32 & 0x3FFL;
            output[outputOffset + 17] = v2 >>> 42 & 0x3FFL;
            output[outputOffset + 18] = v2 >>> 52 & 0x3FFL;
            output[outputOffset + 19] = v2 >>> 62 & 3L | (v3 & 0xFFL) << 2;
            output[outputOffset + 20] = v3 >>> 8 & 0x3FFL;
            output[outputOffset + 21] = v3 >>> 18 & 0x3FFL;
            output[outputOffset + 22] = v3 >>> 28 & 0x3FFL;
            output[outputOffset + 23] = v3 >>> 38 & 0x3FFL;
            output[outputOffset + 24] = v3 >>> 48 & 0x3FFL;
            output[outputOffset + 25] = v3 >>> 58 & 0x3FL | (v4 & 0xFL) << 6;
            output[outputOffset + 26] = v4 >>> 4 & 0x3FFL;
            output[outputOffset + 27] = v4 >>> 14 & 0x3FFL;
            output[outputOffset + 28] = v4 >>> 24 & 0x3FFL;
            output[outputOffset + 29] = v4 >>> 34 & 0x3FFL;
            output[outputOffset + 30] = v4 >>> 44 & 0x3FFL;
            output[outputOffset + 31] = v4 >>> 54 & 0x3FFL;
        }
    }

    private static final class Unpacker11
    implements LongBitUnpacker {
        private Unpacker11() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker11.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            int v5 = input.readInt();
            output[outputOffset] = v0 & 0x7FFL;
            output[outputOffset + 1] = v0 >>> 11 & 0x7FFL;
            output[outputOffset + 2] = v0 >>> 22 & 0x7FFL;
            output[outputOffset + 3] = v0 >>> 33 & 0x7FFL;
            output[outputOffset + 4] = v0 >>> 44 & 0x7FFL;
            output[outputOffset + 5] = v0 >>> 55 & 0x1FFL | (v1 & 3L) << 9;
            output[outputOffset + 6] = v1 >>> 2 & 0x7FFL;
            output[outputOffset + 7] = v1 >>> 13 & 0x7FFL;
            output[outputOffset + 8] = v1 >>> 24 & 0x7FFL;
            output[outputOffset + 9] = v1 >>> 35 & 0x7FFL;
            output[outputOffset + 10] = v1 >>> 46 & 0x7FFL;
            output[outputOffset + 11] = v1 >>> 57 & 0x7FL | (v2 & 0xFL) << 7;
            output[outputOffset + 12] = v2 >>> 4 & 0x7FFL;
            output[outputOffset + 13] = v2 >>> 15 & 0x7FFL;
            output[outputOffset + 14] = v2 >>> 26 & 0x7FFL;
            output[outputOffset + 15] = v2 >>> 37 & 0x7FFL;
            output[outputOffset + 16] = v2 >>> 48 & 0x7FFL;
            output[outputOffset + 17] = v2 >>> 59 & 0x1FL | (v3 & 0x3FL) << 5;
            output[outputOffset + 18] = v3 >>> 6 & 0x7FFL;
            output[outputOffset + 19] = v3 >>> 17 & 0x7FFL;
            output[outputOffset + 20] = v3 >>> 28 & 0x7FFL;
            output[outputOffset + 21] = v3 >>> 39 & 0x7FFL;
            output[outputOffset + 22] = v3 >>> 50 & 0x7FFL;
            output[outputOffset + 23] = v3 >>> 61 & 7L | (v4 & 0xFFL) << 3;
            output[outputOffset + 24] = v4 >>> 8 & 0x7FFL;
            output[outputOffset + 25] = v4 >>> 19 & 0x7FFL;
            output[outputOffset + 26] = v4 >>> 30 & 0x7FFL;
            output[outputOffset + 27] = v4 >>> 41 & 0x7FFL;
            output[outputOffset + 28] = v4 >>> 52 & 0x7FFL;
            output[outputOffset + 29] = v4 >>> 63 & 1L | ((long)v5 & 0x3FFL) << 1;
            output[outputOffset + 30] = (long)(v5 >>> 10) & 0x7FFL;
            output[outputOffset + 31] = (long)(v5 >>> 21) & 0x7FFL;
        }
    }

    private static final class Unpacker12
    implements LongBitUnpacker {
        private Unpacker12() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker12.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            output[outputOffset] = v0 & 0xFFFL;
            output[outputOffset + 1] = v0 >>> 12 & 0xFFFL;
            output[outputOffset + 2] = v0 >>> 24 & 0xFFFL;
            output[outputOffset + 3] = v0 >>> 36 & 0xFFFL;
            output[outputOffset + 4] = v0 >>> 48 & 0xFFFL;
            output[outputOffset + 5] = v0 >>> 60 & 0xFL | (v1 & 0xFFL) << 4;
            output[outputOffset + 6] = v1 >>> 8 & 0xFFFL;
            output[outputOffset + 7] = v1 >>> 20 & 0xFFFL;
            output[outputOffset + 8] = v1 >>> 32 & 0xFFFL;
            output[outputOffset + 9] = v1 >>> 44 & 0xFFFL;
            output[outputOffset + 10] = v1 >>> 56 & 0xFFL | (v2 & 0xFL) << 8;
            output[outputOffset + 11] = v2 >>> 4 & 0xFFFL;
            output[outputOffset + 12] = v2 >>> 16 & 0xFFFL;
            output[outputOffset + 13] = v2 >>> 28 & 0xFFFL;
            output[outputOffset + 14] = v2 >>> 40 & 0xFFFL;
            output[outputOffset + 15] = v2 >>> 52 & 0xFFFL;
            output[outputOffset + 16] = v3 & 0xFFFL;
            output[outputOffset + 17] = v3 >>> 12 & 0xFFFL;
            output[outputOffset + 18] = v3 >>> 24 & 0xFFFL;
            output[outputOffset + 19] = v3 >>> 36 & 0xFFFL;
            output[outputOffset + 20] = v3 >>> 48 & 0xFFFL;
            output[outputOffset + 21] = v3 >>> 60 & 0xFL | (v4 & 0xFFL) << 4;
            output[outputOffset + 22] = v4 >>> 8 & 0xFFFL;
            output[outputOffset + 23] = v4 >>> 20 & 0xFFFL;
            output[outputOffset + 24] = v4 >>> 32 & 0xFFFL;
            output[outputOffset + 25] = v4 >>> 44 & 0xFFFL;
            output[outputOffset + 26] = v4 >>> 56 & 0xFFL | (v5 & 0xFL) << 8;
            output[outputOffset + 27] = v5 >>> 4 & 0xFFFL;
            output[outputOffset + 28] = v5 >>> 16 & 0xFFFL;
            output[outputOffset + 29] = v5 >>> 28 & 0xFFFL;
            output[outputOffset + 30] = v5 >>> 40 & 0xFFFL;
            output[outputOffset + 31] = v5 >>> 52 & 0xFFFL;
        }
    }

    private static final class Unpacker13
    implements LongBitUnpacker {
        private Unpacker13() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker13.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            int v6 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFL;
            output[outputOffset + 1] = v0 >>> 13 & 0x1FFFL;
            output[outputOffset + 2] = v0 >>> 26 & 0x1FFFL;
            output[outputOffset + 3] = v0 >>> 39 & 0x1FFFL;
            output[outputOffset + 4] = v0 >>> 52 & 0xFFFL | (v1 & 1L) << 12;
            output[outputOffset + 5] = v1 >>> 1 & 0x1FFFL;
            output[outputOffset + 6] = v1 >>> 14 & 0x1FFFL;
            output[outputOffset + 7] = v1 >>> 27 & 0x1FFFL;
            output[outputOffset + 8] = v1 >>> 40 & 0x1FFFL;
            output[outputOffset + 9] = v1 >>> 53 & 0x7FFL | (v2 & 3L) << 11;
            output[outputOffset + 10] = v2 >>> 2 & 0x1FFFL;
            output[outputOffset + 11] = v2 >>> 15 & 0x1FFFL;
            output[outputOffset + 12] = v2 >>> 28 & 0x1FFFL;
            output[outputOffset + 13] = v2 >>> 41 & 0x1FFFL;
            output[outputOffset + 14] = v2 >>> 54 & 0x3FFL | (v3 & 7L) << 10;
            output[outputOffset + 15] = v3 >>> 3 & 0x1FFFL;
            output[outputOffset + 16] = v3 >>> 16 & 0x1FFFL;
            output[outputOffset + 17] = v3 >>> 29 & 0x1FFFL;
            output[outputOffset + 18] = v3 >>> 42 & 0x1FFFL;
            output[outputOffset + 19] = v3 >>> 55 & 0x1FFL | (v4 & 0xFL) << 9;
            output[outputOffset + 20] = v4 >>> 4 & 0x1FFFL;
            output[outputOffset + 21] = v4 >>> 17 & 0x1FFFL;
            output[outputOffset + 22] = v4 >>> 30 & 0x1FFFL;
            output[outputOffset + 23] = v4 >>> 43 & 0x1FFFL;
            output[outputOffset + 24] = v4 >>> 56 & 0xFFL | (v5 & 0x1FL) << 8;
            output[outputOffset + 25] = v5 >>> 5 & 0x1FFFL;
            output[outputOffset + 26] = v5 >>> 18 & 0x1FFFL;
            output[outputOffset + 27] = v5 >>> 31 & 0x1FFFL;
            output[outputOffset + 28] = v5 >>> 44 & 0x1FFFL;
            output[outputOffset + 29] = v5 >>> 57 & 0x7FL | ((long)v6 & 0x3FL) << 7;
            output[outputOffset + 30] = (long)(v6 >>> 6) & 0x1FFFL;
            output[outputOffset + 31] = (long)(v6 >>> 19) & 0x1FFFL;
        }
    }

    private static final class Unpacker14
    implements LongBitUnpacker {
        private Unpacker14() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker14.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFL;
            output[outputOffset + 1] = v0 >>> 14 & 0x3FFFL;
            output[outputOffset + 2] = v0 >>> 28 & 0x3FFFL;
            output[outputOffset + 3] = v0 >>> 42 & 0x3FFFL;
            output[outputOffset + 4] = v0 >>> 56 & 0xFFL | (v1 & 0x3FL) << 8;
            output[outputOffset + 5] = v1 >>> 6 & 0x3FFFL;
            output[outputOffset + 6] = v1 >>> 20 & 0x3FFFL;
            output[outputOffset + 7] = v1 >>> 34 & 0x3FFFL;
            output[outputOffset + 8] = v1 >>> 48 & 0x3FFFL;
            output[outputOffset + 9] = v1 >>> 62 & 3L | (v2 & 0xFFFL) << 2;
            output[outputOffset + 10] = v2 >>> 12 & 0x3FFFL;
            output[outputOffset + 11] = v2 >>> 26 & 0x3FFFL;
            output[outputOffset + 12] = v2 >>> 40 & 0x3FFFL;
            output[outputOffset + 13] = v2 >>> 54 & 0x3FFL | (v3 & 0xFL) << 10;
            output[outputOffset + 14] = v3 >>> 4 & 0x3FFFL;
            output[outputOffset + 15] = v3 >>> 18 & 0x3FFFL;
            output[outputOffset + 16] = v3 >>> 32 & 0x3FFFL;
            output[outputOffset + 17] = v3 >>> 46 & 0x3FFFL;
            output[outputOffset + 18] = v3 >>> 60 & 0xFL | (v4 & 0x3FFL) << 4;
            output[outputOffset + 19] = v4 >>> 10 & 0x3FFFL;
            output[outputOffset + 20] = v4 >>> 24 & 0x3FFFL;
            output[outputOffset + 21] = v4 >>> 38 & 0x3FFFL;
            output[outputOffset + 22] = v4 >>> 52 & 0xFFFL | (v5 & 3L) << 12;
            output[outputOffset + 23] = v5 >>> 2 & 0x3FFFL;
            output[outputOffset + 24] = v5 >>> 16 & 0x3FFFL;
            output[outputOffset + 25] = v5 >>> 30 & 0x3FFFL;
            output[outputOffset + 26] = v5 >>> 44 & 0x3FFFL;
            output[outputOffset + 27] = v5 >>> 58 & 0x3FL | (v6 & 0xFFL) << 6;
            output[outputOffset + 28] = v6 >>> 8 & 0x3FFFL;
            output[outputOffset + 29] = v6 >>> 22 & 0x3FFFL;
            output[outputOffset + 30] = v6 >>> 36 & 0x3FFFL;
            output[outputOffset + 31] = v6 >>> 50 & 0x3FFFL;
        }
    }

    private static final class Unpacker15
    implements LongBitUnpacker {
        private Unpacker15() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker15.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            int v7 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFL;
            output[outputOffset + 1] = v0 >>> 15 & 0x7FFFL;
            output[outputOffset + 2] = v0 >>> 30 & 0x7FFFL;
            output[outputOffset + 3] = v0 >>> 45 & 0x7FFFL;
            output[outputOffset + 4] = v0 >>> 60 & 0xFL | (v1 & 0x7FFL) << 4;
            output[outputOffset + 5] = v1 >>> 11 & 0x7FFFL;
            output[outputOffset + 6] = v1 >>> 26 & 0x7FFFL;
            output[outputOffset + 7] = v1 >>> 41 & 0x7FFFL;
            output[outputOffset + 8] = v1 >>> 56 & 0xFFL | (v2 & 0x7FL) << 8;
            output[outputOffset + 9] = v2 >>> 7 & 0x7FFFL;
            output[outputOffset + 10] = v2 >>> 22 & 0x7FFFL;
            output[outputOffset + 11] = v2 >>> 37 & 0x7FFFL;
            output[outputOffset + 12] = v2 >>> 52 & 0xFFFL | (v3 & 7L) << 12;
            output[outputOffset + 13] = v3 >>> 3 & 0x7FFFL;
            output[outputOffset + 14] = v3 >>> 18 & 0x7FFFL;
            output[outputOffset + 15] = v3 >>> 33 & 0x7FFFL;
            output[outputOffset + 16] = v3 >>> 48 & 0x7FFFL;
            output[outputOffset + 17] = v3 >>> 63 & 1L | (v4 & 0x3FFFL) << 1;
            output[outputOffset + 18] = v4 >>> 14 & 0x7FFFL;
            output[outputOffset + 19] = v4 >>> 29 & 0x7FFFL;
            output[outputOffset + 20] = v4 >>> 44 & 0x7FFFL;
            output[outputOffset + 21] = v4 >>> 59 & 0x1FL | (v5 & 0x3FFL) << 5;
            output[outputOffset + 22] = v5 >>> 10 & 0x7FFFL;
            output[outputOffset + 23] = v5 >>> 25 & 0x7FFFL;
            output[outputOffset + 24] = v5 >>> 40 & 0x7FFFL;
            output[outputOffset + 25] = v5 >>> 55 & 0x1FFL | (v6 & 0x3FL) << 9;
            output[outputOffset + 26] = v6 >>> 6 & 0x7FFFL;
            output[outputOffset + 27] = v6 >>> 21 & 0x7FFFL;
            output[outputOffset + 28] = v6 >>> 36 & 0x7FFFL;
            output[outputOffset + 29] = v6 >>> 51 & 0x1FFFL | ((long)v7 & 3L) << 13;
            output[outputOffset + 30] = (long)(v7 >>> 2) & 0x7FFFL;
            output[outputOffset + 31] = (long)(v7 >>> 17) & 0x7FFFL;
        }
    }

    private static final class Unpacker16
    implements LongBitUnpacker {
        private Unpacker16() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker16.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFL;
            output[outputOffset + 1] = v0 >>> 16 & 0xFFFFL;
            output[outputOffset + 2] = v0 >>> 32 & 0xFFFFL;
            output[outputOffset + 3] = v0 >>> 48 & 0xFFFFL;
            output[outputOffset + 4] = v1 & 0xFFFFL;
            output[outputOffset + 5] = v1 >>> 16 & 0xFFFFL;
            output[outputOffset + 6] = v1 >>> 32 & 0xFFFFL;
            output[outputOffset + 7] = v1 >>> 48 & 0xFFFFL;
            output[outputOffset + 8] = v2 & 0xFFFFL;
            output[outputOffset + 9] = v2 >>> 16 & 0xFFFFL;
            output[outputOffset + 10] = v2 >>> 32 & 0xFFFFL;
            output[outputOffset + 11] = v2 >>> 48 & 0xFFFFL;
            output[outputOffset + 12] = v3 & 0xFFFFL;
            output[outputOffset + 13] = v3 >>> 16 & 0xFFFFL;
            output[outputOffset + 14] = v3 >>> 32 & 0xFFFFL;
            output[outputOffset + 15] = v3 >>> 48 & 0xFFFFL;
            output[outputOffset + 16] = v4 & 0xFFFFL;
            output[outputOffset + 17] = v4 >>> 16 & 0xFFFFL;
            output[outputOffset + 18] = v4 >>> 32 & 0xFFFFL;
            output[outputOffset + 19] = v4 >>> 48 & 0xFFFFL;
            output[outputOffset + 20] = v5 & 0xFFFFL;
            output[outputOffset + 21] = v5 >>> 16 & 0xFFFFL;
            output[outputOffset + 22] = v5 >>> 32 & 0xFFFFL;
            output[outputOffset + 23] = v5 >>> 48 & 0xFFFFL;
            output[outputOffset + 24] = v6 & 0xFFFFL;
            output[outputOffset + 25] = v6 >>> 16 & 0xFFFFL;
            output[outputOffset + 26] = v6 >>> 32 & 0xFFFFL;
            output[outputOffset + 27] = v6 >>> 48 & 0xFFFFL;
            output[outputOffset + 28] = v7 & 0xFFFFL;
            output[outputOffset + 29] = v7 >>> 16 & 0xFFFFL;
            output[outputOffset + 30] = v7 >>> 32 & 0xFFFFL;
            output[outputOffset + 31] = v7 >>> 48 & 0xFFFFL;
        }
    }

    private static final class Unpacker17
    implements LongBitUnpacker {
        private Unpacker17() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker17.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            int v8 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFL;
            output[outputOffset + 1] = v0 >>> 17 & 0x1FFFFL;
            output[outputOffset + 2] = v0 >>> 34 & 0x1FFFFL;
            output[outputOffset + 3] = v0 >>> 51 & 0x1FFFL | (v1 & 0xFL) << 13;
            output[outputOffset + 4] = v1 >>> 4 & 0x1FFFFL;
            output[outputOffset + 5] = v1 >>> 21 & 0x1FFFFL;
            output[outputOffset + 6] = v1 >>> 38 & 0x1FFFFL;
            output[outputOffset + 7] = v1 >>> 55 & 0x1FFL | (v2 & 0xFFL) << 9;
            output[outputOffset + 8] = v2 >>> 8 & 0x1FFFFL;
            output[outputOffset + 9] = v2 >>> 25 & 0x1FFFFL;
            output[outputOffset + 10] = v2 >>> 42 & 0x1FFFFL;
            output[outputOffset + 11] = v2 >>> 59 & 0x1FL | (v3 & 0xFFFL) << 5;
            output[outputOffset + 12] = v3 >>> 12 & 0x1FFFFL;
            output[outputOffset + 13] = v3 >>> 29 & 0x1FFFFL;
            output[outputOffset + 14] = v3 >>> 46 & 0x1FFFFL;
            output[outputOffset + 15] = v3 >>> 63 & 1L | (v4 & 0xFFFFL) << 1;
            output[outputOffset + 16] = v4 >>> 16 & 0x1FFFFL;
            output[outputOffset + 17] = v4 >>> 33 & 0x1FFFFL;
            output[outputOffset + 18] = v4 >>> 50 & 0x3FFFL | (v5 & 7L) << 14;
            output[outputOffset + 19] = v5 >>> 3 & 0x1FFFFL;
            output[outputOffset + 20] = v5 >>> 20 & 0x1FFFFL;
            output[outputOffset + 21] = v5 >>> 37 & 0x1FFFFL;
            output[outputOffset + 22] = v5 >>> 54 & 0x3FFL | (v6 & 0x7FL) << 10;
            output[outputOffset + 23] = v6 >>> 7 & 0x1FFFFL;
            output[outputOffset + 24] = v6 >>> 24 & 0x1FFFFL;
            output[outputOffset + 25] = v6 >>> 41 & 0x1FFFFL;
            output[outputOffset + 26] = v6 >>> 58 & 0x3FL | (v7 & 0x7FFL) << 6;
            output[outputOffset + 27] = v7 >>> 11 & 0x1FFFFL;
            output[outputOffset + 28] = v7 >>> 28 & 0x1FFFFL;
            output[outputOffset + 29] = v7 >>> 45 & 0x1FFFFL;
            output[outputOffset + 30] = v7 >>> 62 & 3L | ((long)v8 & 0x7FFFL) << 2;
            output[outputOffset + 31] = (long)(v8 >>> 15) & 0x1FFFFL;
        }
    }

    private static final class Unpacker18
    implements LongBitUnpacker {
        private Unpacker18() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker18.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFL;
            output[outputOffset + 1] = v0 >>> 18 & 0x3FFFFL;
            output[outputOffset + 2] = v0 >>> 36 & 0x3FFFFL;
            output[outputOffset + 3] = v0 >>> 54 & 0x3FFL | (v1 & 0xFFL) << 10;
            output[outputOffset + 4] = v1 >>> 8 & 0x3FFFFL;
            output[outputOffset + 5] = v1 >>> 26 & 0x3FFFFL;
            output[outputOffset + 6] = v1 >>> 44 & 0x3FFFFL;
            output[outputOffset + 7] = v1 >>> 62 & 3L | (v2 & 0xFFFFL) << 2;
            output[outputOffset + 8] = v2 >>> 16 & 0x3FFFFL;
            output[outputOffset + 9] = v2 >>> 34 & 0x3FFFFL;
            output[outputOffset + 10] = v2 >>> 52 & 0xFFFL | (v3 & 0x3FL) << 12;
            output[outputOffset + 11] = v3 >>> 6 & 0x3FFFFL;
            output[outputOffset + 12] = v3 >>> 24 & 0x3FFFFL;
            output[outputOffset + 13] = v3 >>> 42 & 0x3FFFFL;
            output[outputOffset + 14] = v3 >>> 60 & 0xFL | (v4 & 0x3FFFL) << 4;
            output[outputOffset + 15] = v4 >>> 14 & 0x3FFFFL;
            output[outputOffset + 16] = v4 >>> 32 & 0x3FFFFL;
            output[outputOffset + 17] = v4 >>> 50 & 0x3FFFL | (v5 & 0xFL) << 14;
            output[outputOffset + 18] = v5 >>> 4 & 0x3FFFFL;
            output[outputOffset + 19] = v5 >>> 22 & 0x3FFFFL;
            output[outputOffset + 20] = v5 >>> 40 & 0x3FFFFL;
            output[outputOffset + 21] = v5 >>> 58 & 0x3FL | (v6 & 0xFFFL) << 6;
            output[outputOffset + 22] = v6 >>> 12 & 0x3FFFFL;
            output[outputOffset + 23] = v6 >>> 30 & 0x3FFFFL;
            output[outputOffset + 24] = v6 >>> 48 & 0xFFFFL | (v7 & 3L) << 16;
            output[outputOffset + 25] = v7 >>> 2 & 0x3FFFFL;
            output[outputOffset + 26] = v7 >>> 20 & 0x3FFFFL;
            output[outputOffset + 27] = v7 >>> 38 & 0x3FFFFL;
            output[outputOffset + 28] = v7 >>> 56 & 0xFFL | (v8 & 0x3FFL) << 8;
            output[outputOffset + 29] = v8 >>> 10 & 0x3FFFFL;
            output[outputOffset + 30] = v8 >>> 28 & 0x3FFFFL;
            output[outputOffset + 31] = v8 >>> 46 & 0x3FFFFL;
        }
    }

    private static final class Unpacker19
    implements LongBitUnpacker {
        private Unpacker19() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker19.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            int v9 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFL;
            output[outputOffset + 1] = v0 >>> 19 & 0x7FFFFL;
            output[outputOffset + 2] = v0 >>> 38 & 0x7FFFFL;
            output[outputOffset + 3] = v0 >>> 57 & 0x7FL | (v1 & 0xFFFL) << 7;
            output[outputOffset + 4] = v1 >>> 12 & 0x7FFFFL;
            output[outputOffset + 5] = v1 >>> 31 & 0x7FFFFL;
            output[outputOffset + 6] = v1 >>> 50 & 0x3FFFL | (v2 & 0x1FL) << 14;
            output[outputOffset + 7] = v2 >>> 5 & 0x7FFFFL;
            output[outputOffset + 8] = v2 >>> 24 & 0x7FFFFL;
            output[outputOffset + 9] = v2 >>> 43 & 0x7FFFFL;
            output[outputOffset + 10] = v2 >>> 62 & 3L | (v3 & 0x1FFFFL) << 2;
            output[outputOffset + 11] = v3 >>> 17 & 0x7FFFFL;
            output[outputOffset + 12] = v3 >>> 36 & 0x7FFFFL;
            output[outputOffset + 13] = v3 >>> 55 & 0x1FFL | (v4 & 0x3FFL) << 9;
            output[outputOffset + 14] = v4 >>> 10 & 0x7FFFFL;
            output[outputOffset + 15] = v4 >>> 29 & 0x7FFFFL;
            output[outputOffset + 16] = v4 >>> 48 & 0xFFFFL | (v5 & 7L) << 16;
            output[outputOffset + 17] = v5 >>> 3 & 0x7FFFFL;
            output[outputOffset + 18] = v5 >>> 22 & 0x7FFFFL;
            output[outputOffset + 19] = v5 >>> 41 & 0x7FFFFL;
            output[outputOffset + 20] = v5 >>> 60 & 0xFL | (v6 & 0x7FFFL) << 4;
            output[outputOffset + 21] = v6 >>> 15 & 0x7FFFFL;
            output[outputOffset + 22] = v6 >>> 34 & 0x7FFFFL;
            output[outputOffset + 23] = v6 >>> 53 & 0x7FFL | (v7 & 0xFFL) << 11;
            output[outputOffset + 24] = v7 >>> 8 & 0x7FFFFL;
            output[outputOffset + 25] = v7 >>> 27 & 0x7FFFFL;
            output[outputOffset + 26] = v7 >>> 46 & 0x3FFFFL | (v8 & 1L) << 18;
            output[outputOffset + 27] = v8 >>> 1 & 0x7FFFFL;
            output[outputOffset + 28] = v8 >>> 20 & 0x7FFFFL;
            output[outputOffset + 29] = v8 >>> 39 & 0x7FFFFL;
            output[outputOffset + 30] = v8 >>> 58 & 0x3FL | ((long)v9 & 0x1FFFL) << 6;
            output[outputOffset + 31] = (long)(v9 >>> 13) & 0x7FFFFL;
        }
    }

    private static final class Unpacker20
    implements LongBitUnpacker {
        private Unpacker20() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker20.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFL;
            output[outputOffset + 1] = v0 >>> 20 & 0xFFFFFL;
            output[outputOffset + 2] = v0 >>> 40 & 0xFFFFFL;
            output[outputOffset + 3] = v0 >>> 60 & 0xFL | (v1 & 0xFFFFL) << 4;
            output[outputOffset + 4] = v1 >>> 16 & 0xFFFFFL;
            output[outputOffset + 5] = v1 >>> 36 & 0xFFFFFL;
            output[outputOffset + 6] = v1 >>> 56 & 0xFFL | (v2 & 0xFFFL) << 8;
            output[outputOffset + 7] = v2 >>> 12 & 0xFFFFFL;
            output[outputOffset + 8] = v2 >>> 32 & 0xFFFFFL;
            output[outputOffset + 9] = v2 >>> 52 & 0xFFFL | (v3 & 0xFFL) << 12;
            output[outputOffset + 10] = v3 >>> 8 & 0xFFFFFL;
            output[outputOffset + 11] = v3 >>> 28 & 0xFFFFFL;
            output[outputOffset + 12] = v3 >>> 48 & 0xFFFFL | (v4 & 0xFL) << 16;
            output[outputOffset + 13] = v4 >>> 4 & 0xFFFFFL;
            output[outputOffset + 14] = v4 >>> 24 & 0xFFFFFL;
            output[outputOffset + 15] = v4 >>> 44 & 0xFFFFFL;
            output[outputOffset + 16] = v5 & 0xFFFFFL;
            output[outputOffset + 17] = v5 >>> 20 & 0xFFFFFL;
            output[outputOffset + 18] = v5 >>> 40 & 0xFFFFFL;
            output[outputOffset + 19] = v5 >>> 60 & 0xFL | (v6 & 0xFFFFL) << 4;
            output[outputOffset + 20] = v6 >>> 16 & 0xFFFFFL;
            output[outputOffset + 21] = v6 >>> 36 & 0xFFFFFL;
            output[outputOffset + 22] = v6 >>> 56 & 0xFFL | (v7 & 0xFFFL) << 8;
            output[outputOffset + 23] = v7 >>> 12 & 0xFFFFFL;
            output[outputOffset + 24] = v7 >>> 32 & 0xFFFFFL;
            output[outputOffset + 25] = v7 >>> 52 & 0xFFFL | (v8 & 0xFFL) << 12;
            output[outputOffset + 26] = v8 >>> 8 & 0xFFFFFL;
            output[outputOffset + 27] = v8 >>> 28 & 0xFFFFFL;
            output[outputOffset + 28] = v8 >>> 48 & 0xFFFFL | (v9 & 0xFL) << 16;
            output[outputOffset + 29] = v9 >>> 4 & 0xFFFFFL;
            output[outputOffset + 30] = v9 >>> 24 & 0xFFFFFL;
            output[outputOffset + 31] = v9 >>> 44 & 0xFFFFFL;
        }
    }

    private static final class Unpacker21
    implements LongBitUnpacker {
        private Unpacker21() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker21.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            int v10 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFL;
            output[outputOffset + 1] = v0 >>> 21 & 0x1FFFFFL;
            output[outputOffset + 2] = v0 >>> 42 & 0x1FFFFFL;
            output[outputOffset + 3] = v0 >>> 63 & 1L | (v1 & 0xFFFFFL) << 1;
            output[outputOffset + 4] = v1 >>> 20 & 0x1FFFFFL;
            output[outputOffset + 5] = v1 >>> 41 & 0x1FFFFFL;
            output[outputOffset + 6] = v1 >>> 62 & 3L | (v2 & 0x7FFFFL) << 2;
            output[outputOffset + 7] = v2 >>> 19 & 0x1FFFFFL;
            output[outputOffset + 8] = v2 >>> 40 & 0x1FFFFFL;
            output[outputOffset + 9] = v2 >>> 61 & 7L | (v3 & 0x3FFFFL) << 3;
            output[outputOffset + 10] = v3 >>> 18 & 0x1FFFFFL;
            output[outputOffset + 11] = v3 >>> 39 & 0x1FFFFFL;
            output[outputOffset + 12] = v3 >>> 60 & 0xFL | (v4 & 0x1FFFFL) << 4;
            output[outputOffset + 13] = v4 >>> 17 & 0x1FFFFFL;
            output[outputOffset + 14] = v4 >>> 38 & 0x1FFFFFL;
            output[outputOffset + 15] = v4 >>> 59 & 0x1FL | (v5 & 0xFFFFL) << 5;
            output[outputOffset + 16] = v5 >>> 16 & 0x1FFFFFL;
            output[outputOffset + 17] = v5 >>> 37 & 0x1FFFFFL;
            output[outputOffset + 18] = v5 >>> 58 & 0x3FL | (v6 & 0x7FFFL) << 6;
            output[outputOffset + 19] = v6 >>> 15 & 0x1FFFFFL;
            output[outputOffset + 20] = v6 >>> 36 & 0x1FFFFFL;
            output[outputOffset + 21] = v6 >>> 57 & 0x7FL | (v7 & 0x3FFFL) << 7;
            output[outputOffset + 22] = v7 >>> 14 & 0x1FFFFFL;
            output[outputOffset + 23] = v7 >>> 35 & 0x1FFFFFL;
            output[outputOffset + 24] = v7 >>> 56 & 0xFFL | (v8 & 0x1FFFL) << 8;
            output[outputOffset + 25] = v8 >>> 13 & 0x1FFFFFL;
            output[outputOffset + 26] = v8 >>> 34 & 0x1FFFFFL;
            output[outputOffset + 27] = v8 >>> 55 & 0x1FFL | (v9 & 0xFFFL) << 9;
            output[outputOffset + 28] = v9 >>> 12 & 0x1FFFFFL;
            output[outputOffset + 29] = v9 >>> 33 & 0x1FFFFFL;
            output[outputOffset + 30] = v9 >>> 54 & 0x3FFL | ((long)v10 & 0x7FFL) << 10;
            output[outputOffset + 31] = (long)(v10 >>> 11) & 0x1FFFFFL;
        }
    }

    private static final class Unpacker22
    implements LongBitUnpacker {
        private Unpacker22() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker22.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFL;
            output[outputOffset + 1] = v0 >>> 22 & 0x3FFFFFL;
            output[outputOffset + 2] = v0 >>> 44 & 0xFFFFFL | (v1 & 3L) << 20;
            output[outputOffset + 3] = v1 >>> 2 & 0x3FFFFFL;
            output[outputOffset + 4] = v1 >>> 24 & 0x3FFFFFL;
            output[outputOffset + 5] = v1 >>> 46 & 0x3FFFFL | (v2 & 0xFL) << 18;
            output[outputOffset + 6] = v2 >>> 4 & 0x3FFFFFL;
            output[outputOffset + 7] = v2 >>> 26 & 0x3FFFFFL;
            output[outputOffset + 8] = v2 >>> 48 & 0xFFFFL | (v3 & 0x3FL) << 16;
            output[outputOffset + 9] = v3 >>> 6 & 0x3FFFFFL;
            output[outputOffset + 10] = v3 >>> 28 & 0x3FFFFFL;
            output[outputOffset + 11] = v3 >>> 50 & 0x3FFFL | (v4 & 0xFFL) << 14;
            output[outputOffset + 12] = v4 >>> 8 & 0x3FFFFFL;
            output[outputOffset + 13] = v4 >>> 30 & 0x3FFFFFL;
            output[outputOffset + 14] = v4 >>> 52 & 0xFFFL | (v5 & 0x3FFL) << 12;
            output[outputOffset + 15] = v5 >>> 10 & 0x3FFFFFL;
            output[outputOffset + 16] = v5 >>> 32 & 0x3FFFFFL;
            output[outputOffset + 17] = v5 >>> 54 & 0x3FFL | (v6 & 0xFFFL) << 10;
            output[outputOffset + 18] = v6 >>> 12 & 0x3FFFFFL;
            output[outputOffset + 19] = v6 >>> 34 & 0x3FFFFFL;
            output[outputOffset + 20] = v6 >>> 56 & 0xFFL | (v7 & 0x3FFFL) << 8;
            output[outputOffset + 21] = v7 >>> 14 & 0x3FFFFFL;
            output[outputOffset + 22] = v7 >>> 36 & 0x3FFFFFL;
            output[outputOffset + 23] = v7 >>> 58 & 0x3FL | (v8 & 0xFFFFL) << 6;
            output[outputOffset + 24] = v8 >>> 16 & 0x3FFFFFL;
            output[outputOffset + 25] = v8 >>> 38 & 0x3FFFFFL;
            output[outputOffset + 26] = v8 >>> 60 & 0xFL | (v9 & 0x3FFFFL) << 4;
            output[outputOffset + 27] = v9 >>> 18 & 0x3FFFFFL;
            output[outputOffset + 28] = v9 >>> 40 & 0x3FFFFFL;
            output[outputOffset + 29] = v9 >>> 62 & 3L | (v10 & 0xFFFFFL) << 2;
            output[outputOffset + 30] = v10 >>> 20 & 0x3FFFFFL;
            output[outputOffset + 31] = v10 >>> 42 & 0x3FFFFFL;
        }
    }

    private static final class Unpacker23
    implements LongBitUnpacker {
        private Unpacker23() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker23.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            int v11 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFL;
            output[outputOffset + 1] = v0 >>> 23 & 0x7FFFFFL;
            output[outputOffset + 2] = v0 >>> 46 & 0x3FFFFL | (v1 & 0x1FL) << 18;
            output[outputOffset + 3] = v1 >>> 5 & 0x7FFFFFL;
            output[outputOffset + 4] = v1 >>> 28 & 0x7FFFFFL;
            output[outputOffset + 5] = v1 >>> 51 & 0x1FFFL | (v2 & 0x3FFL) << 13;
            output[outputOffset + 6] = v2 >>> 10 & 0x7FFFFFL;
            output[outputOffset + 7] = v2 >>> 33 & 0x7FFFFFL;
            output[outputOffset + 8] = v2 >>> 56 & 0xFFL | (v3 & 0x7FFFL) << 8;
            output[outputOffset + 9] = v3 >>> 15 & 0x7FFFFFL;
            output[outputOffset + 10] = v3 >>> 38 & 0x7FFFFFL;
            output[outputOffset + 11] = v3 >>> 61 & 7L | (v4 & 0xFFFFFL) << 3;
            output[outputOffset + 12] = v4 >>> 20 & 0x7FFFFFL;
            output[outputOffset + 13] = v4 >>> 43 & 0x1FFFFFL | (v5 & 3L) << 21;
            output[outputOffset + 14] = v5 >>> 2 & 0x7FFFFFL;
            output[outputOffset + 15] = v5 >>> 25 & 0x7FFFFFL;
            output[outputOffset + 16] = v5 >>> 48 & 0xFFFFL | (v6 & 0x7FL) << 16;
            output[outputOffset + 17] = v6 >>> 7 & 0x7FFFFFL;
            output[outputOffset + 18] = v6 >>> 30 & 0x7FFFFFL;
            output[outputOffset + 19] = v6 >>> 53 & 0x7FFL | (v7 & 0xFFFL) << 11;
            output[outputOffset + 20] = v7 >>> 12 & 0x7FFFFFL;
            output[outputOffset + 21] = v7 >>> 35 & 0x7FFFFFL;
            output[outputOffset + 22] = v7 >>> 58 & 0x3FL | (v8 & 0x1FFFFL) << 6;
            output[outputOffset + 23] = v8 >>> 17 & 0x7FFFFFL;
            output[outputOffset + 24] = v8 >>> 40 & 0x7FFFFFL;
            output[outputOffset + 25] = v8 >>> 63 & 1L | (v9 & 0x3FFFFFL) << 1;
            output[outputOffset + 26] = v9 >>> 22 & 0x7FFFFFL;
            output[outputOffset + 27] = v9 >>> 45 & 0x7FFFFL | (v10 & 0xFL) << 19;
            output[outputOffset + 28] = v10 >>> 4 & 0x7FFFFFL;
            output[outputOffset + 29] = v10 >>> 27 & 0x7FFFFFL;
            output[outputOffset + 30] = v10 >>> 50 & 0x3FFFL | ((long)v11 & 0x1FFL) << 14;
            output[outputOffset + 31] = (long)(v11 >>> 9) & 0x7FFFFFL;
        }
    }

    private static final class Unpacker24
    implements LongBitUnpacker {
        private Unpacker24() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker24.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFL;
            output[outputOffset + 1] = v0 >>> 24 & 0xFFFFFFL;
            output[outputOffset + 2] = v0 >>> 48 & 0xFFFFL | (v1 & 0xFFL) << 16;
            output[outputOffset + 3] = v1 >>> 8 & 0xFFFFFFL;
            output[outputOffset + 4] = v1 >>> 32 & 0xFFFFFFL;
            output[outputOffset + 5] = v1 >>> 56 & 0xFFL | (v2 & 0xFFFFL) << 8;
            output[outputOffset + 6] = v2 >>> 16 & 0xFFFFFFL;
            output[outputOffset + 7] = v2 >>> 40 & 0xFFFFFFL;
            output[outputOffset + 8] = v3 & 0xFFFFFFL;
            output[outputOffset + 9] = v3 >>> 24 & 0xFFFFFFL;
            output[outputOffset + 10] = v3 >>> 48 & 0xFFFFL | (v4 & 0xFFL) << 16;
            output[outputOffset + 11] = v4 >>> 8 & 0xFFFFFFL;
            output[outputOffset + 12] = v4 >>> 32 & 0xFFFFFFL;
            output[outputOffset + 13] = v4 >>> 56 & 0xFFL | (v5 & 0xFFFFL) << 8;
            output[outputOffset + 14] = v5 >>> 16 & 0xFFFFFFL;
            output[outputOffset + 15] = v5 >>> 40 & 0xFFFFFFL;
            output[outputOffset + 16] = v6 & 0xFFFFFFL;
            output[outputOffset + 17] = v6 >>> 24 & 0xFFFFFFL;
            output[outputOffset + 18] = v6 >>> 48 & 0xFFFFL | (v7 & 0xFFL) << 16;
            output[outputOffset + 19] = v7 >>> 8 & 0xFFFFFFL;
            output[outputOffset + 20] = v7 >>> 32 & 0xFFFFFFL;
            output[outputOffset + 21] = v7 >>> 56 & 0xFFL | (v8 & 0xFFFFL) << 8;
            output[outputOffset + 22] = v8 >>> 16 & 0xFFFFFFL;
            output[outputOffset + 23] = v8 >>> 40 & 0xFFFFFFL;
            output[outputOffset + 24] = v9 & 0xFFFFFFL;
            output[outputOffset + 25] = v9 >>> 24 & 0xFFFFFFL;
            output[outputOffset + 26] = v9 >>> 48 & 0xFFFFL | (v10 & 0xFFL) << 16;
            output[outputOffset + 27] = v10 >>> 8 & 0xFFFFFFL;
            output[outputOffset + 28] = v10 >>> 32 & 0xFFFFFFL;
            output[outputOffset + 29] = v10 >>> 56 & 0xFFL | (v11 & 0xFFFFL) << 8;
            output[outputOffset + 30] = v11 >>> 16 & 0xFFFFFFL;
            output[outputOffset + 31] = v11 >>> 40 & 0xFFFFFFL;
        }
    }

    private static final class Unpacker25
    implements LongBitUnpacker {
        private Unpacker25() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker25.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            int v12 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFL;
            output[outputOffset + 1] = v0 >>> 25 & 0x1FFFFFFL;
            output[outputOffset + 2] = v0 >>> 50 & 0x3FFFL | (v1 & 0x7FFL) << 14;
            output[outputOffset + 3] = v1 >>> 11 & 0x1FFFFFFL;
            output[outputOffset + 4] = v1 >>> 36 & 0x1FFFFFFL;
            output[outputOffset + 5] = v1 >>> 61 & 7L | (v2 & 0x3FFFFFL) << 3;
            output[outputOffset + 6] = v2 >>> 22 & 0x1FFFFFFL;
            output[outputOffset + 7] = v2 >>> 47 & 0x1FFFFL | (v3 & 0xFFL) << 17;
            output[outputOffset + 8] = v3 >>> 8 & 0x1FFFFFFL;
            output[outputOffset + 9] = v3 >>> 33 & 0x1FFFFFFL;
            output[outputOffset + 10] = v3 >>> 58 & 0x3FL | (v4 & 0x7FFFFL) << 6;
            output[outputOffset + 11] = v4 >>> 19 & 0x1FFFFFFL;
            output[outputOffset + 12] = v4 >>> 44 & 0xFFFFFL | (v5 & 0x1FL) << 20;
            output[outputOffset + 13] = v5 >>> 5 & 0x1FFFFFFL;
            output[outputOffset + 14] = v5 >>> 30 & 0x1FFFFFFL;
            output[outputOffset + 15] = v5 >>> 55 & 0x1FFL | (v6 & 0xFFFFL) << 9;
            output[outputOffset + 16] = v6 >>> 16 & 0x1FFFFFFL;
            output[outputOffset + 17] = v6 >>> 41 & 0x7FFFFFL | (v7 & 3L) << 23;
            output[outputOffset + 18] = v7 >>> 2 & 0x1FFFFFFL;
            output[outputOffset + 19] = v7 >>> 27 & 0x1FFFFFFL;
            output[outputOffset + 20] = v7 >>> 52 & 0xFFFL | (v8 & 0x1FFFL) << 12;
            output[outputOffset + 21] = v8 >>> 13 & 0x1FFFFFFL;
            output[outputOffset + 22] = v8 >>> 38 & 0x1FFFFFFL;
            output[outputOffset + 23] = v8 >>> 63 & 1L | (v9 & 0xFFFFFFL) << 1;
            output[outputOffset + 24] = v9 >>> 24 & 0x1FFFFFFL;
            output[outputOffset + 25] = v9 >>> 49 & 0x7FFFL | (v10 & 0x3FFL) << 15;
            output[outputOffset + 26] = v10 >>> 10 & 0x1FFFFFFL;
            output[outputOffset + 27] = v10 >>> 35 & 0x1FFFFFFL;
            output[outputOffset + 28] = v10 >>> 60 & 0xFL | (v11 & 0x1FFFFFL) << 4;
            output[outputOffset + 29] = v11 >>> 21 & 0x1FFFFFFL;
            output[outputOffset + 30] = v11 >>> 46 & 0x3FFFFL | ((long)v12 & 0x7FL) << 18;
            output[outputOffset + 31] = (long)(v12 >>> 7) & 0x1FFFFFFL;
        }
    }

    private static final class Unpacker26
    implements LongBitUnpacker {
        private Unpacker26() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker26.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFL;
            output[outputOffset + 1] = v0 >>> 26 & 0x3FFFFFFL;
            output[outputOffset + 2] = v0 >>> 52 & 0xFFFL | (v1 & 0x3FFFL) << 12;
            output[outputOffset + 3] = v1 >>> 14 & 0x3FFFFFFL;
            output[outputOffset + 4] = v1 >>> 40 & 0xFFFFFFL | (v2 & 3L) << 24;
            output[outputOffset + 5] = v2 >>> 2 & 0x3FFFFFFL;
            output[outputOffset + 6] = v2 >>> 28 & 0x3FFFFFFL;
            output[outputOffset + 7] = v2 >>> 54 & 0x3FFL | (v3 & 0xFFFFL) << 10;
            output[outputOffset + 8] = v3 >>> 16 & 0x3FFFFFFL;
            output[outputOffset + 9] = v3 >>> 42 & 0x3FFFFFL | (v4 & 0xFL) << 22;
            output[outputOffset + 10] = v4 >>> 4 & 0x3FFFFFFL;
            output[outputOffset + 11] = v4 >>> 30 & 0x3FFFFFFL;
            output[outputOffset + 12] = v4 >>> 56 & 0xFFL | (v5 & 0x3FFFFL) << 8;
            output[outputOffset + 13] = v5 >>> 18 & 0x3FFFFFFL;
            output[outputOffset + 14] = v5 >>> 44 & 0xFFFFFL | (v6 & 0x3FL) << 20;
            output[outputOffset + 15] = v6 >>> 6 & 0x3FFFFFFL;
            output[outputOffset + 16] = v6 >>> 32 & 0x3FFFFFFL;
            output[outputOffset + 17] = v6 >>> 58 & 0x3FL | (v7 & 0xFFFFFL) << 6;
            output[outputOffset + 18] = v7 >>> 20 & 0x3FFFFFFL;
            output[outputOffset + 19] = v7 >>> 46 & 0x3FFFFL | (v8 & 0xFFL) << 18;
            output[outputOffset + 20] = v8 >>> 8 & 0x3FFFFFFL;
            output[outputOffset + 21] = v8 >>> 34 & 0x3FFFFFFL;
            output[outputOffset + 22] = v8 >>> 60 & 0xFL | (v9 & 0x3FFFFFL) << 4;
            output[outputOffset + 23] = v9 >>> 22 & 0x3FFFFFFL;
            output[outputOffset + 24] = v9 >>> 48 & 0xFFFFL | (v10 & 0x3FFL) << 16;
            output[outputOffset + 25] = v10 >>> 10 & 0x3FFFFFFL;
            output[outputOffset + 26] = v10 >>> 36 & 0x3FFFFFFL;
            output[outputOffset + 27] = v10 >>> 62 & 3L | (v11 & 0xFFFFFFL) << 2;
            output[outputOffset + 28] = v11 >>> 24 & 0x3FFFFFFL;
            output[outputOffset + 29] = v11 >>> 50 & 0x3FFFL | (v12 & 0xFFFL) << 14;
            output[outputOffset + 30] = v12 >>> 12 & 0x3FFFFFFL;
            output[outputOffset + 31] = v12 >>> 38 & 0x3FFFFFFL;
        }
    }

    private static final class Unpacker27
    implements LongBitUnpacker {
        private Unpacker27() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker27.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            int v13 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFFL;
            output[outputOffset + 1] = v0 >>> 27 & 0x7FFFFFFL;
            output[outputOffset + 2] = v0 >>> 54 & 0x3FFL | (v1 & 0x1FFFFL) << 10;
            output[outputOffset + 3] = v1 >>> 17 & 0x7FFFFFFL;
            output[outputOffset + 4] = v1 >>> 44 & 0xFFFFFL | (v2 & 0x7FL) << 20;
            output[outputOffset + 5] = v2 >>> 7 & 0x7FFFFFFL;
            output[outputOffset + 6] = v2 >>> 34 & 0x7FFFFFFL;
            output[outputOffset + 7] = v2 >>> 61 & 7L | (v3 & 0xFFFFFFL) << 3;
            output[outputOffset + 8] = v3 >>> 24 & 0x7FFFFFFL;
            output[outputOffset + 9] = v3 >>> 51 & 0x1FFFL | (v4 & 0x3FFFL) << 13;
            output[outputOffset + 10] = v4 >>> 14 & 0x7FFFFFFL;
            output[outputOffset + 11] = v4 >>> 41 & 0x7FFFFFL | (v5 & 0xFL) << 23;
            output[outputOffset + 12] = v5 >>> 4 & 0x7FFFFFFL;
            output[outputOffset + 13] = v5 >>> 31 & 0x7FFFFFFL;
            output[outputOffset + 14] = v5 >>> 58 & 0x3FL | (v6 & 0x1FFFFFL) << 6;
            output[outputOffset + 15] = v6 >>> 21 & 0x7FFFFFFL;
            output[outputOffset + 16] = v6 >>> 48 & 0xFFFFL | (v7 & 0x7FFL) << 16;
            output[outputOffset + 17] = v7 >>> 11 & 0x7FFFFFFL;
            output[outputOffset + 18] = v7 >>> 38 & 0x3FFFFFFL | (v8 & 1L) << 26;
            output[outputOffset + 19] = v8 >>> 1 & 0x7FFFFFFL;
            output[outputOffset + 20] = v8 >>> 28 & 0x7FFFFFFL;
            output[outputOffset + 21] = v8 >>> 55 & 0x1FFL | (v9 & 0x3FFFFL) << 9;
            output[outputOffset + 22] = v9 >>> 18 & 0x7FFFFFFL;
            output[outputOffset + 23] = v9 >>> 45 & 0x7FFFFL | (v10 & 0xFFL) << 19;
            output[outputOffset + 24] = v10 >>> 8 & 0x7FFFFFFL;
            output[outputOffset + 25] = v10 >>> 35 & 0x7FFFFFFL;
            output[outputOffset + 26] = v10 >>> 62 & 3L | (v11 & 0x1FFFFFFL) << 2;
            output[outputOffset + 27] = v11 >>> 25 & 0x7FFFFFFL;
            output[outputOffset + 28] = v11 >>> 52 & 0xFFFL | (v12 & 0x7FFFL) << 12;
            output[outputOffset + 29] = v12 >>> 15 & 0x7FFFFFFL;
            output[outputOffset + 30] = v12 >>> 42 & 0x3FFFFFL | ((long)v13 & 0x1FL) << 22;
            output[outputOffset + 31] = (long)(v13 >>> 5) & 0x7FFFFFFL;
        }
    }

    private static final class Unpacker28
    implements LongBitUnpacker {
        private Unpacker28() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker28.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 28 & 0xFFFFFFFL;
            output[outputOffset + 2] = v0 >>> 56 & 0xFFL | (v1 & 0xFFFFFL) << 8;
            output[outputOffset + 3] = v1 >>> 20 & 0xFFFFFFFL;
            output[outputOffset + 4] = v1 >>> 48 & 0xFFFFL | (v2 & 0xFFFL) << 16;
            output[outputOffset + 5] = v2 >>> 12 & 0xFFFFFFFL;
            output[outputOffset + 6] = v2 >>> 40 & 0xFFFFFFL | (v3 & 0xFL) << 24;
            output[outputOffset + 7] = v3 >>> 4 & 0xFFFFFFFL;
            output[outputOffset + 8] = v3 >>> 32 & 0xFFFFFFFL;
            output[outputOffset + 9] = v3 >>> 60 & 0xFL | (v4 & 0xFFFFFFL) << 4;
            output[outputOffset + 10] = v4 >>> 24 & 0xFFFFFFFL;
            output[outputOffset + 11] = v4 >>> 52 & 0xFFFL | (v5 & 0xFFFFL) << 12;
            output[outputOffset + 12] = v5 >>> 16 & 0xFFFFFFFL;
            output[outputOffset + 13] = v5 >>> 44 & 0xFFFFFL | (v6 & 0xFFL) << 20;
            output[outputOffset + 14] = v6 >>> 8 & 0xFFFFFFFL;
            output[outputOffset + 15] = v6 >>> 36 & 0xFFFFFFFL;
            output[outputOffset + 16] = v7 & 0xFFFFFFFL;
            output[outputOffset + 17] = v7 >>> 28 & 0xFFFFFFFL;
            output[outputOffset + 18] = v7 >>> 56 & 0xFFL | (v8 & 0xFFFFFL) << 8;
            output[outputOffset + 19] = v8 >>> 20 & 0xFFFFFFFL;
            output[outputOffset + 20] = v8 >>> 48 & 0xFFFFL | (v9 & 0xFFFL) << 16;
            output[outputOffset + 21] = v9 >>> 12 & 0xFFFFFFFL;
            output[outputOffset + 22] = v9 >>> 40 & 0xFFFFFFL | (v10 & 0xFL) << 24;
            output[outputOffset + 23] = v10 >>> 4 & 0xFFFFFFFL;
            output[outputOffset + 24] = v10 >>> 32 & 0xFFFFFFFL;
            output[outputOffset + 25] = v10 >>> 60 & 0xFL | (v11 & 0xFFFFFFL) << 4;
            output[outputOffset + 26] = v11 >>> 24 & 0xFFFFFFFL;
            output[outputOffset + 27] = v11 >>> 52 & 0xFFFL | (v12 & 0xFFFFL) << 12;
            output[outputOffset + 28] = v12 >>> 16 & 0xFFFFFFFL;
            output[outputOffset + 29] = v12 >>> 44 & 0xFFFFFL | (v13 & 0xFFL) << 20;
            output[outputOffset + 30] = v13 >>> 8 & 0xFFFFFFFL;
            output[outputOffset + 31] = v13 >>> 36 & 0xFFFFFFFL;
        }
    }

    private static final class Unpacker29
    implements LongBitUnpacker {
        private Unpacker29() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker29.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            int v14 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFL;
            output[outputOffset + 1] = v0 >>> 29 & 0x1FFFFFFFL;
            output[outputOffset + 2] = v0 >>> 58 & 0x3FL | (v1 & 0x7FFFFFL) << 6;
            output[outputOffset + 3] = v1 >>> 23 & 0x1FFFFFFFL;
            output[outputOffset + 4] = v1 >>> 52 & 0xFFFL | (v2 & 0x1FFFFL) << 12;
            output[outputOffset + 5] = v2 >>> 17 & 0x1FFFFFFFL;
            output[outputOffset + 6] = v2 >>> 46 & 0x3FFFFL | (v3 & 0x7FFL) << 18;
            output[outputOffset + 7] = v3 >>> 11 & 0x1FFFFFFFL;
            output[outputOffset + 8] = v3 >>> 40 & 0xFFFFFFL | (v4 & 0x1FL) << 24;
            output[outputOffset + 9] = v4 >>> 5 & 0x1FFFFFFFL;
            output[outputOffset + 10] = v4 >>> 34 & 0x1FFFFFFFL;
            output[outputOffset + 11] = v4 >>> 63 & 1L | (v5 & 0xFFFFFFFL) << 1;
            output[outputOffset + 12] = v5 >>> 28 & 0x1FFFFFFFL;
            output[outputOffset + 13] = v5 >>> 57 & 0x7FL | (v6 & 0x3FFFFFL) << 7;
            output[outputOffset + 14] = v6 >>> 22 & 0x1FFFFFFFL;
            output[outputOffset + 15] = v6 >>> 51 & 0x1FFFL | (v7 & 0xFFFFL) << 13;
            output[outputOffset + 16] = v7 >>> 16 & 0x1FFFFFFFL;
            output[outputOffset + 17] = v7 >>> 45 & 0x7FFFFL | (v8 & 0x3FFL) << 19;
            output[outputOffset + 18] = v8 >>> 10 & 0x1FFFFFFFL;
            output[outputOffset + 19] = v8 >>> 39 & 0x1FFFFFFL | (v9 & 0xFL) << 25;
            output[outputOffset + 20] = v9 >>> 4 & 0x1FFFFFFFL;
            output[outputOffset + 21] = v9 >>> 33 & 0x1FFFFFFFL;
            output[outputOffset + 22] = v9 >>> 62 & 3L | (v10 & 0x7FFFFFFL) << 2;
            output[outputOffset + 23] = v10 >>> 27 & 0x1FFFFFFFL;
            output[outputOffset + 24] = v10 >>> 56 & 0xFFL | (v11 & 0x1FFFFFL) << 8;
            output[outputOffset + 25] = v11 >>> 21 & 0x1FFFFFFFL;
            output[outputOffset + 26] = v11 >>> 50 & 0x3FFFL | (v12 & 0x7FFFL) << 14;
            output[outputOffset + 27] = v12 >>> 15 & 0x1FFFFFFFL;
            output[outputOffset + 28] = v12 >>> 44 & 0xFFFFFL | (v13 & 0x1FFL) << 20;
            output[outputOffset + 29] = v13 >>> 9 & 0x1FFFFFFFL;
            output[outputOffset + 30] = v13 >>> 38 & 0x3FFFFFFL | ((long)v14 & 7L) << 26;
            output[outputOffset + 31] = (long)(v14 >>> 3) & 0x1FFFFFFFL;
        }
    }

    private static final class Unpacker30
    implements LongBitUnpacker {
        private Unpacker30() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker30.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFL;
            output[outputOffset + 1] = v0 >>> 30 & 0x3FFFFFFFL;
            output[outputOffset + 2] = v0 >>> 60 & 0xFL | (v1 & 0x3FFFFFFL) << 4;
            output[outputOffset + 3] = v1 >>> 26 & 0x3FFFFFFFL;
            output[outputOffset + 4] = v1 >>> 56 & 0xFFL | (v2 & 0x3FFFFFL) << 8;
            output[outputOffset + 5] = v2 >>> 22 & 0x3FFFFFFFL;
            output[outputOffset + 6] = v2 >>> 52 & 0xFFFL | (v3 & 0x3FFFFL) << 12;
            output[outputOffset + 7] = v3 >>> 18 & 0x3FFFFFFFL;
            output[outputOffset + 8] = v3 >>> 48 & 0xFFFFL | (v4 & 0x3FFFL) << 16;
            output[outputOffset + 9] = v4 >>> 14 & 0x3FFFFFFFL;
            output[outputOffset + 10] = v4 >>> 44 & 0xFFFFFL | (v5 & 0x3FFL) << 20;
            output[outputOffset + 11] = v5 >>> 10 & 0x3FFFFFFFL;
            output[outputOffset + 12] = v5 >>> 40 & 0xFFFFFFL | (v6 & 0x3FL) << 24;
            output[outputOffset + 13] = v6 >>> 6 & 0x3FFFFFFFL;
            output[outputOffset + 14] = v6 >>> 36 & 0xFFFFFFFL | (v7 & 3L) << 28;
            output[outputOffset + 15] = v7 >>> 2 & 0x3FFFFFFFL;
            output[outputOffset + 16] = v7 >>> 32 & 0x3FFFFFFFL;
            output[outputOffset + 17] = v7 >>> 62 & 3L | (v8 & 0xFFFFFFFL) << 2;
            output[outputOffset + 18] = v8 >>> 28 & 0x3FFFFFFFL;
            output[outputOffset + 19] = v8 >>> 58 & 0x3FL | (v9 & 0xFFFFFFL) << 6;
            output[outputOffset + 20] = v9 >>> 24 & 0x3FFFFFFFL;
            output[outputOffset + 21] = v9 >>> 54 & 0x3FFL | (v10 & 0xFFFFFL) << 10;
            output[outputOffset + 22] = v10 >>> 20 & 0x3FFFFFFFL;
            output[outputOffset + 23] = v10 >>> 50 & 0x3FFFL | (v11 & 0xFFFFL) << 14;
            output[outputOffset + 24] = v11 >>> 16 & 0x3FFFFFFFL;
            output[outputOffset + 25] = v11 >>> 46 & 0x3FFFFL | (v12 & 0xFFFL) << 18;
            output[outputOffset + 26] = v12 >>> 12 & 0x3FFFFFFFL;
            output[outputOffset + 27] = v12 >>> 42 & 0x3FFFFFL | (v13 & 0xFFL) << 22;
            output[outputOffset + 28] = v13 >>> 8 & 0x3FFFFFFFL;
            output[outputOffset + 29] = v13 >>> 38 & 0x3FFFFFFL | (v14 & 0xFL) << 26;
            output[outputOffset + 30] = v14 >>> 4 & 0x3FFFFFFFL;
            output[outputOffset + 31] = v14 >>> 34 & 0x3FFFFFFFL;
        }
    }

    private static final class Unpacker31
    implements LongBitUnpacker {
        private Unpacker31() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker31.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            int v15 = input.readInt();
            output[outputOffset] = v0 & Integer.MAX_VALUE;
            output[outputOffset + 1] = v0 >>> 31 & Integer.MAX_VALUE;
            output[outputOffset + 2] = v0 >>> 62 & 3L | (v1 & 0x1FFFFFFFL) << 2;
            output[outputOffset + 3] = v1 >>> 29 & Integer.MAX_VALUE;
            output[outputOffset + 4] = v1 >>> 60 & 0xFL | (v2 & 0x7FFFFFFL) << 4;
            output[outputOffset + 5] = v2 >>> 27 & Integer.MAX_VALUE;
            output[outputOffset + 6] = v2 >>> 58 & 0x3FL | (v3 & 0x1FFFFFFL) << 6;
            output[outputOffset + 7] = v3 >>> 25 & Integer.MAX_VALUE;
            output[outputOffset + 8] = v3 >>> 56 & 0xFFL | (v4 & 0x7FFFFFL) << 8;
            output[outputOffset + 9] = v4 >>> 23 & Integer.MAX_VALUE;
            output[outputOffset + 10] = v4 >>> 54 & 0x3FFL | (v5 & 0x1FFFFFL) << 10;
            output[outputOffset + 11] = v5 >>> 21 & Integer.MAX_VALUE;
            output[outputOffset + 12] = v5 >>> 52 & 0xFFFL | (v6 & 0x7FFFFL) << 12;
            output[outputOffset + 13] = v6 >>> 19 & Integer.MAX_VALUE;
            output[outputOffset + 14] = v6 >>> 50 & 0x3FFFL | (v7 & 0x1FFFFL) << 14;
            output[outputOffset + 15] = v7 >>> 17 & Integer.MAX_VALUE;
            output[outputOffset + 16] = v7 >>> 48 & 0xFFFFL | (v8 & 0x7FFFL) << 16;
            output[outputOffset + 17] = v8 >>> 15 & Integer.MAX_VALUE;
            output[outputOffset + 18] = v8 >>> 46 & 0x3FFFFL | (v9 & 0x1FFFL) << 18;
            output[outputOffset + 19] = v9 >>> 13 & Integer.MAX_VALUE;
            output[outputOffset + 20] = v9 >>> 44 & 0xFFFFFL | (v10 & 0x7FFL) << 20;
            output[outputOffset + 21] = v10 >>> 11 & Integer.MAX_VALUE;
            output[outputOffset + 22] = v10 >>> 42 & 0x3FFFFFL | (v11 & 0x1FFL) << 22;
            output[outputOffset + 23] = v11 >>> 9 & Integer.MAX_VALUE;
            output[outputOffset + 24] = v11 >>> 40 & 0xFFFFFFL | (v12 & 0x7FL) << 24;
            output[outputOffset + 25] = v12 >>> 7 & Integer.MAX_VALUE;
            output[outputOffset + 26] = v12 >>> 38 & 0x3FFFFFFL | (v13 & 0x1FL) << 26;
            output[outputOffset + 27] = v13 >>> 5 & Integer.MAX_VALUE;
            output[outputOffset + 28] = v13 >>> 36 & 0xFFFFFFFL | (v14 & 7L) << 28;
            output[outputOffset + 29] = v14 >>> 3 & Integer.MAX_VALUE;
            output[outputOffset + 30] = v14 >>> 34 & 0x3FFFFFFFL | ((long)v15 & 1L) << 30;
            output[outputOffset + 31] = (long)(v15 >>> 1) & Integer.MAX_VALUE;
        }
    }

    private static final class Unpacker32
    implements LongBitUnpacker {
        private Unpacker32() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker32.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 2] = v1 & 0xFFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 4] = v2 & 0xFFFFFFFFL;
            output[outputOffset + 5] = v2 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 6] = v3 & 0xFFFFFFFFL;
            output[outputOffset + 7] = v3 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 8] = v4 & 0xFFFFFFFFL;
            output[outputOffset + 9] = v4 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 10] = v5 & 0xFFFFFFFFL;
            output[outputOffset + 11] = v5 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 12] = v6 & 0xFFFFFFFFL;
            output[outputOffset + 13] = v6 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 14] = v7 & 0xFFFFFFFFL;
            output[outputOffset + 15] = v7 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 16] = v8 & 0xFFFFFFFFL;
            output[outputOffset + 17] = v8 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 18] = v9 & 0xFFFFFFFFL;
            output[outputOffset + 19] = v9 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 20] = v10 & 0xFFFFFFFFL;
            output[outputOffset + 21] = v10 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 22] = v11 & 0xFFFFFFFFL;
            output[outputOffset + 23] = v11 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 24] = v12 & 0xFFFFFFFFL;
            output[outputOffset + 25] = v12 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 26] = v13 & 0xFFFFFFFFL;
            output[outputOffset + 27] = v13 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 28] = v14 & 0xFFFFFFFFL;
            output[outputOffset + 29] = v14 >>> 32 & 0xFFFFFFFFL;
            output[outputOffset + 30] = v15 & 0xFFFFFFFFL;
            output[outputOffset + 31] = v15 >>> 32 & 0xFFFFFFFFL;
        }
    }

    private static final class Unpacker33
    implements LongBitUnpacker {
        private Unpacker33() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker33.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            int v16 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 33 & Integer.MAX_VALUE | (v1 & 3L) << 31;
            output[outputOffset + 2] = v1 >>> 2 & 0x1FFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 35 & 0x1FFFFFFFL | (v2 & 0xFL) << 29;
            output[outputOffset + 4] = v2 >>> 4 & 0x1FFFFFFFFL;
            output[outputOffset + 5] = v2 >>> 37 & 0x7FFFFFFL | (v3 & 0x3FL) << 27;
            output[outputOffset + 6] = v3 >>> 6 & 0x1FFFFFFFFL;
            output[outputOffset + 7] = v3 >>> 39 & 0x1FFFFFFL | (v4 & 0xFFL) << 25;
            output[outputOffset + 8] = v4 >>> 8 & 0x1FFFFFFFFL;
            output[outputOffset + 9] = v4 >>> 41 & 0x7FFFFFL | (v5 & 0x3FFL) << 23;
            output[outputOffset + 10] = v5 >>> 10 & 0x1FFFFFFFFL;
            output[outputOffset + 11] = v5 >>> 43 & 0x1FFFFFL | (v6 & 0xFFFL) << 21;
            output[outputOffset + 12] = v6 >>> 12 & 0x1FFFFFFFFL;
            output[outputOffset + 13] = v6 >>> 45 & 0x7FFFFL | (v7 & 0x3FFFL) << 19;
            output[outputOffset + 14] = v7 >>> 14 & 0x1FFFFFFFFL;
            output[outputOffset + 15] = v7 >>> 47 & 0x1FFFFL | (v8 & 0xFFFFL) << 17;
            output[outputOffset + 16] = v8 >>> 16 & 0x1FFFFFFFFL;
            output[outputOffset + 17] = v8 >>> 49 & 0x7FFFL | (v9 & 0x3FFFFL) << 15;
            output[outputOffset + 18] = v9 >>> 18 & 0x1FFFFFFFFL;
            output[outputOffset + 19] = v9 >>> 51 & 0x1FFFL | (v10 & 0xFFFFFL) << 13;
            output[outputOffset + 20] = v10 >>> 20 & 0x1FFFFFFFFL;
            output[outputOffset + 21] = v10 >>> 53 & 0x7FFL | (v11 & 0x3FFFFFL) << 11;
            output[outputOffset + 22] = v11 >>> 22 & 0x1FFFFFFFFL;
            output[outputOffset + 23] = v11 >>> 55 & 0x1FFL | (v12 & 0xFFFFFFL) << 9;
            output[outputOffset + 24] = v12 >>> 24 & 0x1FFFFFFFFL;
            output[outputOffset + 25] = v12 >>> 57 & 0x7FL | (v13 & 0x3FFFFFFL) << 7;
            output[outputOffset + 26] = v13 >>> 26 & 0x1FFFFFFFFL;
            output[outputOffset + 27] = v13 >>> 59 & 0x1FL | (v14 & 0xFFFFFFFL) << 5;
            output[outputOffset + 28] = v14 >>> 28 & 0x1FFFFFFFFL;
            output[outputOffset + 29] = v14 >>> 61 & 7L | (v15 & 0x3FFFFFFFL) << 3;
            output[outputOffset + 30] = v15 >>> 30 & 0x1FFFFFFFFL;
            output[outputOffset + 31] = v15 >>> 63 & 1L | ((long)v16 & 0xFFFFFFFFL) << 1;
        }
    }

    private static final class Unpacker34
    implements LongBitUnpacker {
        private Unpacker34() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker34.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 34 & 0x3FFFFFFFL | (v1 & 0xFL) << 30;
            output[outputOffset + 2] = v1 >>> 4 & 0x3FFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 38 & 0x3FFFFFFL | (v2 & 0xFFL) << 26;
            output[outputOffset + 4] = v2 >>> 8 & 0x3FFFFFFFFL;
            output[outputOffset + 5] = v2 >>> 42 & 0x3FFFFFL | (v3 & 0xFFFL) << 22;
            output[outputOffset + 6] = v3 >>> 12 & 0x3FFFFFFFFL;
            output[outputOffset + 7] = v3 >>> 46 & 0x3FFFFL | (v4 & 0xFFFFL) << 18;
            output[outputOffset + 8] = v4 >>> 16 & 0x3FFFFFFFFL;
            output[outputOffset + 9] = v4 >>> 50 & 0x3FFFL | (v5 & 0xFFFFFL) << 14;
            output[outputOffset + 10] = v5 >>> 20 & 0x3FFFFFFFFL;
            output[outputOffset + 11] = v5 >>> 54 & 0x3FFL | (v6 & 0xFFFFFFL) << 10;
            output[outputOffset + 12] = v6 >>> 24 & 0x3FFFFFFFFL;
            output[outputOffset + 13] = v6 >>> 58 & 0x3FL | (v7 & 0xFFFFFFFL) << 6;
            output[outputOffset + 14] = v7 >>> 28 & 0x3FFFFFFFFL;
            output[outputOffset + 15] = v7 >>> 62 & 3L | (v8 & 0xFFFFFFFFL) << 2;
            output[outputOffset + 16] = v8 >>> 32 & 0xFFFFFFFFL | (v9 & 3L) << 32;
            output[outputOffset + 17] = v9 >>> 2 & 0x3FFFFFFFFL;
            output[outputOffset + 18] = v9 >>> 36 & 0xFFFFFFFL | (v10 & 0x3FL) << 28;
            output[outputOffset + 19] = v10 >>> 6 & 0x3FFFFFFFFL;
            output[outputOffset + 20] = v10 >>> 40 & 0xFFFFFFL | (v11 & 0x3FFL) << 24;
            output[outputOffset + 21] = v11 >>> 10 & 0x3FFFFFFFFL;
            output[outputOffset + 22] = v11 >>> 44 & 0xFFFFFL | (v12 & 0x3FFFL) << 20;
            output[outputOffset + 23] = v12 >>> 14 & 0x3FFFFFFFFL;
            output[outputOffset + 24] = v12 >>> 48 & 0xFFFFL | (v13 & 0x3FFFFL) << 16;
            output[outputOffset + 25] = v13 >>> 18 & 0x3FFFFFFFFL;
            output[outputOffset + 26] = v13 >>> 52 & 0xFFFL | (v14 & 0x3FFFFFL) << 12;
            output[outputOffset + 27] = v14 >>> 22 & 0x3FFFFFFFFL;
            output[outputOffset + 28] = v14 >>> 56 & 0xFFL | (v15 & 0x3FFFFFFL) << 8;
            output[outputOffset + 29] = v15 >>> 26 & 0x3FFFFFFFFL;
            output[outputOffset + 30] = v15 >>> 60 & 0xFL | (v16 & 0x3FFFFFFFL) << 4;
            output[outputOffset + 31] = v16 >>> 30 & 0x3FFFFFFFFL;
        }
    }

    private static final class Unpacker35
    implements LongBitUnpacker {
        private Unpacker35() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker35.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            int v17 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 35 & 0x1FFFFFFFL | (v1 & 0x3FL) << 29;
            output[outputOffset + 2] = v1 >>> 6 & 0x7FFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 41 & 0x7FFFFFL | (v2 & 0xFFFL) << 23;
            output[outputOffset + 4] = v2 >>> 12 & 0x7FFFFFFFFL;
            output[outputOffset + 5] = v2 >>> 47 & 0x1FFFFL | (v3 & 0x3FFFFL) << 17;
            output[outputOffset + 6] = v3 >>> 18 & 0x7FFFFFFFFL;
            output[outputOffset + 7] = v3 >>> 53 & 0x7FFL | (v4 & 0xFFFFFFL) << 11;
            output[outputOffset + 8] = v4 >>> 24 & 0x7FFFFFFFFL;
            output[outputOffset + 9] = v4 >>> 59 & 0x1FL | (v5 & 0x3FFFFFFFL) << 5;
            output[outputOffset + 10] = v5 >>> 30 & 0x3FFFFFFFFL | (v6 & 1L) << 34;
            output[outputOffset + 11] = v6 >>> 1 & 0x7FFFFFFFFL;
            output[outputOffset + 12] = v6 >>> 36 & 0xFFFFFFFL | (v7 & 0x7FL) << 28;
            output[outputOffset + 13] = v7 >>> 7 & 0x7FFFFFFFFL;
            output[outputOffset + 14] = v7 >>> 42 & 0x3FFFFFL | (v8 & 0x1FFFL) << 22;
            output[outputOffset + 15] = v8 >>> 13 & 0x7FFFFFFFFL;
            output[outputOffset + 16] = v8 >>> 48 & 0xFFFFL | (v9 & 0x7FFFFL) << 16;
            output[outputOffset + 17] = v9 >>> 19 & 0x7FFFFFFFFL;
            output[outputOffset + 18] = v9 >>> 54 & 0x3FFL | (v10 & 0x1FFFFFFL) << 10;
            output[outputOffset + 19] = v10 >>> 25 & 0x7FFFFFFFFL;
            output[outputOffset + 20] = v10 >>> 60 & 0xFL | (v11 & Integer.MAX_VALUE) << 4;
            output[outputOffset + 21] = v11 >>> 31 & 0x1FFFFFFFFL | (v12 & 3L) << 33;
            output[outputOffset + 22] = v12 >>> 2 & 0x7FFFFFFFFL;
            output[outputOffset + 23] = v12 >>> 37 & 0x7FFFFFFL | (v13 & 0xFFL) << 27;
            output[outputOffset + 24] = v13 >>> 8 & 0x7FFFFFFFFL;
            output[outputOffset + 25] = v13 >>> 43 & 0x1FFFFFL | (v14 & 0x3FFFL) << 21;
            output[outputOffset + 26] = v14 >>> 14 & 0x7FFFFFFFFL;
            output[outputOffset + 27] = v14 >>> 49 & 0x7FFFL | (v15 & 0xFFFFFL) << 15;
            output[outputOffset + 28] = v15 >>> 20 & 0x7FFFFFFFFL;
            output[outputOffset + 29] = v15 >>> 55 & 0x1FFL | (v16 & 0x3FFFFFFL) << 9;
            output[outputOffset + 30] = v16 >>> 26 & 0x7FFFFFFFFL;
            output[outputOffset + 31] = v16 >>> 61 & 7L | ((long)v17 & 0xFFFFFFFFL) << 3;
        }
    }

    private static final class Unpacker36
    implements LongBitUnpacker {
        private Unpacker36() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker36.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 36 & 0xFFFFFFFL | (v1 & 0xFFL) << 28;
            output[outputOffset + 2] = v1 >>> 8 & 0xFFFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 44 & 0xFFFFFL | (v2 & 0xFFFFL) << 20;
            output[outputOffset + 4] = v2 >>> 16 & 0xFFFFFFFFFL;
            output[outputOffset + 5] = v2 >>> 52 & 0xFFFL | (v3 & 0xFFFFFFL) << 12;
            output[outputOffset + 6] = v3 >>> 24 & 0xFFFFFFFFFL;
            output[outputOffset + 7] = v3 >>> 60 & 0xFL | (v4 & 0xFFFFFFFFL) << 4;
            output[outputOffset + 8] = v4 >>> 32 & 0xFFFFFFFFL | (v5 & 0xFL) << 32;
            output[outputOffset + 9] = v5 >>> 4 & 0xFFFFFFFFFL;
            output[outputOffset + 10] = v5 >>> 40 & 0xFFFFFFL | (v6 & 0xFFFL) << 24;
            output[outputOffset + 11] = v6 >>> 12 & 0xFFFFFFFFFL;
            output[outputOffset + 12] = v6 >>> 48 & 0xFFFFL | (v7 & 0xFFFFFL) << 16;
            output[outputOffset + 13] = v7 >>> 20 & 0xFFFFFFFFFL;
            output[outputOffset + 14] = v7 >>> 56 & 0xFFL | (v8 & 0xFFFFFFFL) << 8;
            output[outputOffset + 15] = v8 >>> 28 & 0xFFFFFFFFFL;
            output[outputOffset + 16] = v9 & 0xFFFFFFFFFL;
            output[outputOffset + 17] = v9 >>> 36 & 0xFFFFFFFL | (v10 & 0xFFL) << 28;
            output[outputOffset + 18] = v10 >>> 8 & 0xFFFFFFFFFL;
            output[outputOffset + 19] = v10 >>> 44 & 0xFFFFFL | (v11 & 0xFFFFL) << 20;
            output[outputOffset + 20] = v11 >>> 16 & 0xFFFFFFFFFL;
            output[outputOffset + 21] = v11 >>> 52 & 0xFFFL | (v12 & 0xFFFFFFL) << 12;
            output[outputOffset + 22] = v12 >>> 24 & 0xFFFFFFFFFL;
            output[outputOffset + 23] = v12 >>> 60 & 0xFL | (v13 & 0xFFFFFFFFL) << 4;
            output[outputOffset + 24] = v13 >>> 32 & 0xFFFFFFFFL | (v14 & 0xFL) << 32;
            output[outputOffset + 25] = v14 >>> 4 & 0xFFFFFFFFFL;
            output[outputOffset + 26] = v14 >>> 40 & 0xFFFFFFL | (v15 & 0xFFFL) << 24;
            output[outputOffset + 27] = v15 >>> 12 & 0xFFFFFFFFFL;
            output[outputOffset + 28] = v15 >>> 48 & 0xFFFFL | (v16 & 0xFFFFFL) << 16;
            output[outputOffset + 29] = v16 >>> 20 & 0xFFFFFFFFFL;
            output[outputOffset + 30] = v16 >>> 56 & 0xFFL | (v17 & 0xFFFFFFFL) << 8;
            output[outputOffset + 31] = v17 >>> 28 & 0xFFFFFFFFFL;
        }
    }

    private static final class Unpacker37
    implements LongBitUnpacker {
        private Unpacker37() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker37.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            int v18 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 37 & 0x7FFFFFFL | (v1 & 0x3FFL) << 27;
            output[outputOffset + 2] = v1 >>> 10 & 0x1FFFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 47 & 0x1FFFFL | (v2 & 0xFFFFFL) << 17;
            output[outputOffset + 4] = v2 >>> 20 & 0x1FFFFFFFFFL;
            output[outputOffset + 5] = v2 >>> 57 & 0x7FL | (v3 & 0x3FFFFFFFL) << 7;
            output[outputOffset + 6] = v3 >>> 30 & 0x3FFFFFFFFL | (v4 & 7L) << 34;
            output[outputOffset + 7] = v4 >>> 3 & 0x1FFFFFFFFFL;
            output[outputOffset + 8] = v4 >>> 40 & 0xFFFFFFL | (v5 & 0x1FFFL) << 24;
            output[outputOffset + 9] = v5 >>> 13 & 0x1FFFFFFFFFL;
            output[outputOffset + 10] = v5 >>> 50 & 0x3FFFL | (v6 & 0x7FFFFFL) << 14;
            output[outputOffset + 11] = v6 >>> 23 & 0x1FFFFFFFFFL;
            output[outputOffset + 12] = v6 >>> 60 & 0xFL | (v7 & 0x1FFFFFFFFL) << 4;
            output[outputOffset + 13] = v7 >>> 33 & Integer.MAX_VALUE | (v8 & 0x3FL) << 31;
            output[outputOffset + 14] = v8 >>> 6 & 0x1FFFFFFFFFL;
            output[outputOffset + 15] = v8 >>> 43 & 0x1FFFFFL | (v9 & 0xFFFFL) << 21;
            output[outputOffset + 16] = v9 >>> 16 & 0x1FFFFFFFFFL;
            output[outputOffset + 17] = v9 >>> 53 & 0x7FFL | (v10 & 0x3FFFFFFL) << 11;
            output[outputOffset + 18] = v10 >>> 26 & 0x1FFFFFFFFFL;
            output[outputOffset + 19] = v10 >>> 63 & 1L | (v11 & 0xFFFFFFFFFL) << 1;
            output[outputOffset + 20] = v11 >>> 36 & 0xFFFFFFFL | (v12 & 0x1FFL) << 28;
            output[outputOffset + 21] = v12 >>> 9 & 0x1FFFFFFFFFL;
            output[outputOffset + 22] = v12 >>> 46 & 0x3FFFFL | (v13 & 0x7FFFFL) << 18;
            output[outputOffset + 23] = v13 >>> 19 & 0x1FFFFFFFFFL;
            output[outputOffset + 24] = v13 >>> 56 & 0xFFL | (v14 & 0x1FFFFFFFL) << 8;
            output[outputOffset + 25] = v14 >>> 29 & 0x7FFFFFFFFL | (v15 & 3L) << 35;
            output[outputOffset + 26] = v15 >>> 2 & 0x1FFFFFFFFFL;
            output[outputOffset + 27] = v15 >>> 39 & 0x1FFFFFFL | (v16 & 0xFFFL) << 25;
            output[outputOffset + 28] = v16 >>> 12 & 0x1FFFFFFFFFL;
            output[outputOffset + 29] = v16 >>> 49 & 0x7FFFL | (v17 & 0x3FFFFFL) << 15;
            output[outputOffset + 30] = v17 >>> 22 & 0x1FFFFFFFFFL;
            output[outputOffset + 31] = v17 >>> 59 & 0x1FL | ((long)v18 & 0xFFFFFFFFL) << 5;
        }
    }

    private static final class Unpacker38
    implements LongBitUnpacker {
        private Unpacker38() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker38.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 38 & 0x3FFFFFFL | (v1 & 0xFFFL) << 26;
            output[outputOffset + 2] = v1 >>> 12 & 0x3FFFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 50 & 0x3FFFL | (v2 & 0xFFFFFFL) << 14;
            output[outputOffset + 4] = v2 >>> 24 & 0x3FFFFFFFFFL;
            output[outputOffset + 5] = v2 >>> 62 & 3L | (v3 & 0xFFFFFFFFFL) << 2;
            output[outputOffset + 6] = v3 >>> 36 & 0xFFFFFFFL | (v4 & 0x3FFL) << 28;
            output[outputOffset + 7] = v4 >>> 10 & 0x3FFFFFFFFFL;
            output[outputOffset + 8] = v4 >>> 48 & 0xFFFFL | (v5 & 0x3FFFFFL) << 16;
            output[outputOffset + 9] = v5 >>> 22 & 0x3FFFFFFFFFL;
            output[outputOffset + 10] = v5 >>> 60 & 0xFL | (v6 & 0x3FFFFFFFFL) << 4;
            output[outputOffset + 11] = v6 >>> 34 & 0x3FFFFFFFL | (v7 & 0xFFL) << 30;
            output[outputOffset + 12] = v7 >>> 8 & 0x3FFFFFFFFFL;
            output[outputOffset + 13] = v7 >>> 46 & 0x3FFFFL | (v8 & 0xFFFFFL) << 18;
            output[outputOffset + 14] = v8 >>> 20 & 0x3FFFFFFFFFL;
            output[outputOffset + 15] = v8 >>> 58 & 0x3FL | (v9 & 0xFFFFFFFFL) << 6;
            output[outputOffset + 16] = v9 >>> 32 & 0xFFFFFFFFL | (v10 & 0x3FL) << 32;
            output[outputOffset + 17] = v10 >>> 6 & 0x3FFFFFFFFFL;
            output[outputOffset + 18] = v10 >>> 44 & 0xFFFFFL | (v11 & 0x3FFFFL) << 20;
            output[outputOffset + 19] = v11 >>> 18 & 0x3FFFFFFFFFL;
            output[outputOffset + 20] = v11 >>> 56 & 0xFFL | (v12 & 0x3FFFFFFFL) << 8;
            output[outputOffset + 21] = v12 >>> 30 & 0x3FFFFFFFFL | (v13 & 0xFL) << 34;
            output[outputOffset + 22] = v13 >>> 4 & 0x3FFFFFFFFFL;
            output[outputOffset + 23] = v13 >>> 42 & 0x3FFFFFL | (v14 & 0xFFFFL) << 22;
            output[outputOffset + 24] = v14 >>> 16 & 0x3FFFFFFFFFL;
            output[outputOffset + 25] = v14 >>> 54 & 0x3FFL | (v15 & 0xFFFFFFFL) << 10;
            output[outputOffset + 26] = v15 >>> 28 & 0xFFFFFFFFFL | (v16 & 3L) << 36;
            output[outputOffset + 27] = v16 >>> 2 & 0x3FFFFFFFFFL;
            output[outputOffset + 28] = v16 >>> 40 & 0xFFFFFFL | (v17 & 0x3FFFL) << 24;
            output[outputOffset + 29] = v17 >>> 14 & 0x3FFFFFFFFFL;
            output[outputOffset + 30] = v17 >>> 52 & 0xFFFL | (v18 & 0x3FFFFFFL) << 12;
            output[outputOffset + 31] = v18 >>> 26 & 0x3FFFFFFFFFL;
        }
    }

    private static final class Unpacker39
    implements LongBitUnpacker {
        private Unpacker39() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker39.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            int v19 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 39 & 0x1FFFFFFL | (v1 & 0x3FFFL) << 25;
            output[outputOffset + 2] = v1 >>> 14 & 0x7FFFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 53 & 0x7FFL | (v2 & 0xFFFFFFFL) << 11;
            output[outputOffset + 4] = v2 >>> 28 & 0xFFFFFFFFFL | (v3 & 7L) << 36;
            output[outputOffset + 5] = v3 >>> 3 & 0x7FFFFFFFFFL;
            output[outputOffset + 6] = v3 >>> 42 & 0x3FFFFFL | (v4 & 0x1FFFFL) << 22;
            output[outputOffset + 7] = v4 >>> 17 & 0x7FFFFFFFFFL;
            output[outputOffset + 8] = v4 >>> 56 & 0xFFL | (v5 & Integer.MAX_VALUE) << 8;
            output[outputOffset + 9] = v5 >>> 31 & 0x1FFFFFFFFL | (v6 & 0x3FL) << 33;
            output[outputOffset + 10] = v6 >>> 6 & 0x7FFFFFFFFFL;
            output[outputOffset + 11] = v6 >>> 45 & 0x7FFFFL | (v7 & 0xFFFFFL) << 19;
            output[outputOffset + 12] = v7 >>> 20 & 0x7FFFFFFFFFL;
            output[outputOffset + 13] = v7 >>> 59 & 0x1FL | (v8 & 0x3FFFFFFFFL) << 5;
            output[outputOffset + 14] = v8 >>> 34 & 0x3FFFFFFFL | (v9 & 0x1FFL) << 30;
            output[outputOffset + 15] = v9 >>> 9 & 0x7FFFFFFFFFL;
            output[outputOffset + 16] = v9 >>> 48 & 0xFFFFL | (v10 & 0x7FFFFFL) << 16;
            output[outputOffset + 17] = v10 >>> 23 & 0x7FFFFFFFFFL;
            output[outputOffset + 18] = v10 >>> 62 & 3L | (v11 & 0x1FFFFFFFFFL) << 2;
            output[outputOffset + 19] = v11 >>> 37 & 0x7FFFFFFL | (v12 & 0xFFFL) << 27;
            output[outputOffset + 20] = v12 >>> 12 & 0x7FFFFFFFFFL;
            output[outputOffset + 21] = v12 >>> 51 & 0x1FFFL | (v13 & 0x3FFFFFFL) << 13;
            output[outputOffset + 22] = v13 >>> 26 & 0x3FFFFFFFFFL | (v14 & 1L) << 38;
            output[outputOffset + 23] = v14 >>> 1 & 0x7FFFFFFFFFL;
            output[outputOffset + 24] = v14 >>> 40 & 0xFFFFFFL | (v15 & 0x7FFFL) << 24;
            output[outputOffset + 25] = v15 >>> 15 & 0x7FFFFFFFFFL;
            output[outputOffset + 26] = v15 >>> 54 & 0x3FFL | (v16 & 0x1FFFFFFFL) << 10;
            output[outputOffset + 27] = v16 >>> 29 & 0x7FFFFFFFFL | (v17 & 0xFL) << 35;
            output[outputOffset + 28] = v17 >>> 4 & 0x7FFFFFFFFFL;
            output[outputOffset + 29] = v17 >>> 43 & 0x1FFFFFL | (v18 & 0x3FFFFL) << 21;
            output[outputOffset + 30] = v18 >>> 18 & 0x7FFFFFFFFFL;
            output[outputOffset + 31] = v18 >>> 57 & 0x7FL | ((long)v19 & 0xFFFFFFFFL) << 7;
        }
    }

    private static final class Unpacker40
    implements LongBitUnpacker {
        private Unpacker40() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker40.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 40 & 0xFFFFFFL | (v1 & 0xFFFFL) << 24;
            output[outputOffset + 2] = v1 >>> 16 & 0xFFFFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 56 & 0xFFL | (v2 & 0xFFFFFFFFL) << 8;
            output[outputOffset + 4] = v2 >>> 32 & 0xFFFFFFFFL | (v3 & 0xFFL) << 32;
            output[outputOffset + 5] = v3 >>> 8 & 0xFFFFFFFFFFL;
            output[outputOffset + 6] = v3 >>> 48 & 0xFFFFL | (v4 & 0xFFFFFFL) << 16;
            output[outputOffset + 7] = v4 >>> 24 & 0xFFFFFFFFFFL;
            output[outputOffset + 8] = v5 & 0xFFFFFFFFFFL;
            output[outputOffset + 9] = v5 >>> 40 & 0xFFFFFFL | (v6 & 0xFFFFL) << 24;
            output[outputOffset + 10] = v6 >>> 16 & 0xFFFFFFFFFFL;
            output[outputOffset + 11] = v6 >>> 56 & 0xFFL | (v7 & 0xFFFFFFFFL) << 8;
            output[outputOffset + 12] = v7 >>> 32 & 0xFFFFFFFFL | (v8 & 0xFFL) << 32;
            output[outputOffset + 13] = v8 >>> 8 & 0xFFFFFFFFFFL;
            output[outputOffset + 14] = v8 >>> 48 & 0xFFFFL | (v9 & 0xFFFFFFL) << 16;
            output[outputOffset + 15] = v9 >>> 24 & 0xFFFFFFFFFFL;
            output[outputOffset + 16] = v10 & 0xFFFFFFFFFFL;
            output[outputOffset + 17] = v10 >>> 40 & 0xFFFFFFL | (v11 & 0xFFFFL) << 24;
            output[outputOffset + 18] = v11 >>> 16 & 0xFFFFFFFFFFL;
            output[outputOffset + 19] = v11 >>> 56 & 0xFFL | (v12 & 0xFFFFFFFFL) << 8;
            output[outputOffset + 20] = v12 >>> 32 & 0xFFFFFFFFL | (v13 & 0xFFL) << 32;
            output[outputOffset + 21] = v13 >>> 8 & 0xFFFFFFFFFFL;
            output[outputOffset + 22] = v13 >>> 48 & 0xFFFFL | (v14 & 0xFFFFFFL) << 16;
            output[outputOffset + 23] = v14 >>> 24 & 0xFFFFFFFFFFL;
            output[outputOffset + 24] = v15 & 0xFFFFFFFFFFL;
            output[outputOffset + 25] = v15 >>> 40 & 0xFFFFFFL | (v16 & 0xFFFFL) << 24;
            output[outputOffset + 26] = v16 >>> 16 & 0xFFFFFFFFFFL;
            output[outputOffset + 27] = v16 >>> 56 & 0xFFL | (v17 & 0xFFFFFFFFL) << 8;
            output[outputOffset + 28] = v17 >>> 32 & 0xFFFFFFFFL | (v18 & 0xFFL) << 32;
            output[outputOffset + 29] = v18 >>> 8 & 0xFFFFFFFFFFL;
            output[outputOffset + 30] = v18 >>> 48 & 0xFFFFL | (v19 & 0xFFFFFFL) << 16;
            output[outputOffset + 31] = v19 >>> 24 & 0xFFFFFFFFFFL;
        }
    }

    private static final class Unpacker41
    implements LongBitUnpacker {
        private Unpacker41() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker41.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            int v20 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 41 & 0x7FFFFFL | (v1 & 0x3FFFFL) << 23;
            output[outputOffset + 2] = v1 >>> 18 & 0x1FFFFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 59 & 0x1FL | (v2 & 0xFFFFFFFFFL) << 5;
            output[outputOffset + 4] = v2 >>> 36 & 0xFFFFFFFL | (v3 & 0x1FFFL) << 28;
            output[outputOffset + 5] = v3 >>> 13 & 0x1FFFFFFFFFFL;
            output[outputOffset + 6] = v3 >>> 54 & 0x3FFL | (v4 & Integer.MAX_VALUE) << 10;
            output[outputOffset + 7] = v4 >>> 31 & 0x1FFFFFFFFL | (v5 & 0xFFL) << 33;
            output[outputOffset + 8] = v5 >>> 8 & 0x1FFFFFFFFFFL;
            output[outputOffset + 9] = v5 >>> 49 & 0x7FFFL | (v6 & 0x3FFFFFFL) << 15;
            output[outputOffset + 10] = v6 >>> 26 & 0x3FFFFFFFFFL | (v7 & 7L) << 38;
            output[outputOffset + 11] = v7 >>> 3 & 0x1FFFFFFFFFFL;
            output[outputOffset + 12] = v7 >>> 44 & 0xFFFFFL | (v8 & 0x1FFFFFL) << 20;
            output[outputOffset + 13] = v8 >>> 21 & 0x1FFFFFFFFFFL;
            output[outputOffset + 14] = v8 >>> 62 & 3L | (v9 & 0x7FFFFFFFFFL) << 2;
            output[outputOffset + 15] = v9 >>> 39 & 0x1FFFFFFL | (v10 & 0xFFFFL) << 25;
            output[outputOffset + 16] = v10 >>> 16 & 0x1FFFFFFFFFFL;
            output[outputOffset + 17] = v10 >>> 57 & 0x7FL | (v11 & 0x3FFFFFFFFL) << 7;
            output[outputOffset + 18] = v11 >>> 34 & 0x3FFFFFFFL | (v12 & 0x7FFL) << 30;
            output[outputOffset + 19] = v12 >>> 11 & 0x1FFFFFFFFFFL;
            output[outputOffset + 20] = v12 >>> 52 & 0xFFFL | (v13 & 0x1FFFFFFFL) << 12;
            output[outputOffset + 21] = v13 >>> 29 & 0x7FFFFFFFFL | (v14 & 0x3FL) << 35;
            output[outputOffset + 22] = v14 >>> 6 & 0x1FFFFFFFFFFL;
            output[outputOffset + 23] = v14 >>> 47 & 0x1FFFFL | (v15 & 0xFFFFFFL) << 17;
            output[outputOffset + 24] = v15 >>> 24 & 0xFFFFFFFFFFL | (v16 & 1L) << 40;
            output[outputOffset + 25] = v16 >>> 1 & 0x1FFFFFFFFFFL;
            output[outputOffset + 26] = v16 >>> 42 & 0x3FFFFFL | (v17 & 0x7FFFFL) << 22;
            output[outputOffset + 27] = v17 >>> 19 & 0x1FFFFFFFFFFL;
            output[outputOffset + 28] = v17 >>> 60 & 0xFL | (v18 & 0x1FFFFFFFFFL) << 4;
            output[outputOffset + 29] = v18 >>> 37 & 0x7FFFFFFL | (v19 & 0x3FFFL) << 27;
            output[outputOffset + 30] = v19 >>> 14 & 0x1FFFFFFFFFFL;
            output[outputOffset + 31] = v19 >>> 55 & 0x1FFL | ((long)v20 & 0xFFFFFFFFL) << 9;
        }
    }

    private static final class Unpacker42
    implements LongBitUnpacker {
        private Unpacker42() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker42.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 42 & 0x3FFFFFL | (v1 & 0xFFFFFL) << 22;
            output[outputOffset + 2] = v1 >>> 20 & 0x3FFFFFFFFFFL;
            output[outputOffset + 3] = v1 >>> 62 & 3L | (v2 & 0xFFFFFFFFFFL) << 2;
            output[outputOffset + 4] = v2 >>> 40 & 0xFFFFFFL | (v3 & 0x3FFFFL) << 24;
            output[outputOffset + 5] = v3 >>> 18 & 0x3FFFFFFFFFFL;
            output[outputOffset + 6] = v3 >>> 60 & 0xFL | (v4 & 0x3FFFFFFFFFL) << 4;
            output[outputOffset + 7] = v4 >>> 38 & 0x3FFFFFFL | (v5 & 0xFFFFL) << 26;
            output[outputOffset + 8] = v5 >>> 16 & 0x3FFFFFFFFFFL;
            output[outputOffset + 9] = v5 >>> 58 & 0x3FL | (v6 & 0xFFFFFFFFFL) << 6;
            output[outputOffset + 10] = v6 >>> 36 & 0xFFFFFFFL | (v7 & 0x3FFFL) << 28;
            output[outputOffset + 11] = v7 >>> 14 & 0x3FFFFFFFFFFL;
            output[outputOffset + 12] = v7 >>> 56 & 0xFFL | (v8 & 0x3FFFFFFFFL) << 8;
            output[outputOffset + 13] = v8 >>> 34 & 0x3FFFFFFFL | (v9 & 0xFFFL) << 30;
            output[outputOffset + 14] = v9 >>> 12 & 0x3FFFFFFFFFFL;
            output[outputOffset + 15] = v9 >>> 54 & 0x3FFL | (v10 & 0xFFFFFFFFL) << 10;
            output[outputOffset + 16] = v10 >>> 32 & 0xFFFFFFFFL | (v11 & 0x3FFL) << 32;
            output[outputOffset + 17] = v11 >>> 10 & 0x3FFFFFFFFFFL;
            output[outputOffset + 18] = v11 >>> 52 & 0xFFFL | (v12 & 0x3FFFFFFFL) << 12;
            output[outputOffset + 19] = v12 >>> 30 & 0x3FFFFFFFFL | (v13 & 0xFFL) << 34;
            output[outputOffset + 20] = v13 >>> 8 & 0x3FFFFFFFFFFL;
            output[outputOffset + 21] = v13 >>> 50 & 0x3FFFL | (v14 & 0xFFFFFFFL) << 14;
            output[outputOffset + 22] = v14 >>> 28 & 0xFFFFFFFFFL | (v15 & 0x3FL) << 36;
            output[outputOffset + 23] = v15 >>> 6 & 0x3FFFFFFFFFFL;
            output[outputOffset + 24] = v15 >>> 48 & 0xFFFFL | (v16 & 0x3FFFFFFL) << 16;
            output[outputOffset + 25] = v16 >>> 26 & 0x3FFFFFFFFFL | (v17 & 0xFL) << 38;
            output[outputOffset + 26] = v17 >>> 4 & 0x3FFFFFFFFFFL;
            output[outputOffset + 27] = v17 >>> 46 & 0x3FFFFL | (v18 & 0xFFFFFFL) << 18;
            output[outputOffset + 28] = v18 >>> 24 & 0xFFFFFFFFFFL | (v19 & 3L) << 40;
            output[outputOffset + 29] = v19 >>> 2 & 0x3FFFFFFFFFFL;
            output[outputOffset + 30] = v19 >>> 44 & 0xFFFFFL | (v20 & 0x3FFFFFL) << 20;
            output[outputOffset + 31] = v20 >>> 22 & 0x3FFFFFFFFFFL;
        }
    }

    private static final class Unpacker43
    implements LongBitUnpacker {
        private Unpacker43() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker43.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            int v21 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 43 & 0x1FFFFFL | (v1 & 0x3FFFFFL) << 21;
            output[outputOffset + 2] = v1 >>> 22 & 0x3FFFFFFFFFFL | (v2 & 1L) << 42;
            output[outputOffset + 3] = v2 >>> 1 & 0x7FFFFFFFFFFL;
            output[outputOffset + 4] = v2 >>> 44 & 0xFFFFFL | (v3 & 0x7FFFFFL) << 20;
            output[outputOffset + 5] = v3 >>> 23 & 0x1FFFFFFFFFFL | (v4 & 3L) << 41;
            output[outputOffset + 6] = v4 >>> 2 & 0x7FFFFFFFFFFL;
            output[outputOffset + 7] = v4 >>> 45 & 0x7FFFFL | (v5 & 0xFFFFFFL) << 19;
            output[outputOffset + 8] = v5 >>> 24 & 0xFFFFFFFFFFL | (v6 & 7L) << 40;
            output[outputOffset + 9] = v6 >>> 3 & 0x7FFFFFFFFFFL;
            output[outputOffset + 10] = v6 >>> 46 & 0x3FFFFL | (v7 & 0x1FFFFFFL) << 18;
            output[outputOffset + 11] = v7 >>> 25 & 0x7FFFFFFFFFL | (v8 & 0xFL) << 39;
            output[outputOffset + 12] = v8 >>> 4 & 0x7FFFFFFFFFFL;
            output[outputOffset + 13] = v8 >>> 47 & 0x1FFFFL | (v9 & 0x3FFFFFFL) << 17;
            output[outputOffset + 14] = v9 >>> 26 & 0x3FFFFFFFFFL | (v10 & 0x1FL) << 38;
            output[outputOffset + 15] = v10 >>> 5 & 0x7FFFFFFFFFFL;
            output[outputOffset + 16] = v10 >>> 48 & 0xFFFFL | (v11 & 0x7FFFFFFL) << 16;
            output[outputOffset + 17] = v11 >>> 27 & 0x1FFFFFFFFFL | (v12 & 0x3FL) << 37;
            output[outputOffset + 18] = v12 >>> 6 & 0x7FFFFFFFFFFL;
            output[outputOffset + 19] = v12 >>> 49 & 0x7FFFL | (v13 & 0xFFFFFFFL) << 15;
            output[outputOffset + 20] = v13 >>> 28 & 0xFFFFFFFFFL | (v14 & 0x7FL) << 36;
            output[outputOffset + 21] = v14 >>> 7 & 0x7FFFFFFFFFFL;
            output[outputOffset + 22] = v14 >>> 50 & 0x3FFFL | (v15 & 0x1FFFFFFFL) << 14;
            output[outputOffset + 23] = v15 >>> 29 & 0x7FFFFFFFFL | (v16 & 0xFFL) << 35;
            output[outputOffset + 24] = v16 >>> 8 & 0x7FFFFFFFFFFL;
            output[outputOffset + 25] = v16 >>> 51 & 0x1FFFL | (v17 & 0x3FFFFFFFL) << 13;
            output[outputOffset + 26] = v17 >>> 30 & 0x3FFFFFFFFL | (v18 & 0x1FFL) << 34;
            output[outputOffset + 27] = v18 >>> 9 & 0x7FFFFFFFFFFL;
            output[outputOffset + 28] = v18 >>> 52 & 0xFFFL | (v19 & Integer.MAX_VALUE) << 12;
            output[outputOffset + 29] = v19 >>> 31 & 0x1FFFFFFFFL | (v20 & 0x3FFL) << 33;
            output[outputOffset + 30] = v20 >>> 10 & 0x7FFFFFFFFFFL;
            output[outputOffset + 31] = v20 >>> 53 & 0x7FFL | ((long)v21 & 0xFFFFFFFFL) << 11;
        }
    }

    private static final class Unpacker44
    implements LongBitUnpacker {
        private Unpacker44() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker44.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 44 & 0xFFFFFL | (v1 & 0xFFFFFFL) << 20;
            output[outputOffset + 2] = v1 >>> 24 & 0xFFFFFFFFFFL | (v2 & 0xFL) << 40;
            output[outputOffset + 3] = v2 >>> 4 & 0xFFFFFFFFFFFL;
            output[outputOffset + 4] = v2 >>> 48 & 0xFFFFL | (v3 & 0xFFFFFFFL) << 16;
            output[outputOffset + 5] = v3 >>> 28 & 0xFFFFFFFFFL | (v4 & 0xFFL) << 36;
            output[outputOffset + 6] = v4 >>> 8 & 0xFFFFFFFFFFFL;
            output[outputOffset + 7] = v4 >>> 52 & 0xFFFL | (v5 & 0xFFFFFFFFL) << 12;
            output[outputOffset + 8] = v5 >>> 32 & 0xFFFFFFFFL | (v6 & 0xFFFL) << 32;
            output[outputOffset + 9] = v6 >>> 12 & 0xFFFFFFFFFFFL;
            output[outputOffset + 10] = v6 >>> 56 & 0xFFL | (v7 & 0xFFFFFFFFFL) << 8;
            output[outputOffset + 11] = v7 >>> 36 & 0xFFFFFFFL | (v8 & 0xFFFFL) << 28;
            output[outputOffset + 12] = v8 >>> 16 & 0xFFFFFFFFFFFL;
            output[outputOffset + 13] = v8 >>> 60 & 0xFL | (v9 & 0xFFFFFFFFFFL) << 4;
            output[outputOffset + 14] = v9 >>> 40 & 0xFFFFFFL | (v10 & 0xFFFFFL) << 24;
            output[outputOffset + 15] = v10 >>> 20 & 0xFFFFFFFFFFFL;
            output[outputOffset + 16] = v11 & 0xFFFFFFFFFFFL;
            output[outputOffset + 17] = v11 >>> 44 & 0xFFFFFL | (v12 & 0xFFFFFFL) << 20;
            output[outputOffset + 18] = v12 >>> 24 & 0xFFFFFFFFFFL | (v13 & 0xFL) << 40;
            output[outputOffset + 19] = v13 >>> 4 & 0xFFFFFFFFFFFL;
            output[outputOffset + 20] = v13 >>> 48 & 0xFFFFL | (v14 & 0xFFFFFFFL) << 16;
            output[outputOffset + 21] = v14 >>> 28 & 0xFFFFFFFFFL | (v15 & 0xFFL) << 36;
            output[outputOffset + 22] = v15 >>> 8 & 0xFFFFFFFFFFFL;
            output[outputOffset + 23] = v15 >>> 52 & 0xFFFL | (v16 & 0xFFFFFFFFL) << 12;
            output[outputOffset + 24] = v16 >>> 32 & 0xFFFFFFFFL | (v17 & 0xFFFL) << 32;
            output[outputOffset + 25] = v17 >>> 12 & 0xFFFFFFFFFFFL;
            output[outputOffset + 26] = v17 >>> 56 & 0xFFL | (v18 & 0xFFFFFFFFFL) << 8;
            output[outputOffset + 27] = v18 >>> 36 & 0xFFFFFFFL | (v19 & 0xFFFFL) << 28;
            output[outputOffset + 28] = v19 >>> 16 & 0xFFFFFFFFFFFL;
            output[outputOffset + 29] = v19 >>> 60 & 0xFL | (v20 & 0xFFFFFFFFFFL) << 4;
            output[outputOffset + 30] = v20 >>> 40 & 0xFFFFFFL | (v21 & 0xFFFFFL) << 24;
            output[outputOffset + 31] = v21 >>> 20 & 0xFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker45
    implements LongBitUnpacker {
        private Unpacker45() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker45.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            int v22 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 45 & 0x7FFFFL | (v1 & 0x3FFFFFFL) << 19;
            output[outputOffset + 2] = v1 >>> 26 & 0x3FFFFFFFFFL | (v2 & 0x7FL) << 38;
            output[outputOffset + 3] = v2 >>> 7 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 4] = v2 >>> 52 & 0xFFFL | (v3 & 0x1FFFFFFFFL) << 12;
            output[outputOffset + 5] = v3 >>> 33 & Integer.MAX_VALUE | (v4 & 0x3FFFL) << 31;
            output[outputOffset + 6] = v4 >>> 14 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 7] = v4 >>> 59 & 0x1FL | (v5 & 0xFFFFFFFFFFL) << 5;
            output[outputOffset + 8] = v5 >>> 40 & 0xFFFFFFL | (v6 & 0x1FFFFFL) << 24;
            output[outputOffset + 9] = v6 >>> 21 & 0x7FFFFFFFFFFL | (v7 & 3L) << 43;
            output[outputOffset + 10] = v7 >>> 2 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 11] = v7 >>> 47 & 0x1FFFFL | (v8 & 0xFFFFFFFL) << 17;
            output[outputOffset + 12] = v8 >>> 28 & 0xFFFFFFFFFL | (v9 & 0x1FFL) << 36;
            output[outputOffset + 13] = v9 >>> 9 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 14] = v9 >>> 54 & 0x3FFL | (v10 & 0x7FFFFFFFFL) << 10;
            output[outputOffset + 15] = v10 >>> 35 & 0x1FFFFFFFL | (v11 & 0xFFFFL) << 29;
            output[outputOffset + 16] = v11 >>> 16 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 17] = v11 >>> 61 & 7L | (v12 & 0x3FFFFFFFFFFL) << 3;
            output[outputOffset + 18] = v12 >>> 42 & 0x3FFFFFL | (v13 & 0x7FFFFFL) << 22;
            output[outputOffset + 19] = v13 >>> 23 & 0x1FFFFFFFFFFL | (v14 & 0xFL) << 41;
            output[outputOffset + 20] = v14 >>> 4 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 21] = v14 >>> 49 & 0x7FFFL | (v15 & 0x3FFFFFFFL) << 15;
            output[outputOffset + 22] = v15 >>> 30 & 0x3FFFFFFFFL | (v16 & 0x7FFL) << 34;
            output[outputOffset + 23] = v16 >>> 11 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 24] = v16 >>> 56 & 0xFFL | (v17 & 0x1FFFFFFFFFL) << 8;
            output[outputOffset + 25] = v17 >>> 37 & 0x7FFFFFFL | (v18 & 0x3FFFFL) << 27;
            output[outputOffset + 26] = v18 >>> 18 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 27] = v18 >>> 63 & 1L | (v19 & 0xFFFFFFFFFFFL) << 1;
            output[outputOffset + 28] = v19 >>> 44 & 0xFFFFFL | (v20 & 0x1FFFFFFL) << 20;
            output[outputOffset + 29] = v20 >>> 25 & 0x7FFFFFFFFFL | (v21 & 0x3FL) << 39;
            output[outputOffset + 30] = v21 >>> 6 & 0x1FFFFFFFFFFFL;
            output[outputOffset + 31] = v21 >>> 51 & 0x1FFFL | ((long)v22 & 0xFFFFFFFFL) << 13;
        }
    }

    private static final class Unpacker46
    implements LongBitUnpacker {
        private Unpacker46() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker46.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 46 & 0x3FFFFL | (v1 & 0xFFFFFFFL) << 18;
            output[outputOffset + 2] = v1 >>> 28 & 0xFFFFFFFFFL | (v2 & 0x3FFL) << 36;
            output[outputOffset + 3] = v2 >>> 10 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 4] = v2 >>> 56 & 0xFFL | (v3 & 0x3FFFFFFFFFL) << 8;
            output[outputOffset + 5] = v3 >>> 38 & 0x3FFFFFFL | (v4 & 0xFFFFFL) << 26;
            output[outputOffset + 6] = v4 >>> 20 & 0xFFFFFFFFFFFL | (v5 & 3L) << 44;
            output[outputOffset + 7] = v5 >>> 2 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 8] = v5 >>> 48 & 0xFFFFL | (v6 & 0x3FFFFFFFL) << 16;
            output[outputOffset + 9] = v6 >>> 30 & 0x3FFFFFFFFL | (v7 & 0xFFFL) << 34;
            output[outputOffset + 10] = v7 >>> 12 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 11] = v7 >>> 58 & 0x3FL | (v8 & 0xFFFFFFFFFFL) << 6;
            output[outputOffset + 12] = v8 >>> 40 & 0xFFFFFFL | (v9 & 0x3FFFFFL) << 24;
            output[outputOffset + 13] = v9 >>> 22 & 0x3FFFFFFFFFFL | (v10 & 0xFL) << 42;
            output[outputOffset + 14] = v10 >>> 4 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 15] = v10 >>> 50 & 0x3FFFL | (v11 & 0xFFFFFFFFL) << 14;
            output[outputOffset + 16] = v11 >>> 32 & 0xFFFFFFFFL | (v12 & 0x3FFFL) << 32;
            output[outputOffset + 17] = v12 >>> 14 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 18] = v12 >>> 60 & 0xFL | (v13 & 0x3FFFFFFFFFFL) << 4;
            output[outputOffset + 19] = v13 >>> 42 & 0x3FFFFFL | (v14 & 0xFFFFFFL) << 22;
            output[outputOffset + 20] = v14 >>> 24 & 0xFFFFFFFFFFL | (v15 & 0x3FL) << 40;
            output[outputOffset + 21] = v15 >>> 6 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 22] = v15 >>> 52 & 0xFFFL | (v16 & 0x3FFFFFFFFL) << 12;
            output[outputOffset + 23] = v16 >>> 34 & 0x3FFFFFFFL | (v17 & 0xFFFFL) << 30;
            output[outputOffset + 24] = v17 >>> 16 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 25] = v17 >>> 62 & 3L | (v18 & 0xFFFFFFFFFFFL) << 2;
            output[outputOffset + 26] = v18 >>> 44 & 0xFFFFFL | (v19 & 0x3FFFFFFL) << 20;
            output[outputOffset + 27] = v19 >>> 26 & 0x3FFFFFFFFFL | (v20 & 0xFFL) << 38;
            output[outputOffset + 28] = v20 >>> 8 & 0x3FFFFFFFFFFFL;
            output[outputOffset + 29] = v20 >>> 54 & 0x3FFL | (v21 & 0xFFFFFFFFFL) << 10;
            output[outputOffset + 30] = v21 >>> 36 & 0xFFFFFFFL | (v22 & 0x3FFFFL) << 28;
            output[outputOffset + 31] = v22 >>> 18 & 0x3FFFFFFFFFFFL;
        }
    }

    private static final class Unpacker47
    implements LongBitUnpacker {
        private Unpacker47() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker47.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            int v23 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 47 & 0x1FFFFL | (v1 & 0x3FFFFFFFL) << 17;
            output[outputOffset + 2] = v1 >>> 30 & 0x3FFFFFFFFL | (v2 & 0x1FFFL) << 34;
            output[outputOffset + 3] = v2 >>> 13 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 4] = v2 >>> 60 & 0xFL | (v3 & 0x7FFFFFFFFFFL) << 4;
            output[outputOffset + 5] = v3 >>> 43 & 0x1FFFFFL | (v4 & 0x3FFFFFFL) << 21;
            output[outputOffset + 6] = v4 >>> 26 & 0x3FFFFFFFFFL | (v5 & 0x1FFL) << 38;
            output[outputOffset + 7] = v5 >>> 9 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 8] = v5 >>> 56 & 0xFFL | (v6 & 0x7FFFFFFFFFL) << 8;
            output[outputOffset + 9] = v6 >>> 39 & 0x1FFFFFFL | (v7 & 0x3FFFFFL) << 25;
            output[outputOffset + 10] = v7 >>> 22 & 0x3FFFFFFFFFFL | (v8 & 0x1FL) << 42;
            output[outputOffset + 11] = v8 >>> 5 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 12] = v8 >>> 52 & 0xFFFL | (v9 & 0x7FFFFFFFFL) << 12;
            output[outputOffset + 13] = v9 >>> 35 & 0x1FFFFFFFL | (v10 & 0x3FFFFL) << 29;
            output[outputOffset + 14] = v10 >>> 18 & 0x3FFFFFFFFFFFL | (v11 & 1L) << 46;
            output[outputOffset + 15] = v11 >>> 1 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 16] = v11 >>> 48 & 0xFFFFL | (v12 & Integer.MAX_VALUE) << 16;
            output[outputOffset + 17] = v12 >>> 31 & 0x1FFFFFFFFL | (v13 & 0x3FFFL) << 33;
            output[outputOffset + 18] = v13 >>> 14 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 19] = v13 >>> 61 & 7L | (v14 & 0xFFFFFFFFFFFL) << 3;
            output[outputOffset + 20] = v14 >>> 44 & 0xFFFFFL | (v15 & 0x7FFFFFFL) << 20;
            output[outputOffset + 21] = v15 >>> 27 & 0x1FFFFFFFFFL | (v16 & 0x3FFL) << 37;
            output[outputOffset + 22] = v16 >>> 10 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 23] = v16 >>> 57 & 0x7FL | (v17 & 0xFFFFFFFFFFL) << 7;
            output[outputOffset + 24] = v17 >>> 40 & 0xFFFFFFL | (v18 & 0x7FFFFFL) << 24;
            output[outputOffset + 25] = v18 >>> 23 & 0x1FFFFFFFFFFL | (v19 & 0x3FL) << 41;
            output[outputOffset + 26] = v19 >>> 6 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 27] = v19 >>> 53 & 0x7FFL | (v20 & 0xFFFFFFFFFL) << 11;
            output[outputOffset + 28] = v20 >>> 36 & 0xFFFFFFFL | (v21 & 0x7FFFFL) << 28;
            output[outputOffset + 29] = v21 >>> 19 & 0x1FFFFFFFFFFFL | (v22 & 3L) << 45;
            output[outputOffset + 30] = v22 >>> 2 & 0x7FFFFFFFFFFFL;
            output[outputOffset + 31] = v22 >>> 49 & 0x7FFFL | ((long)v23 & 0xFFFFFFFFL) << 15;
        }
    }

    private static final class Unpacker48
    implements LongBitUnpacker {
        private Unpacker48() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker48.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 48 & 0xFFFFL | (v1 & 0xFFFFFFFFL) << 16;
            output[outputOffset + 2] = v1 >>> 32 & 0xFFFFFFFFL | (v2 & 0xFFFFL) << 32;
            output[outputOffset + 3] = v2 >>> 16 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 4] = v3 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 5] = v3 >>> 48 & 0xFFFFL | (v4 & 0xFFFFFFFFL) << 16;
            output[outputOffset + 6] = v4 >>> 32 & 0xFFFFFFFFL | (v5 & 0xFFFFL) << 32;
            output[outputOffset + 7] = v5 >>> 16 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 8] = v6 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 9] = v6 >>> 48 & 0xFFFFL | (v7 & 0xFFFFFFFFL) << 16;
            output[outputOffset + 10] = v7 >>> 32 & 0xFFFFFFFFL | (v8 & 0xFFFFL) << 32;
            output[outputOffset + 11] = v8 >>> 16 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 12] = v9 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 13] = v9 >>> 48 & 0xFFFFL | (v10 & 0xFFFFFFFFL) << 16;
            output[outputOffset + 14] = v10 >>> 32 & 0xFFFFFFFFL | (v11 & 0xFFFFL) << 32;
            output[outputOffset + 15] = v11 >>> 16 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 16] = v12 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 17] = v12 >>> 48 & 0xFFFFL | (v13 & 0xFFFFFFFFL) << 16;
            output[outputOffset + 18] = v13 >>> 32 & 0xFFFFFFFFL | (v14 & 0xFFFFL) << 32;
            output[outputOffset + 19] = v14 >>> 16 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 20] = v15 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 21] = v15 >>> 48 & 0xFFFFL | (v16 & 0xFFFFFFFFL) << 16;
            output[outputOffset + 22] = v16 >>> 32 & 0xFFFFFFFFL | (v17 & 0xFFFFL) << 32;
            output[outputOffset + 23] = v17 >>> 16 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 24] = v18 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 25] = v18 >>> 48 & 0xFFFFL | (v19 & 0xFFFFFFFFL) << 16;
            output[outputOffset + 26] = v19 >>> 32 & 0xFFFFFFFFL | (v20 & 0xFFFFL) << 32;
            output[outputOffset + 27] = v20 >>> 16 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 28] = v21 & 0xFFFFFFFFFFFFL;
            output[outputOffset + 29] = v21 >>> 48 & 0xFFFFL | (v22 & 0xFFFFFFFFL) << 16;
            output[outputOffset + 30] = v22 >>> 32 & 0xFFFFFFFFL | (v23 & 0xFFFFL) << 32;
            output[outputOffset + 31] = v23 >>> 16 & 0xFFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker49
    implements LongBitUnpacker {
        private Unpacker49() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker49.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            int v24 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 49 & 0x7FFFL | (v1 & 0x3FFFFFFFFL) << 15;
            output[outputOffset + 2] = v1 >>> 34 & 0x3FFFFFFFL | (v2 & 0x7FFFFL) << 30;
            output[outputOffset + 3] = v2 >>> 19 & 0x1FFFFFFFFFFFL | (v3 & 0xFL) << 45;
            output[outputOffset + 4] = v3 >>> 4 & 0x1FFFFFFFFFFFFL;
            output[outputOffset + 5] = v3 >>> 53 & 0x7FFL | (v4 & 0x3FFFFFFFFFL) << 11;
            output[outputOffset + 6] = v4 >>> 38 & 0x3FFFFFFL | (v5 & 0x7FFFFFL) << 26;
            output[outputOffset + 7] = v5 >>> 23 & 0x1FFFFFFFFFFL | (v6 & 0xFFL) << 41;
            output[outputOffset + 8] = v6 >>> 8 & 0x1FFFFFFFFFFFFL;
            output[outputOffset + 9] = v6 >>> 57 & 0x7FL | (v7 & 0x3FFFFFFFFFFL) << 7;
            output[outputOffset + 10] = v7 >>> 42 & 0x3FFFFFL | (v8 & 0x7FFFFFFL) << 22;
            output[outputOffset + 11] = v8 >>> 27 & 0x1FFFFFFFFFL | (v9 & 0xFFFL) << 37;
            output[outputOffset + 12] = v9 >>> 12 & 0x1FFFFFFFFFFFFL;
            output[outputOffset + 13] = v9 >>> 61 & 7L | (v10 & 0x3FFFFFFFFFFFL) << 3;
            output[outputOffset + 14] = v10 >>> 46 & 0x3FFFFL | (v11 & Integer.MAX_VALUE) << 18;
            output[outputOffset + 15] = v11 >>> 31 & 0x1FFFFFFFFL | (v12 & 0xFFFFL) << 33;
            output[outputOffset + 16] = v12 >>> 16 & 0xFFFFFFFFFFFFL | (v13 & 1L) << 48;
            output[outputOffset + 17] = v13 >>> 1 & 0x1FFFFFFFFFFFFL;
            output[outputOffset + 18] = v13 >>> 50 & 0x3FFFL | (v14 & 0x7FFFFFFFFL) << 14;
            output[outputOffset + 19] = v14 >>> 35 & 0x1FFFFFFFL | (v15 & 0xFFFFFL) << 29;
            output[outputOffset + 20] = v15 >>> 20 & 0xFFFFFFFFFFFL | (v16 & 0x1FL) << 44;
            output[outputOffset + 21] = v16 >>> 5 & 0x1FFFFFFFFFFFFL;
            output[outputOffset + 22] = v16 >>> 54 & 0x3FFL | (v17 & 0x7FFFFFFFFFL) << 10;
            output[outputOffset + 23] = v17 >>> 39 & 0x1FFFFFFL | (v18 & 0xFFFFFFL) << 25;
            output[outputOffset + 24] = v18 >>> 24 & 0xFFFFFFFFFFL | (v19 & 0x1FFL) << 40;
            output[outputOffset + 25] = v19 >>> 9 & 0x1FFFFFFFFFFFFL;
            output[outputOffset + 26] = v19 >>> 58 & 0x3FL | (v20 & 0x7FFFFFFFFFFL) << 6;
            output[outputOffset + 27] = v20 >>> 43 & 0x1FFFFFL | (v21 & 0xFFFFFFFL) << 21;
            output[outputOffset + 28] = v21 >>> 28 & 0xFFFFFFFFFL | (v22 & 0x1FFFL) << 36;
            output[outputOffset + 29] = v22 >>> 13 & 0x1FFFFFFFFFFFFL;
            output[outputOffset + 30] = v22 >>> 62 & 3L | (v23 & 0x7FFFFFFFFFFFL) << 2;
            output[outputOffset + 31] = v23 >>> 47 & 0x1FFFFL | ((long)v24 & 0xFFFFFFFFL) << 17;
        }
    }

    private static final class Unpacker50
    implements LongBitUnpacker {
        private Unpacker50() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker50.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 50 & 0x3FFFL | (v1 & 0xFFFFFFFFFL) << 14;
            output[outputOffset + 2] = v1 >>> 36 & 0xFFFFFFFL | (v2 & 0x3FFFFFL) << 28;
            output[outputOffset + 3] = v2 >>> 22 & 0x3FFFFFFFFFFL | (v3 & 0xFFL) << 42;
            output[outputOffset + 4] = v3 >>> 8 & 0x3FFFFFFFFFFFFL;
            output[outputOffset + 5] = v3 >>> 58 & 0x3FL | (v4 & 0xFFFFFFFFFFFL) << 6;
            output[outputOffset + 6] = v4 >>> 44 & 0xFFFFFL | (v5 & 0x3FFFFFFFL) << 20;
            output[outputOffset + 7] = v5 >>> 30 & 0x3FFFFFFFFL | (v6 & 0xFFFFL) << 34;
            output[outputOffset + 8] = v6 >>> 16 & 0xFFFFFFFFFFFFL | (v7 & 3L) << 48;
            output[outputOffset + 9] = v7 >>> 2 & 0x3FFFFFFFFFFFFL;
            output[outputOffset + 10] = v7 >>> 52 & 0xFFFL | (v8 & 0x3FFFFFFFFFL) << 12;
            output[outputOffset + 11] = v8 >>> 38 & 0x3FFFFFFL | (v9 & 0xFFFFFFL) << 26;
            output[outputOffset + 12] = v9 >>> 24 & 0xFFFFFFFFFFL | (v10 & 0x3FFL) << 40;
            output[outputOffset + 13] = v10 >>> 10 & 0x3FFFFFFFFFFFFL;
            output[outputOffset + 14] = v10 >>> 60 & 0xFL | (v11 & 0x3FFFFFFFFFFFL) << 4;
            output[outputOffset + 15] = v11 >>> 46 & 0x3FFFFL | (v12 & 0xFFFFFFFFL) << 18;
            output[outputOffset + 16] = v12 >>> 32 & 0xFFFFFFFFL | (v13 & 0x3FFFFL) << 32;
            output[outputOffset + 17] = v13 >>> 18 & 0x3FFFFFFFFFFFL | (v14 & 0xFL) << 46;
            output[outputOffset + 18] = v14 >>> 4 & 0x3FFFFFFFFFFFFL;
            output[outputOffset + 19] = v14 >>> 54 & 0x3FFL | (v15 & 0xFFFFFFFFFFL) << 10;
            output[outputOffset + 20] = v15 >>> 40 & 0xFFFFFFL | (v16 & 0x3FFFFFFL) << 24;
            output[outputOffset + 21] = v16 >>> 26 & 0x3FFFFFFFFFL | (v17 & 0xFFFL) << 38;
            output[outputOffset + 22] = v17 >>> 12 & 0x3FFFFFFFFFFFFL;
            output[outputOffset + 23] = v17 >>> 62 & 3L | (v18 & 0xFFFFFFFFFFFFL) << 2;
            output[outputOffset + 24] = v18 >>> 48 & 0xFFFFL | (v19 & 0x3FFFFFFFFL) << 16;
            output[outputOffset + 25] = v19 >>> 34 & 0x3FFFFFFFL | (v20 & 0xFFFFFL) << 30;
            output[outputOffset + 26] = v20 >>> 20 & 0xFFFFFFFFFFFL | (v21 & 0x3FL) << 44;
            output[outputOffset + 27] = v21 >>> 6 & 0x3FFFFFFFFFFFFL;
            output[outputOffset + 28] = v21 >>> 56 & 0xFFL | (v22 & 0x3FFFFFFFFFFL) << 8;
            output[outputOffset + 29] = v22 >>> 42 & 0x3FFFFFL | (v23 & 0xFFFFFFFL) << 22;
            output[outputOffset + 30] = v23 >>> 28 & 0xFFFFFFFFFL | (v24 & 0x3FFFL) << 36;
            output[outputOffset + 31] = v24 >>> 14 & 0x3FFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker51
    implements LongBitUnpacker {
        private Unpacker51() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker51.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            int v25 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 51 & 0x1FFFL | (v1 & 0x3FFFFFFFFFL) << 13;
            output[outputOffset + 2] = v1 >>> 38 & 0x3FFFFFFL | (v2 & 0x1FFFFFFL) << 26;
            output[outputOffset + 3] = v2 >>> 25 & 0x7FFFFFFFFFL | (v3 & 0xFFFL) << 39;
            output[outputOffset + 4] = v3 >>> 12 & 0x7FFFFFFFFFFFFL;
            output[outputOffset + 5] = v3 >>> 63 & 1L | (v4 & 0x3FFFFFFFFFFFFL) << 1;
            output[outputOffset + 6] = v4 >>> 50 & 0x3FFFL | (v5 & 0x1FFFFFFFFFL) << 14;
            output[outputOffset + 7] = v5 >>> 37 & 0x7FFFFFFL | (v6 & 0xFFFFFFL) << 27;
            output[outputOffset + 8] = v6 >>> 24 & 0xFFFFFFFFFFL | (v7 & 0x7FFL) << 40;
            output[outputOffset + 9] = v7 >>> 11 & 0x7FFFFFFFFFFFFL;
            output[outputOffset + 10] = v7 >>> 62 & 3L | (v8 & 0x1FFFFFFFFFFFFL) << 2;
            output[outputOffset + 11] = v8 >>> 49 & 0x7FFFL | (v9 & 0xFFFFFFFFFL) << 15;
            output[outputOffset + 12] = v9 >>> 36 & 0xFFFFFFFL | (v10 & 0x7FFFFFL) << 28;
            output[outputOffset + 13] = v10 >>> 23 & 0x1FFFFFFFFFFL | (v11 & 0x3FFL) << 41;
            output[outputOffset + 14] = v11 >>> 10 & 0x7FFFFFFFFFFFFL;
            output[outputOffset + 15] = v11 >>> 61 & 7L | (v12 & 0xFFFFFFFFFFFFL) << 3;
            output[outputOffset + 16] = v12 >>> 48 & 0xFFFFL | (v13 & 0x7FFFFFFFFL) << 16;
            output[outputOffset + 17] = v13 >>> 35 & 0x1FFFFFFFL | (v14 & 0x3FFFFFL) << 29;
            output[outputOffset + 18] = v14 >>> 22 & 0x3FFFFFFFFFFL | (v15 & 0x1FFL) << 42;
            output[outputOffset + 19] = v15 >>> 9 & 0x7FFFFFFFFFFFFL;
            output[outputOffset + 20] = v15 >>> 60 & 0xFL | (v16 & 0x7FFFFFFFFFFFL) << 4;
            output[outputOffset + 21] = v16 >>> 47 & 0x1FFFFL | (v17 & 0x3FFFFFFFFL) << 17;
            output[outputOffset + 22] = v17 >>> 34 & 0x3FFFFFFFL | (v18 & 0x1FFFFFL) << 30;
            output[outputOffset + 23] = v18 >>> 21 & 0x7FFFFFFFFFFL | (v19 & 0xFFL) << 43;
            output[outputOffset + 24] = v19 >>> 8 & 0x7FFFFFFFFFFFFL;
            output[outputOffset + 25] = v19 >>> 59 & 0x1FL | (v20 & 0x3FFFFFFFFFFFL) << 5;
            output[outputOffset + 26] = v20 >>> 46 & 0x3FFFFL | (v21 & 0x1FFFFFFFFL) << 18;
            output[outputOffset + 27] = v21 >>> 33 & Integer.MAX_VALUE | (v22 & 0xFFFFFL) << 31;
            output[outputOffset + 28] = v22 >>> 20 & 0xFFFFFFFFFFFL | (v23 & 0x7FL) << 44;
            output[outputOffset + 29] = v23 >>> 7 & 0x7FFFFFFFFFFFFL;
            output[outputOffset + 30] = v23 >>> 58 & 0x3FL | (v24 & 0x1FFFFFFFFFFFL) << 6;
            output[outputOffset + 31] = v24 >>> 45 & 0x7FFFFL | ((long)v25 & 0xFFFFFFFFL) << 19;
        }
    }

    private static final class Unpacker52
    implements LongBitUnpacker {
        private Unpacker52() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker52.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 52 & 0xFFFL | (v1 & 0xFFFFFFFFFFL) << 12;
            output[outputOffset + 2] = v1 >>> 40 & 0xFFFFFFL | (v2 & 0xFFFFFFFL) << 24;
            output[outputOffset + 3] = v2 >>> 28 & 0xFFFFFFFFFL | (v3 & 0xFFFFL) << 36;
            output[outputOffset + 4] = v3 >>> 16 & 0xFFFFFFFFFFFFL | (v4 & 0xFL) << 48;
            output[outputOffset + 5] = v4 >>> 4 & 0xFFFFFFFFFFFFFL;
            output[outputOffset + 6] = v4 >>> 56 & 0xFFL | (v5 & 0xFFFFFFFFFFFL) << 8;
            output[outputOffset + 7] = v5 >>> 44 & 0xFFFFFL | (v6 & 0xFFFFFFFFL) << 20;
            output[outputOffset + 8] = v6 >>> 32 & 0xFFFFFFFFL | (v7 & 0xFFFFFL) << 32;
            output[outputOffset + 9] = v7 >>> 20 & 0xFFFFFFFFFFFL | (v8 & 0xFFL) << 44;
            output[outputOffset + 10] = v8 >>> 8 & 0xFFFFFFFFFFFFFL;
            output[outputOffset + 11] = v8 >>> 60 & 0xFL | (v9 & 0xFFFFFFFFFFFFL) << 4;
            output[outputOffset + 12] = v9 >>> 48 & 0xFFFFL | (v10 & 0xFFFFFFFFFL) << 16;
            output[outputOffset + 13] = v10 >>> 36 & 0xFFFFFFFL | (v11 & 0xFFFFFFL) << 28;
            output[outputOffset + 14] = v11 >>> 24 & 0xFFFFFFFFFFL | (v12 & 0xFFFL) << 40;
            output[outputOffset + 15] = v12 >>> 12 & 0xFFFFFFFFFFFFFL;
            output[outputOffset + 16] = v13 & 0xFFFFFFFFFFFFFL;
            output[outputOffset + 17] = v13 >>> 52 & 0xFFFL | (v14 & 0xFFFFFFFFFFL) << 12;
            output[outputOffset + 18] = v14 >>> 40 & 0xFFFFFFL | (v15 & 0xFFFFFFFL) << 24;
            output[outputOffset + 19] = v15 >>> 28 & 0xFFFFFFFFFL | (v16 & 0xFFFFL) << 36;
            output[outputOffset + 20] = v16 >>> 16 & 0xFFFFFFFFFFFFL | (v17 & 0xFL) << 48;
            output[outputOffset + 21] = v17 >>> 4 & 0xFFFFFFFFFFFFFL;
            output[outputOffset + 22] = v17 >>> 56 & 0xFFL | (v18 & 0xFFFFFFFFFFFL) << 8;
            output[outputOffset + 23] = v18 >>> 44 & 0xFFFFFL | (v19 & 0xFFFFFFFFL) << 20;
            output[outputOffset + 24] = v19 >>> 32 & 0xFFFFFFFFL | (v20 & 0xFFFFFL) << 32;
            output[outputOffset + 25] = v20 >>> 20 & 0xFFFFFFFFFFFL | (v21 & 0xFFL) << 44;
            output[outputOffset + 26] = v21 >>> 8 & 0xFFFFFFFFFFFFFL;
            output[outputOffset + 27] = v21 >>> 60 & 0xFL | (v22 & 0xFFFFFFFFFFFFL) << 4;
            output[outputOffset + 28] = v22 >>> 48 & 0xFFFFL | (v23 & 0xFFFFFFFFFL) << 16;
            output[outputOffset + 29] = v23 >>> 36 & 0xFFFFFFFL | (v24 & 0xFFFFFFL) << 28;
            output[outputOffset + 30] = v24 >>> 24 & 0xFFFFFFFFFFL | (v25 & 0xFFFL) << 40;
            output[outputOffset + 31] = v25 >>> 12 & 0xFFFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker53
    implements LongBitUnpacker {
        private Unpacker53() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker53.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            int v26 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 53 & 0x7FFL | (v1 & 0x3FFFFFFFFFFL) << 11;
            output[outputOffset + 2] = v1 >>> 42 & 0x3FFFFFL | (v2 & Integer.MAX_VALUE) << 22;
            output[outputOffset + 3] = v2 >>> 31 & 0x1FFFFFFFFL | (v3 & 0xFFFFFL) << 33;
            output[outputOffset + 4] = v3 >>> 20 & 0xFFFFFFFFFFFL | (v4 & 0x1FFL) << 44;
            output[outputOffset + 5] = v4 >>> 9 & 0x1FFFFFFFFFFFFFL;
            output[outputOffset + 6] = v4 >>> 62 & 3L | (v5 & 0x7FFFFFFFFFFFFL) << 2;
            output[outputOffset + 7] = v5 >>> 51 & 0x1FFFL | (v6 & 0xFFFFFFFFFFL) << 13;
            output[outputOffset + 8] = v6 >>> 40 & 0xFFFFFFL | (v7 & 0x1FFFFFFFL) << 24;
            output[outputOffset + 9] = v7 >>> 29 & 0x7FFFFFFFFL | (v8 & 0x3FFFFL) << 35;
            output[outputOffset + 10] = v8 >>> 18 & 0x3FFFFFFFFFFFL | (v9 & 0x7FL) << 46;
            output[outputOffset + 11] = v9 >>> 7 & 0x1FFFFFFFFFFFFFL;
            output[outputOffset + 12] = v9 >>> 60 & 0xFL | (v10 & 0x1FFFFFFFFFFFFL) << 4;
            output[outputOffset + 13] = v10 >>> 49 & 0x7FFFL | (v11 & 0x3FFFFFFFFFL) << 15;
            output[outputOffset + 14] = v11 >>> 38 & 0x3FFFFFFL | (v12 & 0x7FFFFFFL) << 26;
            output[outputOffset + 15] = v12 >>> 27 & 0x1FFFFFFFFFL | (v13 & 0xFFFFL) << 37;
            output[outputOffset + 16] = v13 >>> 16 & 0xFFFFFFFFFFFFL | (v14 & 0x1FL) << 48;
            output[outputOffset + 17] = v14 >>> 5 & 0x1FFFFFFFFFFFFFL;
            output[outputOffset + 18] = v14 >>> 58 & 0x3FL | (v15 & 0x7FFFFFFFFFFFL) << 6;
            output[outputOffset + 19] = v15 >>> 47 & 0x1FFFFL | (v16 & 0xFFFFFFFFFL) << 17;
            output[outputOffset + 20] = v16 >>> 36 & 0xFFFFFFFL | (v17 & 0x1FFFFFFL) << 28;
            output[outputOffset + 21] = v17 >>> 25 & 0x7FFFFFFFFFL | (v18 & 0x3FFFL) << 39;
            output[outputOffset + 22] = v18 >>> 14 & 0x3FFFFFFFFFFFFL | (v19 & 7L) << 50;
            output[outputOffset + 23] = v19 >>> 3 & 0x1FFFFFFFFFFFFFL;
            output[outputOffset + 24] = v19 >>> 56 & 0xFFL | (v20 & 0x1FFFFFFFFFFFL) << 8;
            output[outputOffset + 25] = v20 >>> 45 & 0x7FFFFL | (v21 & 0x3FFFFFFFFL) << 19;
            output[outputOffset + 26] = v21 >>> 34 & 0x3FFFFFFFL | (v22 & 0x7FFFFFL) << 30;
            output[outputOffset + 27] = v22 >>> 23 & 0x1FFFFFFFFFFL | (v23 & 0xFFFL) << 41;
            output[outputOffset + 28] = v23 >>> 12 & 0xFFFFFFFFFFFFFL | (v24 & 1L) << 52;
            output[outputOffset + 29] = v24 >>> 1 & 0x1FFFFFFFFFFFFFL;
            output[outputOffset + 30] = v24 >>> 54 & 0x3FFL | (v25 & 0x7FFFFFFFFFFL) << 10;
            output[outputOffset + 31] = v25 >>> 43 & 0x1FFFFFL | ((long)v26 & 0xFFFFFFFFL) << 21;
        }
    }

    private static final class Unpacker54
    implements LongBitUnpacker {
        private Unpacker54() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker54.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 54 & 0x3FFL | (v1 & 0xFFFFFFFFFFFL) << 10;
            output[outputOffset + 2] = v1 >>> 44 & 0xFFFFFL | (v2 & 0x3FFFFFFFFL) << 20;
            output[outputOffset + 3] = v2 >>> 34 & 0x3FFFFFFFL | (v3 & 0xFFFFFFL) << 30;
            output[outputOffset + 4] = v3 >>> 24 & 0xFFFFFFFFFFL | (v4 & 0x3FFFL) << 40;
            output[outputOffset + 5] = v4 >>> 14 & 0x3FFFFFFFFFFFFL | (v5 & 0xFL) << 50;
            output[outputOffset + 6] = v5 >>> 4 & 0x3FFFFFFFFFFFFFL;
            output[outputOffset + 7] = v5 >>> 58 & 0x3FL | (v6 & 0xFFFFFFFFFFFFL) << 6;
            output[outputOffset + 8] = v6 >>> 48 & 0xFFFFL | (v7 & 0x3FFFFFFFFFL) << 16;
            output[outputOffset + 9] = v7 >>> 38 & 0x3FFFFFFL | (v8 & 0xFFFFFFFL) << 26;
            output[outputOffset + 10] = v8 >>> 28 & 0xFFFFFFFFFL | (v9 & 0x3FFFFL) << 36;
            output[outputOffset + 11] = v9 >>> 18 & 0x3FFFFFFFFFFFL | (v10 & 0xFFL) << 46;
            output[outputOffset + 12] = v10 >>> 8 & 0x3FFFFFFFFFFFFFL;
            output[outputOffset + 13] = v10 >>> 62 & 3L | (v11 & 0xFFFFFFFFFFFFFL) << 2;
            output[outputOffset + 14] = v11 >>> 52 & 0xFFFL | (v12 & 0x3FFFFFFFFFFL) << 12;
            output[outputOffset + 15] = v12 >>> 42 & 0x3FFFFFL | (v13 & 0xFFFFFFFFL) << 22;
            output[outputOffset + 16] = v13 >>> 32 & 0xFFFFFFFFL | (v14 & 0x3FFFFFL) << 32;
            output[outputOffset + 17] = v14 >>> 22 & 0x3FFFFFFFFFFL | (v15 & 0xFFFL) << 42;
            output[outputOffset + 18] = v15 >>> 12 & 0xFFFFFFFFFFFFFL | (v16 & 3L) << 52;
            output[outputOffset + 19] = v16 >>> 2 & 0x3FFFFFFFFFFFFFL;
            output[outputOffset + 20] = v16 >>> 56 & 0xFFL | (v17 & 0x3FFFFFFFFFFFL) << 8;
            output[outputOffset + 21] = v17 >>> 46 & 0x3FFFFL | (v18 & 0xFFFFFFFFFL) << 18;
            output[outputOffset + 22] = v18 >>> 36 & 0xFFFFFFFL | (v19 & 0x3FFFFFFL) << 28;
            output[outputOffset + 23] = v19 >>> 26 & 0x3FFFFFFFFFL | (v20 & 0xFFFFL) << 38;
            output[outputOffset + 24] = v20 >>> 16 & 0xFFFFFFFFFFFFL | (v21 & 0x3FL) << 48;
            output[outputOffset + 25] = v21 >>> 6 & 0x3FFFFFFFFFFFFFL;
            output[outputOffset + 26] = v21 >>> 60 & 0xFL | (v22 & 0x3FFFFFFFFFFFFL) << 4;
            output[outputOffset + 27] = v22 >>> 50 & 0x3FFFL | (v23 & 0xFFFFFFFFFFL) << 14;
            output[outputOffset + 28] = v23 >>> 40 & 0xFFFFFFL | (v24 & 0x3FFFFFFFL) << 24;
            output[outputOffset + 29] = v24 >>> 30 & 0x3FFFFFFFFL | (v25 & 0xFFFFFL) << 34;
            output[outputOffset + 30] = v25 >>> 20 & 0xFFFFFFFFFFFL | (v26 & 0x3FFL) << 44;
            output[outputOffset + 31] = v26 >>> 10 & 0x3FFFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker55
    implements LongBitUnpacker {
        private Unpacker55() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker55.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            int v27 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 55 & 0x1FFL | (v1 & 0x3FFFFFFFFFFFL) << 9;
            output[outputOffset + 2] = v1 >>> 46 & 0x3FFFFL | (v2 & 0x1FFFFFFFFFL) << 18;
            output[outputOffset + 3] = v2 >>> 37 & 0x7FFFFFFL | (v3 & 0xFFFFFFFL) << 27;
            output[outputOffset + 4] = v3 >>> 28 & 0xFFFFFFFFFL | (v4 & 0x7FFFFL) << 36;
            output[outputOffset + 5] = v4 >>> 19 & 0x1FFFFFFFFFFFL | (v5 & 0x3FFL) << 45;
            output[outputOffset + 6] = v5 >>> 10 & 0x3FFFFFFFFFFFFFL | (v6 & 1L) << 54;
            output[outputOffset + 7] = v6 >>> 1 & 0x7FFFFFFFFFFFFFL;
            output[outputOffset + 8] = v6 >>> 56 & 0xFFL | (v7 & 0x7FFFFFFFFFFFL) << 8;
            output[outputOffset + 9] = v7 >>> 47 & 0x1FFFFL | (v8 & 0x3FFFFFFFFFL) << 17;
            output[outputOffset + 10] = v8 >>> 38 & 0x3FFFFFFL | (v9 & 0x1FFFFFFFL) << 26;
            output[outputOffset + 11] = v9 >>> 29 & 0x7FFFFFFFFL | (v10 & 0xFFFFFL) << 35;
            output[outputOffset + 12] = v10 >>> 20 & 0xFFFFFFFFFFFL | (v11 & 0x7FFL) << 44;
            output[outputOffset + 13] = v11 >>> 11 & 0x1FFFFFFFFFFFFFL | (v12 & 3L) << 53;
            output[outputOffset + 14] = v12 >>> 2 & 0x7FFFFFFFFFFFFFL;
            output[outputOffset + 15] = v12 >>> 57 & 0x7FL | (v13 & 0xFFFFFFFFFFFFL) << 7;
            output[outputOffset + 16] = v13 >>> 48 & 0xFFFFL | (v14 & 0x7FFFFFFFFFL) << 16;
            output[outputOffset + 17] = v14 >>> 39 & 0x1FFFFFFL | (v15 & 0x3FFFFFFFL) << 25;
            output[outputOffset + 18] = v15 >>> 30 & 0x3FFFFFFFFL | (v16 & 0x1FFFFFL) << 34;
            output[outputOffset + 19] = v16 >>> 21 & 0x7FFFFFFFFFFL | (v17 & 0xFFFL) << 43;
            output[outputOffset + 20] = v17 >>> 12 & 0xFFFFFFFFFFFFFL | (v18 & 7L) << 52;
            output[outputOffset + 21] = v18 >>> 3 & 0x7FFFFFFFFFFFFFL;
            output[outputOffset + 22] = v18 >>> 58 & 0x3FL | (v19 & 0x1FFFFFFFFFFFFL) << 6;
            output[outputOffset + 23] = v19 >>> 49 & 0x7FFFL | (v20 & 0xFFFFFFFFFFL) << 15;
            output[outputOffset + 24] = v20 >>> 40 & 0xFFFFFFL | (v21 & Integer.MAX_VALUE) << 24;
            output[outputOffset + 25] = v21 >>> 31 & 0x1FFFFFFFFL | (v22 & 0x3FFFFFL) << 33;
            output[outputOffset + 26] = v22 >>> 22 & 0x3FFFFFFFFFFL | (v23 & 0x1FFFL) << 42;
            output[outputOffset + 27] = v23 >>> 13 & 0x7FFFFFFFFFFFFL | (v24 & 0xFL) << 51;
            output[outputOffset + 28] = v24 >>> 4 & 0x7FFFFFFFFFFFFFL;
            output[outputOffset + 29] = v24 >>> 59 & 0x1FL | (v25 & 0x3FFFFFFFFFFFFL) << 5;
            output[outputOffset + 30] = v25 >>> 50 & 0x3FFFL | (v26 & 0x1FFFFFFFFFFL) << 14;
            output[outputOffset + 31] = v26 >>> 41 & 0x7FFFFFL | ((long)v27 & 0xFFFFFFFFL) << 23;
        }
    }

    private static final class Unpacker56
    implements LongBitUnpacker {
        private Unpacker56() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker56.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            long v27 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 56 & 0xFFL | (v1 & 0xFFFFFFFFFFFFL) << 8;
            output[outputOffset + 2] = v1 >>> 48 & 0xFFFFL | (v2 & 0xFFFFFFFFFFL) << 16;
            output[outputOffset + 3] = v2 >>> 40 & 0xFFFFFFL | (v3 & 0xFFFFFFFFL) << 24;
            output[outputOffset + 4] = v3 >>> 32 & 0xFFFFFFFFL | (v4 & 0xFFFFFFL) << 32;
            output[outputOffset + 5] = v4 >>> 24 & 0xFFFFFFFFFFL | (v5 & 0xFFFFL) << 40;
            output[outputOffset + 6] = v5 >>> 16 & 0xFFFFFFFFFFFFL | (v6 & 0xFFL) << 48;
            output[outputOffset + 7] = v6 >>> 8 & 0xFFFFFFFFFFFFFFL;
            output[outputOffset + 8] = v7 & 0xFFFFFFFFFFFFFFL;
            output[outputOffset + 9] = v7 >>> 56 & 0xFFL | (v8 & 0xFFFFFFFFFFFFL) << 8;
            output[outputOffset + 10] = v8 >>> 48 & 0xFFFFL | (v9 & 0xFFFFFFFFFFL) << 16;
            output[outputOffset + 11] = v9 >>> 40 & 0xFFFFFFL | (v10 & 0xFFFFFFFFL) << 24;
            output[outputOffset + 12] = v10 >>> 32 & 0xFFFFFFFFL | (v11 & 0xFFFFFFL) << 32;
            output[outputOffset + 13] = v11 >>> 24 & 0xFFFFFFFFFFL | (v12 & 0xFFFFL) << 40;
            output[outputOffset + 14] = v12 >>> 16 & 0xFFFFFFFFFFFFL | (v13 & 0xFFL) << 48;
            output[outputOffset + 15] = v13 >>> 8 & 0xFFFFFFFFFFFFFFL;
            output[outputOffset + 16] = v14 & 0xFFFFFFFFFFFFFFL;
            output[outputOffset + 17] = v14 >>> 56 & 0xFFL | (v15 & 0xFFFFFFFFFFFFL) << 8;
            output[outputOffset + 18] = v15 >>> 48 & 0xFFFFL | (v16 & 0xFFFFFFFFFFL) << 16;
            output[outputOffset + 19] = v16 >>> 40 & 0xFFFFFFL | (v17 & 0xFFFFFFFFL) << 24;
            output[outputOffset + 20] = v17 >>> 32 & 0xFFFFFFFFL | (v18 & 0xFFFFFFL) << 32;
            output[outputOffset + 21] = v18 >>> 24 & 0xFFFFFFFFFFL | (v19 & 0xFFFFL) << 40;
            output[outputOffset + 22] = v19 >>> 16 & 0xFFFFFFFFFFFFL | (v20 & 0xFFL) << 48;
            output[outputOffset + 23] = v20 >>> 8 & 0xFFFFFFFFFFFFFFL;
            output[outputOffset + 24] = v21 & 0xFFFFFFFFFFFFFFL;
            output[outputOffset + 25] = v21 >>> 56 & 0xFFL | (v22 & 0xFFFFFFFFFFFFL) << 8;
            output[outputOffset + 26] = v22 >>> 48 & 0xFFFFL | (v23 & 0xFFFFFFFFFFL) << 16;
            output[outputOffset + 27] = v23 >>> 40 & 0xFFFFFFL | (v24 & 0xFFFFFFFFL) << 24;
            output[outputOffset + 28] = v24 >>> 32 & 0xFFFFFFFFL | (v25 & 0xFFFFFFL) << 32;
            output[outputOffset + 29] = v25 >>> 24 & 0xFFFFFFFFFFL | (v26 & 0xFFFFL) << 40;
            output[outputOffset + 30] = v26 >>> 16 & 0xFFFFFFFFFFFFL | (v27 & 0xFFL) << 48;
            output[outputOffset + 31] = v27 >>> 8 & 0xFFFFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker57
    implements LongBitUnpacker {
        private Unpacker57() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker57.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            long v27 = input.readLong();
            int v28 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 57 & 0x7FL | (v1 & 0x3FFFFFFFFFFFFL) << 7;
            output[outputOffset + 2] = v1 >>> 50 & 0x3FFFL | (v2 & 0x7FFFFFFFFFFL) << 14;
            output[outputOffset + 3] = v2 >>> 43 & 0x1FFFFFL | (v3 & 0xFFFFFFFFFL) << 21;
            output[outputOffset + 4] = v3 >>> 36 & 0xFFFFFFFL | (v4 & 0x1FFFFFFFL) << 28;
            output[outputOffset + 5] = v4 >>> 29 & 0x7FFFFFFFFL | (v5 & 0x3FFFFFL) << 35;
            output[outputOffset + 6] = v5 >>> 22 & 0x3FFFFFFFFFFL | (v6 & 0x7FFFL) << 42;
            output[outputOffset + 7] = v6 >>> 15 & 0x1FFFFFFFFFFFFL | (v7 & 0xFFL) << 49;
            output[outputOffset + 8] = v7 >>> 8 & 0xFFFFFFFFFFFFFFL | (v8 & 1L) << 56;
            output[outputOffset + 9] = v8 >>> 1 & 0x1FFFFFFFFFFFFFFL;
            output[outputOffset + 10] = v8 >>> 58 & 0x3FL | (v9 & 0x7FFFFFFFFFFFFL) << 6;
            output[outputOffset + 11] = v9 >>> 51 & 0x1FFFL | (v10 & 0xFFFFFFFFFFFL) << 13;
            output[outputOffset + 12] = v10 >>> 44 & 0xFFFFFL | (v11 & 0x1FFFFFFFFFL) << 20;
            output[outputOffset + 13] = v11 >>> 37 & 0x7FFFFFFL | (v12 & 0x3FFFFFFFL) << 27;
            output[outputOffset + 14] = v12 >>> 30 & 0x3FFFFFFFFL | (v13 & 0x7FFFFFL) << 34;
            output[outputOffset + 15] = v13 >>> 23 & 0x1FFFFFFFFFFL | (v14 & 0xFFFFL) << 41;
            output[outputOffset + 16] = v14 >>> 16 & 0xFFFFFFFFFFFFL | (v15 & 0x1FFL) << 48;
            output[outputOffset + 17] = v15 >>> 9 & 0x7FFFFFFFFFFFFFL | (v16 & 3L) << 55;
            output[outputOffset + 18] = v16 >>> 2 & 0x1FFFFFFFFFFFFFFL;
            output[outputOffset + 19] = v16 >>> 59 & 0x1FL | (v17 & 0xFFFFFFFFFFFFFL) << 5;
            output[outputOffset + 20] = v17 >>> 52 & 0xFFFL | (v18 & 0x1FFFFFFFFFFFL) << 12;
            output[outputOffset + 21] = v18 >>> 45 & 0x7FFFFL | (v19 & 0x3FFFFFFFFFL) << 19;
            output[outputOffset + 22] = v19 >>> 38 & 0x3FFFFFFL | (v20 & Integer.MAX_VALUE) << 26;
            output[outputOffset + 23] = v20 >>> 31 & 0x1FFFFFFFFL | (v21 & 0xFFFFFFL) << 33;
            output[outputOffset + 24] = v21 >>> 24 & 0xFFFFFFFFFFL | (v22 & 0x1FFFFL) << 40;
            output[outputOffset + 25] = v22 >>> 17 & 0x7FFFFFFFFFFFL | (v23 & 0x3FFL) << 47;
            output[outputOffset + 26] = v23 >>> 10 & 0x3FFFFFFFFFFFFFL | (v24 & 7L) << 54;
            output[outputOffset + 27] = v24 >>> 3 & 0x1FFFFFFFFFFFFFFL;
            output[outputOffset + 28] = v24 >>> 60 & 0xFL | (v25 & 0x1FFFFFFFFFFFFFL) << 4;
            output[outputOffset + 29] = v25 >>> 53 & 0x7FFL | (v26 & 0x3FFFFFFFFFFFL) << 11;
            output[outputOffset + 30] = v26 >>> 46 & 0x3FFFFL | (v27 & 0x7FFFFFFFFFL) << 18;
            output[outputOffset + 31] = v27 >>> 39 & 0x1FFFFFFL | ((long)v28 & 0xFFFFFFFFL) << 25;
        }
    }

    private static final class Unpacker58
    implements LongBitUnpacker {
        private Unpacker58() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker58.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            long v27 = input.readLong();
            long v28 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 58 & 0x3FL | (v1 & 0xFFFFFFFFFFFFFL) << 6;
            output[outputOffset + 2] = v1 >>> 52 & 0xFFFL | (v2 & 0x3FFFFFFFFFFFL) << 12;
            output[outputOffset + 3] = v2 >>> 46 & 0x3FFFFL | (v3 & 0xFFFFFFFFFFL) << 18;
            output[outputOffset + 4] = v3 >>> 40 & 0xFFFFFFL | (v4 & 0x3FFFFFFFFL) << 24;
            output[outputOffset + 5] = v4 >>> 34 & 0x3FFFFFFFL | (v5 & 0xFFFFFFFL) << 30;
            output[outputOffset + 6] = v5 >>> 28 & 0xFFFFFFFFFL | (v6 & 0x3FFFFFL) << 36;
            output[outputOffset + 7] = v6 >>> 22 & 0x3FFFFFFFFFFL | (v7 & 0xFFFFL) << 42;
            output[outputOffset + 8] = v7 >>> 16 & 0xFFFFFFFFFFFFL | (v8 & 0x3FFL) << 48;
            output[outputOffset + 9] = v8 >>> 10 & 0x3FFFFFFFFFFFFFL | (v9 & 0xFL) << 54;
            output[outputOffset + 10] = v9 >>> 4 & 0x3FFFFFFFFFFFFFFL;
            output[outputOffset + 11] = v9 >>> 62 & 3L | (v10 & 0xFFFFFFFFFFFFFFL) << 2;
            output[outputOffset + 12] = v10 >>> 56 & 0xFFL | (v11 & 0x3FFFFFFFFFFFFL) << 8;
            output[outputOffset + 13] = v11 >>> 50 & 0x3FFFL | (v12 & 0xFFFFFFFFFFFL) << 14;
            output[outputOffset + 14] = v12 >>> 44 & 0xFFFFFL | (v13 & 0x3FFFFFFFFFL) << 20;
            output[outputOffset + 15] = v13 >>> 38 & 0x3FFFFFFL | (v14 & 0xFFFFFFFFL) << 26;
            output[outputOffset + 16] = v14 >>> 32 & 0xFFFFFFFFL | (v15 & 0x3FFFFFFL) << 32;
            output[outputOffset + 17] = v15 >>> 26 & 0x3FFFFFFFFFL | (v16 & 0xFFFFFL) << 38;
            output[outputOffset + 18] = v16 >>> 20 & 0xFFFFFFFFFFFL | (v17 & 0x3FFFL) << 44;
            output[outputOffset + 19] = v17 >>> 14 & 0x3FFFFFFFFFFFFL | (v18 & 0xFFL) << 50;
            output[outputOffset + 20] = v18 >>> 8 & 0xFFFFFFFFFFFFFFL | (v19 & 3L) << 56;
            output[outputOffset + 21] = v19 >>> 2 & 0x3FFFFFFFFFFFFFFL;
            output[outputOffset + 22] = v19 >>> 60 & 0xFL | (v20 & 0x3FFFFFFFFFFFFFL) << 4;
            output[outputOffset + 23] = v20 >>> 54 & 0x3FFL | (v21 & 0xFFFFFFFFFFFFL) << 10;
            output[outputOffset + 24] = v21 >>> 48 & 0xFFFFL | (v22 & 0x3FFFFFFFFFFL) << 16;
            output[outputOffset + 25] = v22 >>> 42 & 0x3FFFFFL | (v23 & 0xFFFFFFFFFL) << 22;
            output[outputOffset + 26] = v23 >>> 36 & 0xFFFFFFFL | (v24 & 0x3FFFFFFFL) << 28;
            output[outputOffset + 27] = v24 >>> 30 & 0x3FFFFFFFFL | (v25 & 0xFFFFFFL) << 34;
            output[outputOffset + 28] = v25 >>> 24 & 0xFFFFFFFFFFL | (v26 & 0x3FFFFL) << 40;
            output[outputOffset + 29] = v26 >>> 18 & 0x3FFFFFFFFFFFL | (v27 & 0xFFFL) << 46;
            output[outputOffset + 30] = v27 >>> 12 & 0xFFFFFFFFFFFFFL | (v28 & 0x3FL) << 52;
            output[outputOffset + 31] = v28 >>> 6 & 0x3FFFFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker59
    implements LongBitUnpacker {
        private Unpacker59() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker59.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            long v27 = input.readLong();
            long v28 = input.readLong();
            int v29 = input.readInt();
            output[outputOffset] = v0 & 0x7FFFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 59 & 0x1FL | (v1 & 0x3FFFFFFFFFFFFFL) << 5;
            output[outputOffset + 2] = v1 >>> 54 & 0x3FFL | (v2 & 0x1FFFFFFFFFFFFL) << 10;
            output[outputOffset + 3] = v2 >>> 49 & 0x7FFFL | (v3 & 0xFFFFFFFFFFFL) << 15;
            output[outputOffset + 4] = v3 >>> 44 & 0xFFFFFL | (v4 & 0x7FFFFFFFFFL) << 20;
            output[outputOffset + 5] = v4 >>> 39 & 0x1FFFFFFL | (v5 & 0x3FFFFFFFFL) << 25;
            output[outputOffset + 6] = v5 >>> 34 & 0x3FFFFFFFL | (v6 & 0x1FFFFFFFL) << 30;
            output[outputOffset + 7] = v6 >>> 29 & 0x7FFFFFFFFL | (v7 & 0xFFFFFFL) << 35;
            output[outputOffset + 8] = v7 >>> 24 & 0xFFFFFFFFFFL | (v8 & 0x7FFFFL) << 40;
            output[outputOffset + 9] = v8 >>> 19 & 0x1FFFFFFFFFFFL | (v9 & 0x3FFFL) << 45;
            output[outputOffset + 10] = v9 >>> 14 & 0x3FFFFFFFFFFFFL | (v10 & 0x1FFL) << 50;
            output[outputOffset + 11] = v10 >>> 9 & 0x7FFFFFFFFFFFFFL | (v11 & 0xFL) << 55;
            output[outputOffset + 12] = v11 >>> 4 & 0x7FFFFFFFFFFFFFFL;
            output[outputOffset + 13] = v11 >>> 63 & 1L | (v12 & 0x3FFFFFFFFFFFFFFL) << 1;
            output[outputOffset + 14] = v12 >>> 58 & 0x3FL | (v13 & 0x1FFFFFFFFFFFFFL) << 6;
            output[outputOffset + 15] = v13 >>> 53 & 0x7FFL | (v14 & 0xFFFFFFFFFFFFL) << 11;
            output[outputOffset + 16] = v14 >>> 48 & 0xFFFFL | (v15 & 0x7FFFFFFFFFFL) << 16;
            output[outputOffset + 17] = v15 >>> 43 & 0x1FFFFFL | (v16 & 0x3FFFFFFFFFL) << 21;
            output[outputOffset + 18] = v16 >>> 38 & 0x3FFFFFFL | (v17 & 0x1FFFFFFFFL) << 26;
            output[outputOffset + 19] = v17 >>> 33 & Integer.MAX_VALUE | (v18 & 0xFFFFFFFL) << 31;
            output[outputOffset + 20] = v18 >>> 28 & 0xFFFFFFFFFL | (v19 & 0x7FFFFFL) << 36;
            output[outputOffset + 21] = v19 >>> 23 & 0x1FFFFFFFFFFL | (v20 & 0x3FFFFL) << 41;
            output[outputOffset + 22] = v20 >>> 18 & 0x3FFFFFFFFFFFL | (v21 & 0x1FFFL) << 46;
            output[outputOffset + 23] = v21 >>> 13 & 0x7FFFFFFFFFFFFL | (v22 & 0xFFL) << 51;
            output[outputOffset + 24] = v22 >>> 8 & 0xFFFFFFFFFFFFFFL | (v23 & 7L) << 56;
            output[outputOffset + 25] = v23 >>> 3 & 0x7FFFFFFFFFFFFFFL;
            output[outputOffset + 26] = v23 >>> 62 & 3L | (v24 & 0x1FFFFFFFFFFFFFFL) << 2;
            output[outputOffset + 27] = v24 >>> 57 & 0x7FL | (v25 & 0xFFFFFFFFFFFFFL) << 7;
            output[outputOffset + 28] = v25 >>> 52 & 0xFFFL | (v26 & 0x7FFFFFFFFFFFL) << 12;
            output[outputOffset + 29] = v26 >>> 47 & 0x1FFFFL | (v27 & 0x3FFFFFFFFFFL) << 17;
            output[outputOffset + 30] = v27 >>> 42 & 0x3FFFFFL | (v28 & 0x1FFFFFFFFFL) << 22;
            output[outputOffset + 31] = v28 >>> 37 & 0x7FFFFFFL | ((long)v29 & 0xFFFFFFFFL) << 27;
        }
    }

    private static final class Unpacker60
    implements LongBitUnpacker {
        private Unpacker60() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker60.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            long v27 = input.readLong();
            long v28 = input.readLong();
            long v29 = input.readLong();
            output[outputOffset] = v0 & 0xFFFFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 60 & 0xFL | (v1 & 0xFFFFFFFFFFFFFFL) << 4;
            output[outputOffset + 2] = v1 >>> 56 & 0xFFL | (v2 & 0xFFFFFFFFFFFFFL) << 8;
            output[outputOffset + 3] = v2 >>> 52 & 0xFFFL | (v3 & 0xFFFFFFFFFFFFL) << 12;
            output[outputOffset + 4] = v3 >>> 48 & 0xFFFFL | (v4 & 0xFFFFFFFFFFFL) << 16;
            output[outputOffset + 5] = v4 >>> 44 & 0xFFFFFL | (v5 & 0xFFFFFFFFFFL) << 20;
            output[outputOffset + 6] = v5 >>> 40 & 0xFFFFFFL | (v6 & 0xFFFFFFFFFL) << 24;
            output[outputOffset + 7] = v6 >>> 36 & 0xFFFFFFFL | (v7 & 0xFFFFFFFFL) << 28;
            output[outputOffset + 8] = v7 >>> 32 & 0xFFFFFFFFL | (v8 & 0xFFFFFFFL) << 32;
            output[outputOffset + 9] = v8 >>> 28 & 0xFFFFFFFFFL | (v9 & 0xFFFFFFL) << 36;
            output[outputOffset + 10] = v9 >>> 24 & 0xFFFFFFFFFFL | (v10 & 0xFFFFFL) << 40;
            output[outputOffset + 11] = v10 >>> 20 & 0xFFFFFFFFFFFL | (v11 & 0xFFFFL) << 44;
            output[outputOffset + 12] = v11 >>> 16 & 0xFFFFFFFFFFFFL | (v12 & 0xFFFL) << 48;
            output[outputOffset + 13] = v12 >>> 12 & 0xFFFFFFFFFFFFFL | (v13 & 0xFFL) << 52;
            output[outputOffset + 14] = v13 >>> 8 & 0xFFFFFFFFFFFFFFL | (v14 & 0xFL) << 56;
            output[outputOffset + 15] = v14 >>> 4 & 0xFFFFFFFFFFFFFFFL;
            output[outputOffset + 16] = v15 & 0xFFFFFFFFFFFFFFFL;
            output[outputOffset + 17] = v15 >>> 60 & 0xFL | (v16 & 0xFFFFFFFFFFFFFFL) << 4;
            output[outputOffset + 18] = v16 >>> 56 & 0xFFL | (v17 & 0xFFFFFFFFFFFFFL) << 8;
            output[outputOffset + 19] = v17 >>> 52 & 0xFFFL | (v18 & 0xFFFFFFFFFFFFL) << 12;
            output[outputOffset + 20] = v18 >>> 48 & 0xFFFFL | (v19 & 0xFFFFFFFFFFFL) << 16;
            output[outputOffset + 21] = v19 >>> 44 & 0xFFFFFL | (v20 & 0xFFFFFFFFFFL) << 20;
            output[outputOffset + 22] = v20 >>> 40 & 0xFFFFFFL | (v21 & 0xFFFFFFFFFL) << 24;
            output[outputOffset + 23] = v21 >>> 36 & 0xFFFFFFFL | (v22 & 0xFFFFFFFFL) << 28;
            output[outputOffset + 24] = v22 >>> 32 & 0xFFFFFFFFL | (v23 & 0xFFFFFFFL) << 32;
            output[outputOffset + 25] = v23 >>> 28 & 0xFFFFFFFFFL | (v24 & 0xFFFFFFL) << 36;
            output[outputOffset + 26] = v24 >>> 24 & 0xFFFFFFFFFFL | (v25 & 0xFFFFFL) << 40;
            output[outputOffset + 27] = v25 >>> 20 & 0xFFFFFFFFFFFL | (v26 & 0xFFFFL) << 44;
            output[outputOffset + 28] = v26 >>> 16 & 0xFFFFFFFFFFFFL | (v27 & 0xFFFL) << 48;
            output[outputOffset + 29] = v27 >>> 12 & 0xFFFFFFFFFFFFFL | (v28 & 0xFFL) << 52;
            output[outputOffset + 30] = v28 >>> 8 & 0xFFFFFFFFFFFFFFL | (v29 & 0xFL) << 56;
            output[outputOffset + 31] = v29 >>> 4 & 0xFFFFFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker61
    implements LongBitUnpacker {
        private Unpacker61() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker61.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            long v27 = input.readLong();
            long v28 = input.readLong();
            long v29 = input.readLong();
            int v30 = input.readInt();
            output[outputOffset] = v0 & 0x1FFFFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 61 & 7L | (v1 & 0x3FFFFFFFFFFFFFFL) << 3;
            output[outputOffset + 2] = v1 >>> 58 & 0x3FL | (v2 & 0x7FFFFFFFFFFFFFL) << 6;
            output[outputOffset + 3] = v2 >>> 55 & 0x1FFL | (v3 & 0xFFFFFFFFFFFFFL) << 9;
            output[outputOffset + 4] = v3 >>> 52 & 0xFFFL | (v4 & 0x1FFFFFFFFFFFFL) << 12;
            output[outputOffset + 5] = v4 >>> 49 & 0x7FFFL | (v5 & 0x3FFFFFFFFFFFL) << 15;
            output[outputOffset + 6] = v5 >>> 46 & 0x3FFFFL | (v6 & 0x7FFFFFFFFFFL) << 18;
            output[outputOffset + 7] = v6 >>> 43 & 0x1FFFFFL | (v7 & 0xFFFFFFFFFFL) << 21;
            output[outputOffset + 8] = v7 >>> 40 & 0xFFFFFFL | (v8 & 0x1FFFFFFFFFL) << 24;
            output[outputOffset + 9] = v8 >>> 37 & 0x7FFFFFFL | (v9 & 0x3FFFFFFFFL) << 27;
            output[outputOffset + 10] = v9 >>> 34 & 0x3FFFFFFFL | (v10 & Integer.MAX_VALUE) << 30;
            output[outputOffset + 11] = v10 >>> 31 & 0x1FFFFFFFFL | (v11 & 0xFFFFFFFL) << 33;
            output[outputOffset + 12] = v11 >>> 28 & 0xFFFFFFFFFL | (v12 & 0x1FFFFFFL) << 36;
            output[outputOffset + 13] = v12 >>> 25 & 0x7FFFFFFFFFL | (v13 & 0x3FFFFFL) << 39;
            output[outputOffset + 14] = v13 >>> 22 & 0x3FFFFFFFFFFL | (v14 & 0x7FFFFL) << 42;
            output[outputOffset + 15] = v14 >>> 19 & 0x1FFFFFFFFFFFL | (v15 & 0xFFFFL) << 45;
            output[outputOffset + 16] = v15 >>> 16 & 0xFFFFFFFFFFFFL | (v16 & 0x1FFFL) << 48;
            output[outputOffset + 17] = v16 >>> 13 & 0x7FFFFFFFFFFFFL | (v17 & 0x3FFL) << 51;
            output[outputOffset + 18] = v17 >>> 10 & 0x3FFFFFFFFFFFFFL | (v18 & 0x7FL) << 54;
            output[outputOffset + 19] = v18 >>> 7 & 0x1FFFFFFFFFFFFFFL | (v19 & 0xFL) << 57;
            output[outputOffset + 20] = v19 >>> 4 & 0xFFFFFFFFFFFFFFFL | (v20 & 1L) << 60;
            output[outputOffset + 21] = v20 >>> 1 & 0x1FFFFFFFFFFFFFFFL;
            output[outputOffset + 22] = v20 >>> 62 & 3L | (v21 & 0x7FFFFFFFFFFFFFFL) << 2;
            output[outputOffset + 23] = v21 >>> 59 & 0x1FL | (v22 & 0xFFFFFFFFFFFFFFL) << 5;
            output[outputOffset + 24] = v22 >>> 56 & 0xFFL | (v23 & 0x1FFFFFFFFFFFFFL) << 8;
            output[outputOffset + 25] = v23 >>> 53 & 0x7FFL | (v24 & 0x3FFFFFFFFFFFFL) << 11;
            output[outputOffset + 26] = v24 >>> 50 & 0x3FFFL | (v25 & 0x7FFFFFFFFFFFL) << 14;
            output[outputOffset + 27] = v25 >>> 47 & 0x1FFFFL | (v26 & 0xFFFFFFFFFFFL) << 17;
            output[outputOffset + 28] = v26 >>> 44 & 0xFFFFFL | (v27 & 0x1FFFFFFFFFFL) << 20;
            output[outputOffset + 29] = v27 >>> 41 & 0x7FFFFFL | (v28 & 0x3FFFFFFFFFL) << 23;
            output[outputOffset + 30] = v28 >>> 38 & 0x3FFFFFFL | (v29 & 0x7FFFFFFFFL) << 26;
            output[outputOffset + 31] = v29 >>> 35 & 0x1FFFFFFFL | ((long)v30 & 0xFFFFFFFFL) << 29;
        }
    }

    private static final class Unpacker62
    implements LongBitUnpacker {
        private Unpacker62() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker62.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            long v27 = input.readLong();
            long v28 = input.readLong();
            long v29 = input.readLong();
            long v30 = input.readLong();
            output[outputOffset] = v0 & 0x3FFFFFFFFFFFFFFFL;
            output[outputOffset + 1] = v0 >>> 62 & 3L | (v1 & 0xFFFFFFFFFFFFFFFL) << 2;
            output[outputOffset + 2] = v1 >>> 60 & 0xFL | (v2 & 0x3FFFFFFFFFFFFFFL) << 4;
            output[outputOffset + 3] = v2 >>> 58 & 0x3FL | (v3 & 0xFFFFFFFFFFFFFFL) << 6;
            output[outputOffset + 4] = v3 >>> 56 & 0xFFL | (v4 & 0x3FFFFFFFFFFFFFL) << 8;
            output[outputOffset + 5] = v4 >>> 54 & 0x3FFL | (v5 & 0xFFFFFFFFFFFFFL) << 10;
            output[outputOffset + 6] = v5 >>> 52 & 0xFFFL | (v6 & 0x3FFFFFFFFFFFFL) << 12;
            output[outputOffset + 7] = v6 >>> 50 & 0x3FFFL | (v7 & 0xFFFFFFFFFFFFL) << 14;
            output[outputOffset + 8] = v7 >>> 48 & 0xFFFFL | (v8 & 0x3FFFFFFFFFFFL) << 16;
            output[outputOffset + 9] = v8 >>> 46 & 0x3FFFFL | (v9 & 0xFFFFFFFFFFFL) << 18;
            output[outputOffset + 10] = v9 >>> 44 & 0xFFFFFL | (v10 & 0x3FFFFFFFFFFL) << 20;
            output[outputOffset + 11] = v10 >>> 42 & 0x3FFFFFL | (v11 & 0xFFFFFFFFFFL) << 22;
            output[outputOffset + 12] = v11 >>> 40 & 0xFFFFFFL | (v12 & 0x3FFFFFFFFFL) << 24;
            output[outputOffset + 13] = v12 >>> 38 & 0x3FFFFFFL | (v13 & 0xFFFFFFFFFL) << 26;
            output[outputOffset + 14] = v13 >>> 36 & 0xFFFFFFFL | (v14 & 0x3FFFFFFFFL) << 28;
            output[outputOffset + 15] = v14 >>> 34 & 0x3FFFFFFFL | (v15 & 0xFFFFFFFFL) << 30;
            output[outputOffset + 16] = v15 >>> 32 & 0xFFFFFFFFL | (v16 & 0x3FFFFFFFL) << 32;
            output[outputOffset + 17] = v16 >>> 30 & 0x3FFFFFFFFL | (v17 & 0xFFFFFFFL) << 34;
            output[outputOffset + 18] = v17 >>> 28 & 0xFFFFFFFFFL | (v18 & 0x3FFFFFFL) << 36;
            output[outputOffset + 19] = v18 >>> 26 & 0x3FFFFFFFFFL | (v19 & 0xFFFFFFL) << 38;
            output[outputOffset + 20] = v19 >>> 24 & 0xFFFFFFFFFFL | (v20 & 0x3FFFFFL) << 40;
            output[outputOffset + 21] = v20 >>> 22 & 0x3FFFFFFFFFFL | (v21 & 0xFFFFFL) << 42;
            output[outputOffset + 22] = v21 >>> 20 & 0xFFFFFFFFFFFL | (v22 & 0x3FFFFL) << 44;
            output[outputOffset + 23] = v22 >>> 18 & 0x3FFFFFFFFFFFL | (v23 & 0xFFFFL) << 46;
            output[outputOffset + 24] = v23 >>> 16 & 0xFFFFFFFFFFFFL | (v24 & 0x3FFFL) << 48;
            output[outputOffset + 25] = v24 >>> 14 & 0x3FFFFFFFFFFFFL | (v25 & 0xFFFL) << 50;
            output[outputOffset + 26] = v25 >>> 12 & 0xFFFFFFFFFFFFFL | (v26 & 0x3FFL) << 52;
            output[outputOffset + 27] = v26 >>> 10 & 0x3FFFFFFFFFFFFFL | (v27 & 0xFFL) << 54;
            output[outputOffset + 28] = v27 >>> 8 & 0xFFFFFFFFFFFFFFL | (v28 & 0x3FL) << 56;
            output[outputOffset + 29] = v28 >>> 6 & 0x3FFFFFFFFFFFFFFL | (v29 & 0xFL) << 58;
            output[outputOffset + 30] = v29 >>> 4 & 0xFFFFFFFFFFFFFFFL | (v30 & 3L) << 60;
            output[outputOffset + 31] = v30 >>> 2 & 0x3FFFFFFFFFFFFFFFL;
        }
    }

    private static final class Unpacker63
    implements LongBitUnpacker {
        private Unpacker63() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker63.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(long[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            long v8 = input.readLong();
            long v9 = input.readLong();
            long v10 = input.readLong();
            long v11 = input.readLong();
            long v12 = input.readLong();
            long v13 = input.readLong();
            long v14 = input.readLong();
            long v15 = input.readLong();
            long v16 = input.readLong();
            long v17 = input.readLong();
            long v18 = input.readLong();
            long v19 = input.readLong();
            long v20 = input.readLong();
            long v21 = input.readLong();
            long v22 = input.readLong();
            long v23 = input.readLong();
            long v24 = input.readLong();
            long v25 = input.readLong();
            long v26 = input.readLong();
            long v27 = input.readLong();
            long v28 = input.readLong();
            long v29 = input.readLong();
            long v30 = input.readLong();
            int v31 = input.readInt();
            output[outputOffset] = v0 & Long.MAX_VALUE;
            output[outputOffset + 1] = v0 >>> 63 & 1L | (v1 & 0x3FFFFFFFFFFFFFFFL) << 1;
            output[outputOffset + 2] = v1 >>> 62 & 3L | (v2 & 0x1FFFFFFFFFFFFFFFL) << 2;
            output[outputOffset + 3] = v2 >>> 61 & 7L | (v3 & 0xFFFFFFFFFFFFFFFL) << 3;
            output[outputOffset + 4] = v3 >>> 60 & 0xFL | (v4 & 0x7FFFFFFFFFFFFFFL) << 4;
            output[outputOffset + 5] = v4 >>> 59 & 0x1FL | (v5 & 0x3FFFFFFFFFFFFFFL) << 5;
            output[outputOffset + 6] = v5 >>> 58 & 0x3FL | (v6 & 0x1FFFFFFFFFFFFFFL) << 6;
            output[outputOffset + 7] = v6 >>> 57 & 0x7FL | (v7 & 0xFFFFFFFFFFFFFFL) << 7;
            output[outputOffset + 8] = v7 >>> 56 & 0xFFL | (v8 & 0x7FFFFFFFFFFFFFL) << 8;
            output[outputOffset + 9] = v8 >>> 55 & 0x1FFL | (v9 & 0x3FFFFFFFFFFFFFL) << 9;
            output[outputOffset + 10] = v9 >>> 54 & 0x3FFL | (v10 & 0x1FFFFFFFFFFFFFL) << 10;
            output[outputOffset + 11] = v10 >>> 53 & 0x7FFL | (v11 & 0xFFFFFFFFFFFFFL) << 11;
            output[outputOffset + 12] = v11 >>> 52 & 0xFFFL | (v12 & 0x7FFFFFFFFFFFFL) << 12;
            output[outputOffset + 13] = v12 >>> 51 & 0x1FFFL | (v13 & 0x3FFFFFFFFFFFFL) << 13;
            output[outputOffset + 14] = v13 >>> 50 & 0x3FFFL | (v14 & 0x1FFFFFFFFFFFFL) << 14;
            output[outputOffset + 15] = v14 >>> 49 & 0x7FFFL | (v15 & 0xFFFFFFFFFFFFL) << 15;
            output[outputOffset + 16] = v15 >>> 48 & 0xFFFFL | (v16 & 0x7FFFFFFFFFFFL) << 16;
            output[outputOffset + 17] = v16 >>> 47 & 0x1FFFFL | (v17 & 0x3FFFFFFFFFFFL) << 17;
            output[outputOffset + 18] = v17 >>> 46 & 0x3FFFFL | (v18 & 0x1FFFFFFFFFFFL) << 18;
            output[outputOffset + 19] = v18 >>> 45 & 0x7FFFFL | (v19 & 0xFFFFFFFFFFFL) << 19;
            output[outputOffset + 20] = v19 >>> 44 & 0xFFFFFL | (v20 & 0x7FFFFFFFFFFL) << 20;
            output[outputOffset + 21] = v20 >>> 43 & 0x1FFFFFL | (v21 & 0x3FFFFFFFFFFL) << 21;
            output[outputOffset + 22] = v21 >>> 42 & 0x3FFFFFL | (v22 & 0x1FFFFFFFFFFL) << 22;
            output[outputOffset + 23] = v22 >>> 41 & 0x7FFFFFL | (v23 & 0xFFFFFFFFFFL) << 23;
            output[outputOffset + 24] = v23 >>> 40 & 0xFFFFFFL | (v24 & 0x7FFFFFFFFFL) << 24;
            output[outputOffset + 25] = v24 >>> 39 & 0x1FFFFFFL | (v25 & 0x3FFFFFFFFFL) << 25;
            output[outputOffset + 26] = v25 >>> 38 & 0x3FFFFFFL | (v26 & 0x1FFFFFFFFFL) << 26;
            output[outputOffset + 27] = v26 >>> 37 & 0x7FFFFFFL | (v27 & 0xFFFFFFFFFL) << 27;
            output[outputOffset + 28] = v27 >>> 36 & 0xFFFFFFFL | (v28 & 0x7FFFFFFFFL) << 28;
            output[outputOffset + 29] = v28 >>> 35 & 0x1FFFFFFFL | (v29 & 0x3FFFFFFFFL) << 29;
            output[outputOffset + 30] = v29 >>> 34 & 0x3FFFFFFFL | (v30 & 0x1FFFFFFFFL) << 30;
            output[outputOffset + 31] = v30 >>> 33 & Integer.MAX_VALUE | ((long)v31 & 0xFFFFFFFFL) << 31;
        }
    }

    private static class Unpacker64
    implements LongBitUnpacker {
        private Unpacker64() {
        }

        @Override
        public void unpack(long[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            input.readLongs(output, outputOffset, length);
        }
    }
}

