/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.DeltaBinaryPackedDecoders;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.util.Arrays;
import java.util.Objects;

public class DeltaByteArrayDecoders {
    private DeltaByteArrayDecoders() {
    }

    private static int[] readDeltaEncodedLengths(SimpleSliceInputStream input) {
        DeltaBinaryPackedDecoders.DeltaBinaryPackedIntDecoder decoder = new DeltaBinaryPackedDecoders.DeltaBinaryPackedIntDecoder();
        decoder.init(input);
        int valueCount = decoder.getValueCount();
        int[] lengths = new int[valueCount];
        decoder.read(lengths, 0, valueCount);
        return lengths;
    }

    private static abstract class AbstractDeltaByteArrayDecoder
    implements ValueDecoder<BinaryBuffer> {
        private int[] prefixLengths;
        private int[] suffixLengths;
        private int inputLengthsOffset;
        private byte[] firstPrefix = new byte[0];
        private SimpleSliceInputStream input;

        private AbstractDeltaByteArrayDecoder() {
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
            this.prefixLengths = DeltaByteArrayDecoders.readDeltaEncodedLengths(input);
            this.suffixLengths = DeltaByteArrayDecoders.readDeltaEncodedLengths(input);
        }

        @Override
        public void skip(int n) {
            Preconditions.checkPositionIndexes((int)this.inputLengthsOffset, (int)(this.inputLengthsOffset + n), (int)this.prefixLengths.length);
            if (n == 0) {
                return;
            }
            if (this.inputLengthsOffset + n == this.prefixLengths.length) {
                this.inputLengthsOffset += n;
                return;
            }
            int totalSuffixesLength = this.getSuffixesLength(n);
            Slice inputSlice = this.input.asSlice();
            int bytesLeft = this.prefixLengths[this.inputLengthsOffset + n];
            byte[] newPrefix = new byte[bytesLeft];
            int current = n - 1;
            int inputOffset = totalSuffixesLength - this.suffixLengths[this.inputLengthsOffset + n - 1];
            while (bytesLeft > 0 && inputOffset >= 0) {
                int currentPrefixLength = this.prefixLengths[this.inputLengthsOffset + current];
                if (currentPrefixLength < bytesLeft) {
                    int toCopy = bytesLeft - currentPrefixLength;
                    inputSlice.getBytes(inputOffset, newPrefix, currentPrefixLength, toCopy);
                    if ((bytesLeft -= toCopy) == 0) break;
                }
                inputOffset -= this.suffixLengths[this.inputLengthsOffset + current - 1];
                --current;
            }
            System.arraycopy(this.firstPrefix, 0, newPrefix, 0, bytesLeft);
            this.firstPrefix = newPrefix;
            this.input.skip(totalSuffixesLength);
            this.inputLengthsOffset += n;
        }

        protected abstract int truncatedLength(Slice var1, int var2, int var3);

        protected void readBounded(BinaryBuffer values, int offset, int length, int totalInputLength) {
            int outputLength;
            int inputLength;
            int i;
            Preconditions.checkPositionIndexes((int)this.inputLengthsOffset, (int)(this.inputLengthsOffset + length), (int)this.prefixLengths.length);
            if (length == 0) {
                return;
            }
            int[] outputOffsets = values.getOffsets();
            byte[] dataBuffer = this.readUnbounded(outputOffsets, offset, length, totalInputLength);
            Slice inputSlice = Slices.wrappedBuffer((byte[])dataBuffer);
            this.inputLengthsOffset += length;
            int inputOffset = 0;
            for (i = 0; i < length && (inputLength = outputOffsets[offset + i + 1] - outputOffsets[offset + i]) == (outputLength = this.truncatedLength(inputSlice, inputOffset, inputLength)); ++i) {
                inputOffset += inputLength;
            }
            if (i == length) {
                values.addChunk(inputSlice);
                return;
            }
            int outputOffset = inputOffset;
            int nextOffset = outputOffsets[offset + i];
            while (i < length) {
                int currentOffset = nextOffset;
                nextOffset = outputOffsets[offset + i + 1];
                int inputLength2 = nextOffset - currentOffset;
                int outputLength2 = this.truncatedLength(inputSlice, inputOffset, inputLength2);
                System.arraycopy(dataBuffer, inputOffset, dataBuffer, outputOffset, outputLength2);
                outputOffsets[offset + i + 1] = outputOffsets[offset + i] + outputLength2;
                inputOffset += inputLength2;
                outputOffset += outputLength2;
                ++i;
            }
            values.addChunk(inputSlice.slice(0, outputOffset));
        }

        protected void readUnbounded(BinaryBuffer values, int offset, int length, int totalInputLength) {
            Preconditions.checkPositionIndexes((int)this.inputLengthsOffset, (int)(this.inputLengthsOffset + length), (int)this.prefixLengths.length);
            if (length == 0) {
                return;
            }
            int[] outputOffsets = values.getOffsets();
            Slice outputBuffer = Slices.wrappedBuffer((byte[])this.readUnbounded(outputOffsets, offset, length, totalInputLength));
            values.addChunk(outputBuffer);
            this.inputLengthsOffset += length;
        }

        protected int getSuffixesLength(int length) {
            int totalSuffixesLength = 0;
            for (int i = 0; i < length; ++i) {
                totalSuffixesLength += this.suffixLengths[this.inputLengthsOffset + i];
            }
            return totalSuffixesLength;
        }

        protected int getInputLength(int length) {
            int totalInputLength = 0;
            for (int i = 0; i < length; ++i) {
                totalInputLength += this.prefixLengths[this.inputLengthsOffset + i] + this.suffixLengths[this.inputLengthsOffset + i];
            }
            return totalInputLength;
        }

        protected InputLengths getInputAndMaxLength(int length) {
            int totalInputLength = 0;
            int maxLength = 0;
            for (int i = 0; i < length; ++i) {
                int inputLength = this.prefixLengths[this.inputLengthsOffset + i] + this.suffixLengths[this.inputLengthsOffset + i];
                totalInputLength += inputLength;
                maxLength = Math.max(maxLength, inputLength);
            }
            return new InputLengths(totalInputLength, maxLength);
        }

        private byte[] readUnbounded(int[] outputOffsets, int offset, int length, int totalInputLength) {
            int inputOffsetStart;
            byte[] inputBytes;
            byte[] output = new byte[totalInputLength];
            Slice inputSlice = this.input.asSlice();
            if (inputSlice.length() != 0) {
                inputBytes = inputSlice.byteArray();
                inputOffsetStart = inputSlice.byteArrayOffset();
            } else {
                inputBytes = new byte[]{};
                inputOffsetStart = 0;
            }
            int inputOffset = inputOffsetStart;
            outputOffsets[offset + 1] = outputOffsets[offset] + this.prefixLengths[this.inputLengthsOffset] + this.suffixLengths[this.inputLengthsOffset];
            System.arraycopy(this.firstPrefix, 0, output, 0, this.prefixLengths[this.inputLengthsOffset]);
            int outputOffset = this.prefixLengths[this.inputLengthsOffset];
            int outputLength = this.suffixLengths[this.inputLengthsOffset];
            for (int i = 1; i < length; ++i) {
                int prefixLength = this.prefixLengths[this.inputLengthsOffset + i];
                int suffixLength = this.suffixLengths[this.inputLengthsOffset + i];
                outputOffsets[offset + i + 1] = outputOffsets[offset + i] + prefixLength + suffixLength;
                if (prefixLength > 0) {
                    System.arraycopy(inputBytes, inputOffset, output, outputOffset, outputLength);
                    inputOffset += outputLength;
                    outputOffset += outputLength;
                    outputLength = 0;
                    int previousPositionLength = this.prefixLengths[this.inputLengthsOffset + i - 1] + this.suffixLengths[this.inputLengthsOffset + i - 1];
                    int previousOutputStart = outputOffset - previousPositionLength;
                    System.arraycopy(output, previousOutputStart, output, outputOffset, prefixLength);
                    outputOffset += prefixLength;
                }
                outputLength += suffixLength;
            }
            System.arraycopy(inputBytes, inputOffset, output, outputOffset, outputLength);
            outputOffset += outputLength;
            this.input.skip((inputOffset += outputLength) - inputOffsetStart);
            if (this.inputLengthsOffset + length < this.prefixLengths.length) {
                int previousPositionLength = this.prefixLengths[this.inputLengthsOffset + length - 1] + this.suffixLengths[this.inputLengthsOffset + length - 1];
                int previousOutputStart = outputOffset - previousPositionLength;
                this.firstPrefix = Arrays.copyOfRange(output, previousOutputStart, previousOutputStart + this.prefixLengths[this.inputLengthsOffset + length]);
            }
            return output;
        }

        protected record InputLengths(int totalInputLength, int maxInputLength) {
        }
    }

    public static final class BinaryDeltaByteArrayDecoder
    extends AbstractDeltaByteArrayDecoder {
        @Override
        protected int truncatedLength(Slice slice, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            int totalInputLength = this.getInputLength(length);
            this.readUnbounded(values, offset, length, totalInputLength);
        }
    }

    public static final class CharDeltaByteArrayDecoder
    extends AbstractDeltaByteArrayDecoder {
        private final int maxLength;

        public CharDeltaByteArrayDecoder(CharType charType) {
            this.maxLength = charType.getLength();
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            int totalInputLength = this.getInputLength(length);
            this.readBounded(values, offset, length, totalInputLength);
        }

        @Override
        protected int truncatedLength(Slice slice, int offset, int length) {
            return Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)this.maxLength);
        }
    }

    public static final class BoundedVarcharDeltaByteArrayDecoder
    extends AbstractDeltaByteArrayDecoder {
        private final int boundedLength;

        public BoundedVarcharDeltaByteArrayDecoder(VarcharType varcharType) {
            Preconditions.checkArgument((!varcharType.isUnbounded() ? 1 : 0) != 0, (String)"Trino type %s is not a bounded varchar", (Object)varcharType);
            this.boundedLength = varcharType.getBoundedLength();
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            boolean truncate;
            AbstractDeltaByteArrayDecoder.InputLengths lengths = this.getInputAndMaxLength(length);
            int maxLength = lengths.maxInputLength();
            int totalInputLength = lengths.totalInputLength();
            boolean bl = truncate = maxLength > this.boundedLength;
            if (truncate) {
                this.readBounded(values, offset, length, totalInputLength);
            } else {
                this.readUnbounded(values, offset, length, totalInputLength);
            }
        }

        @Override
        protected int truncatedLength(Slice slice, int offset, int length) {
            return Varchars.byteCount((Slice)slice, (int)offset, (int)length, (int)this.boundedLength);
        }
    }
}

