/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.DeltaPackingUtils;
import io.trino.parquet.reader.decoders.ValueDecoder;
import java.util.Objects;

public final class DeltaBinaryPackedDecoders {
    private static final int COMMON_MINI_BLOCKS_NUMBER = 4;
    private static final int FIRST_VALUE = -1;

    private DeltaBinaryPackedDecoders() {
    }

    private static abstract class DeltaBinaryPackedDecoder<ValuesType>
    implements ValueDecoder<ValuesType> {
        private SimpleSliceInputStream input;
        private int blockSize;
        private int miniBlockSize;
        private long previousValue;
        private int miniBlocksInBlock;
        private byte[] bitWidths;
        private int alreadyReadInBlock;
        private ValuesType blockValues;
        private int valueCount;
        private long blockMinDelta;
        private int miniBlocksRemaining;

        private DeltaBinaryPackedDecoder() {
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
            this.alreadyReadInBlock = -1;
            this.readHeader();
            this.blockValues = this.createMiniBlockBuffer(this.blockSize + 1);
            this.bitWidths = new byte[this.miniBlocksInBlock];
        }

        protected abstract ValuesType createMiniBlockBuffer(int var1);

        protected abstract void setValue(ValuesType var1, int var2, long var3);

        protected abstract long unpack(ValuesType var1, int var2, int var3, SimpleSliceInputStream var4, long var5, byte var7);

        private void readHeader() {
            this.blockSize = ParquetReaderUtils.readUleb128Int(this.input);
            Preconditions.checkArgument((this.blockSize % 128 == 0 ? 1 : 0) != 0, (Object)"Corrupted Parquet file: block size of the delta encoding needs to be a multiple of 128");
            this.miniBlockSize = this.blockSize / ParquetReaderUtils.readUleb128Int(this.input);
            Preconditions.checkArgument((this.miniBlockSize % 32 == 0 ? 1 : 0) != 0, (Object)"Corrupted Parquet file: mini block size of the delta encoding needs to be a multiple of 32");
            this.valueCount = ParquetReaderUtils.readUleb128Int(this.input);
            this.miniBlocksRemaining = ParquetReaderUtils.ceilDiv(this.valueCount - 1, this.miniBlockSize);
            this.previousValue = ParquetReaderUtils.zigzagDecode(ParquetReaderUtils.readUleb128Long(this.input));
            this.miniBlocksInBlock = this.blockSize / this.miniBlockSize;
        }

        public void readInternal(ValuesType values, int offset, int length) {
            if (this.alreadyReadInBlock == -1 && length > 0) {
                this.setValue(values, offset++, this.previousValue);
                --length;
                this.alreadyReadInBlock = 0;
            }
            if (this.alreadyReadInBlock != 0) {
                int chunkSize = Math.min(length, this.blockSize - this.alreadyReadInBlock);
                System.arraycopy(this.blockValues, this.alreadyReadInBlock + 1, values, offset, chunkSize);
                this.markRead(chunkSize);
                offset += chunkSize;
                length -= chunkSize;
            }
            while (length > 0) {
                this.readBlockHeader();
                if (length <= this.blockSize) {
                    this.setValue(this.blockValues, 0, this.previousValue);
                    this.readBlock(this.blockValues, 1);
                    System.arraycopy(this.blockValues, 1, values, offset, length);
                    this.markRead(length);
                    length = 0;
                    continue;
                }
                if (offset == 0) {
                    this.setValue(this.blockValues, 0, this.previousValue);
                    this.readBlock(this.blockValues, 1);
                    System.arraycopy(this.blockValues, 1, values, offset, this.blockSize);
                } else {
                    this.readBlock(values, offset);
                }
                offset += this.blockSize;
                length -= this.blockSize;
            }
        }

        public int getValueCount() {
            return this.valueCount;
        }

        private boolean areBitWidthTheSame() {
            if (this.miniBlocksInBlock == 4) {
                byte and = (byte)(this.bitWidths[0] & this.bitWidths[1] & this.bitWidths[2] & this.bitWidths[3]);
                byte or = (byte)(this.bitWidths[0] | this.bitWidths[1] | this.bitWidths[2] | this.bitWidths[3]);
                return and == or;
            }
            byte first = this.bitWidths[0];
            boolean same = true;
            for (int i = 1; i < this.miniBlocksInBlock; ++i) {
                same &= this.bitWidths[i] == first;
            }
            return same;
        }

        @Override
        public void skip(int n) {
            int chunkSize;
            if (n == 0) {
                return;
            }
            if (this.alreadyReadInBlock == -1) {
                --n;
                this.alreadyReadInBlock = 0;
            }
            if (this.alreadyReadInBlock != 0) {
                chunkSize = Math.min(n, this.blockSize - this.alreadyReadInBlock);
                this.markRead(chunkSize);
                n -= chunkSize;
            }
            while (n > 0) {
                this.readBlockHeader();
                this.setValue(this.blockValues, 0, this.previousValue);
                this.readBlock(this.blockValues, 1);
                chunkSize = Math.min(n, this.blockSize);
                this.markRead(chunkSize);
                n -= chunkSize;
            }
        }

        private void markRead(int chunkSize) {
            this.alreadyReadInBlock += chunkSize;
            this.alreadyReadInBlock %= this.blockSize;
        }

        private void readBlock(ValuesType output, int outputOffset) {
            int miniBlocksToRead = Math.min(this.miniBlocksRemaining, this.miniBlocksInBlock);
            if (miniBlocksToRead == this.miniBlocksInBlock && this.areBitWidthTheSame()) {
                byte bitWidth = this.bitWidths[0];
                this.previousValue = this.unpack(output, outputOffset, this.blockSize, this.input, this.blockMinDelta, bitWidth);
            } else {
                for (int i = 0; i < miniBlocksToRead; ++i) {
                    byte bitWidth = this.bitWidths[i];
                    this.previousValue = this.unpack(output, outputOffset, this.miniBlockSize, this.input, this.blockMinDelta, bitWidth);
                    outputOffset += this.miniBlockSize;
                }
            }
            this.miniBlocksRemaining -= miniBlocksToRead;
        }

        private void readBlockHeader() {
            this.blockMinDelta = ParquetReaderUtils.zigzagDecode(ParquetReaderUtils.readUleb128Long(this.input));
            if (this.miniBlocksInBlock == 4) {
                int bitWidthsPacked = this.input.readInt();
                this.bitWidths[0] = (byte)bitWidthsPacked;
                this.bitWidths[1] = (byte)(bitWidthsPacked >> 8);
                this.bitWidths[2] = (byte)(bitWidthsPacked >> 16);
                this.bitWidths[3] = (byte)(bitWidthsPacked >> 24);
            } else {
                this.input.readBytes(this.bitWidths, 0, this.miniBlocksInBlock);
            }
        }
    }

    public static class DeltaBinaryPackedLongDecoder
    extends DeltaBinaryPackedDecoder<long[]> {
        @Override
        protected long[] createMiniBlockBuffer(int size) {
            return new long[size];
        }

        @Override
        protected void setValue(long[] values, int offset, long value) {
            values[offset] = value;
        }

        @Override
        public void read(long[] values, int offset, int length) {
            this.readInternal(values, offset, length);
        }

        @Override
        protected long unpack(long[] output, int outputOffset, int length, SimpleSliceInputStream input, long minDelta, byte bitWidth) {
            DeltaPackingUtils.unpackDelta(output, outputOffset, length, input, minDelta, bitWidth);
            return output[outputOffset + length - 1];
        }
    }

    public static class DeltaBinaryPackedIntDecoder
    extends DeltaBinaryPackedDecoder<int[]> {
        @Override
        protected int[] createMiniBlockBuffer(int size) {
            return new int[size];
        }

        @Override
        protected void setValue(int[] values, int offset, long value) {
            values[offset] = (int)value;
        }

        @Override
        public void read(int[] values, int offset, int length) {
            this.readInternal(values, offset, length);
        }

        @Override
        protected long unpack(int[] output, int outputOffset, int length, SimpleSliceInputStream input, long minDelta, byte bitWidth) {
            DeltaPackingUtils.unpackDelta(output, outputOffset, length, input, minDelta, bitWidth);
            return output[outputOffset + length - 1];
        }
    }

    public static class DeltaBinaryPackedShortDecoder
    extends DeltaBinaryPackedDecoder<short[]> {
        @Override
        protected short[] createMiniBlockBuffer(int size) {
            return new short[size];
        }

        @Override
        protected void setValue(short[] values, int offset, long value) {
            values[offset] = (short)value;
        }

        @Override
        public void read(short[] values, int offset, int length) {
            this.readInternal(values, offset, length);
        }

        @Override
        protected long unpack(short[] output, int outputOffset, int length, SimpleSliceInputStream input, long minDelta, byte bitWidth) {
            DeltaPackingUtils.unpackDelta(output, outputOffset, length, input, minDelta, bitWidth);
            return output[outputOffset + length - 1];
        }
    }

    public static class DeltaBinaryPackedByteDecoder
    extends DeltaBinaryPackedDecoder<byte[]> {
        @Override
        protected byte[] createMiniBlockBuffer(int size) {
            return new byte[size];
        }

        @Override
        protected void setValue(byte[] values, int offset, long value) {
            values[offset] = (byte)value;
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            this.readInternal(values, offset, length);
        }

        @Override
        protected long unpack(byte[] output, int outputOffset, int length, SimpleSliceInputStream input, long minDelta, byte bitWidth) {
            DeltaPackingUtils.unpackDelta(output, outputOffset, length, input, minDelta, bitWidth);
            return output[outputOffset + length - 1];
        }
    }
}

