/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.Objects;

public final class SimpleSliceInputStream {
    private final Slice slice;
    private int offset;

    public SimpleSliceInputStream(Slice slice) {
        this(slice, 0);
    }

    public SimpleSliceInputStream(Slice slice, int offset) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.offset = offset;
    }

    public byte readByte() {
        return this.slice.getByte(this.offset++);
    }

    public short readShort() {
        short value = this.slice.getShort(this.offset);
        this.offset += 2;
        return value;
    }

    public int readInt() {
        int value = this.slice.getInt(this.offset);
        this.offset += 4;
        return value;
    }

    public long readLong() {
        long value = this.slice.getLong(this.offset);
        this.offset += 8;
        return value;
    }

    public byte[] readBytes() {
        byte[] bytes = this.slice.getBytes();
        this.offset = this.slice.length();
        return bytes;
    }

    public void readBytes(byte[] output, int outputOffset, int length) {
        this.slice.getBytes(this.offset, output, outputOffset, length);
        this.offset += length;
    }

    public void readShorts(short[] output, int outputOffset, int length) {
        this.slice.getShorts(this.offset, output, outputOffset, length);
        this.offset += length * 2;
    }

    public void readInts(int[] output, int outputOffset, int length) {
        this.slice.getInts(this.offset, output, outputOffset, length);
        this.offset += length * 4;
    }

    public void readLongs(long[] output, int outputOffset, int length) {
        this.slice.getLongs(this.offset, output, outputOffset, length);
        this.offset += length * 8;
    }

    public void readBytes(Slice destination, int destinationIndex, int length) {
        this.slice.getBytes(this.offset, destination, destinationIndex, length);
        this.offset += length;
    }

    public Slice readSlice(int length) {
        Slice result = this.slice.slice(this.offset, length);
        this.offset += length;
        return result;
    }

    public void skip(int n) {
        this.offset += n;
    }

    public Slice asSlice() {
        return this.slice.slice(this.offset, this.slice.length() - this.offset);
    }

    public byte[] getByteArray() {
        return this.slice.byteArray();
    }

    public int getByteArrayOffset() {
        return this.offset + this.slice.byteArrayOffset();
    }

    public void ensureBytesAvailable(int bytes) {
        Preconditions.checkPositionIndexes((int)this.offset, (int)(this.offset + bytes), (int)this.slice.length());
    }

    public int readIntUnsafe() {
        int value = this.slice.getIntUnchecked(this.offset);
        this.offset += 4;
        return value;
    }

    public long readLongUnsafe() {
        long value = this.slice.getLongUnchecked(this.offset);
        this.offset += 8;
        return value;
    }

    public byte getByteUnsafe(int index) {
        return this.slice.getByteUnchecked(this.offset + index);
    }

    public int getIntUnsafe(int index) {
        return this.slice.getIntUnchecked(this.offset + index);
    }

    public long getLongUnsafe(int index) {
        return this.slice.getLongUnchecked(this.offset + index);
    }
}

