/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.dictionary;

import com.google.common.base.MoreObjects;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.PlainValueDecoders;

public class FloatDictionary
implements Dictionary {
    private final float[] content;

    public FloatDictionary(DictionaryPage dictionaryPage) {
        int length = dictionaryPage.getDictionarySize();
        int[] buffer = new int[length];
        PlainValueDecoders.IntPlainValueDecoder floatReader = new PlainValueDecoders.IntPlainValueDecoder();
        floatReader.init(new SimpleSliceInputStream(dictionaryPage.getSlice()));
        floatReader.read(buffer, 0, length);
        this.content = new float[length];
        for (int i = 0; i < length; ++i) {
            this.content[i] = Float.intBitsToFloat(buffer[i]);
        }
    }

    @Override
    public float decodeToFloat(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

