/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.RowBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

class ColumnStatisticsValidation {
    private final Type type;
    private final List<ColumnStatisticsValidation> fieldBuilders;
    private long valuesCount;
    private long nonLeafValuesCount;

    public ColumnStatisticsValidation(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.fieldBuilders = (List)type.getTypeParameters().stream().map(ColumnStatisticsValidation::new).collect(ImmutableList.toImmutableList());
    }

    public void addBlock(Block block) {
        this.addBlock(block, new ColumnStatistics(0L, 0L));
    }

    public List<ColumnStatistics> build() {
        if (this.fieldBuilders.isEmpty()) {
            return ImmutableList.of((Object)new ColumnStatistics(this.valuesCount, this.nonLeafValuesCount));
        }
        return (List)this.fieldBuilders.stream().flatMap(builder -> builder.build().stream()).collect(ImmutableList.toImmutableList());
    }

    private void addBlock(Block block, ColumnStatistics columnStatistics) {
        ColumnStatistics mergedColumnStatistics;
        Object fields;
        if (this.fieldBuilders.isEmpty()) {
            this.addPrimitiveBlock(block);
            this.valuesCount += columnStatistics.valuesCount();
            this.nonLeafValuesCount += columnStatistics.nonLeafValuesCount();
            return;
        }
        if (this.type instanceof ArrayType) {
            ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
            fields = ImmutableList.of((Object)columnarArray.getElementsBlock());
            mergedColumnStatistics = columnStatistics.merge(ColumnStatisticsValidation.addArrayBlock(columnarArray));
        } else if (this.type instanceof MapType) {
            ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
            fields = ImmutableList.of((Object)columnarMap.getKeysBlock(), (Object)columnarMap.getValuesBlock());
            mergedColumnStatistics = columnStatistics.merge(ColumnStatisticsValidation.addMapBlock(columnarMap));
        } else if (this.type instanceof RowType) {
            fields = RowBlock.getNullSuppressedRowFieldsFromBlock((Block)block);
            mergedColumnStatistics = columnStatistics.merge(ColumnStatisticsValidation.addRowBlock(block));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type: %s", this.type));
        }
        for (int i = 0; i < this.fieldBuilders.size(); ++i) {
            this.fieldBuilders.get(i).addBlock((Block)fields.get(i), mergedColumnStatistics);
        }
    }

    private void addPrimitiveBlock(Block block) {
        this.valuesCount += (long)block.getPositionCount();
        if (!block.mayHaveNull()) {
            return;
        }
        int nullsCount = 0;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            nullsCount += block.isNull(position) ? 1 : 0;
        }
        this.nonLeafValuesCount += (long)nullsCount;
    }

    private static ColumnStatistics addMapBlock(ColumnarMap block) {
        if (!block.mayHaveNull()) {
            int emptyEntriesCount = 0;
            for (int position = 0; position < block.getPositionCount(); ++position) {
                emptyEntriesCount += block.getEntryCount(position) == 0 ? 1 : 0;
            }
            return new ColumnStatistics(emptyEntriesCount, emptyEntriesCount);
        }
        int nonLeafValuesCount = 0;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            nonLeafValuesCount += block.isNull(position) || block.getEntryCount(position) == 0 ? 1 : 0;
        }
        return new ColumnStatistics(nonLeafValuesCount, nonLeafValuesCount);
    }

    private static ColumnStatistics addArrayBlock(ColumnarArray block) {
        if (!block.mayHaveNull()) {
            int emptyEntriesCount = 0;
            for (int position = 0; position < block.getPositionCount(); ++position) {
                emptyEntriesCount += block.getLength(position) == 0 ? 1 : 0;
            }
            return new ColumnStatistics(emptyEntriesCount, emptyEntriesCount);
        }
        int nonLeafValuesCount = 0;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            nonLeafValuesCount += block.isNull(position) || block.getLength(position) == 0 ? 1 : 0;
        }
        return new ColumnStatistics(nonLeafValuesCount, nonLeafValuesCount);
    }

    private static ColumnStatistics addRowBlock(Block block) {
        if (!block.mayHaveNull()) {
            return new ColumnStatistics(0L, 0L);
        }
        int nullsCount = 0;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            nullsCount += block.isNull(position) ? 1 : 0;
        }
        return new ColumnStatistics(nullsCount, nullsCount);
    }

    record ColumnStatistics(long valuesCount, long nonLeafValuesCount) {
        ColumnStatistics merge(ColumnStatistics other) {
            return new ColumnStatistics(this.valuesCount + other.valuesCount(), this.nonLeafValuesCount + other.nonLeafValuesCount());
        }
    }
}

