/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.openxjson;

import io.trino.hive.formats.line.openxjson.JsonString;
import io.trino.hive.formats.line.openxjson.OpenXJsonDeserializer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class JsonWriter {
    private final StringBuilder out = new StringBuilder();
    private final List<Scope> scopes = new ArrayList<Scope>();

    public static String writeJsonObject(Map<?, ?> jsonObject) {
        Objects.requireNonNull(jsonObject, "jsonObject is null");
        JsonWriter writer = new JsonWriter();
        writer.value(jsonObject);
        return writer.toString();
    }

    public static String writeJsonArray(List<?> jsonArray) {
        Objects.requireNonNull(jsonArray, "jsonArray is null");
        JsonWriter writer = new JsonWriter();
        writer.value(jsonArray);
        return writer.toString();
    }

    public static String canonicalizeJsonString(JsonString jsonString) {
        String canonicalUnquotedString;
        if (!jsonString.quoted() && (canonicalUnquotedString = JsonWriter.canonicalizeUnquotedString(jsonString.value())) != null) {
            return canonicalUnquotedString;
        }
        return jsonString.value();
    }

    private JsonWriter() {
    }

    private void beginArray() {
        this.openNewScope(Scope.EMPTY_ARRAY, "[");
    }

    private void beginObject() {
        this.openNewScope(Scope.EMPTY_OBJECT, "{");
    }

    private void endArray() {
        this.closeCurrentScope(Scope.EMPTY_ARRAY, Scope.NONEMPTY_ARRAY, "]");
    }

    private void endObject() {
        this.closeCurrentScope(Scope.EMPTY_OBJECT, Scope.NONEMPTY_OBJECT, "}");
    }

    private void fieldName(Object name) {
        if (name == null) {
            throw new IllegalStateException("Field name must not be null");
        }
        Scope context = this.getCurrentScope();
        if (context == Scope.NONEMPTY_OBJECT) {
            this.out.append(',');
        } else if (context != Scope.EMPTY_OBJECT) {
            throw new IllegalStateException("Nesting problem");
        }
        this.replaceCurrentScope(Scope.DANGLING_FIELD_NAME);
        this.writeJsonString(name.toString());
    }

    private void value(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            this.beginArray();
            for (Object entry : list) {
                this.value(entry);
            }
            this.endArray();
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            this.beginObject();
            for (Map.Entry entry : map.entrySet()) {
                this.fieldName(entry.getKey());
                this.value(entry.getValue());
            }
            this.endObject();
            return;
        }
        if (this.scopes.isEmpty()) {
            throw new IllegalStateException("Nesting problem");
        }
        this.beforeValue();
        if (value == null || value instanceof Boolean) {
            this.out.append(value);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            this.writeJsonNumber(number);
        } else if (value instanceof String) {
            String string = (String)value;
            this.writeJsonString(string);
        } else if (value instanceof JsonString) {
            String canonicalUnquotedString;
            JsonString string = (JsonString)value;
            if (!string.quoted() && (canonicalUnquotedString = JsonWriter.canonicalizeUnquotedString(string.value())) != null) {
                this.out.append(canonicalUnquotedString);
                return;
            }
            this.writeJsonString(string.value());
        } else {
            throw new IllegalArgumentException("Unsupported value type: " + value.getClass().getSimpleName());
        }
    }

    private static String canonicalizeUnquotedString(String value) {
        if (value.equalsIgnoreCase("true")) {
            return "true";
        }
        if (value.equalsIgnoreCase("false")) {
            return "false";
        }
        try {
            return String.valueOf(OpenXJsonDeserializer.parseDecimalHexOctalLong(value));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new BigDecimal(value).toString();
            }
            catch (NumberFormatException numberFormatException2) {
                return null;
            }
        }
    }

    private void writeJsonString(String value) {
        this.out.append("\"");
        char currentChar = '\u0000';
        int length = value.length();
        block9: for (int i = 0; i < length; ++i) {
            char previousChar = currentChar;
            currentChar = value.charAt(i);
            switch (currentChar) {
                case '\"': 
                case '\\': {
                    this.out.append('\\').append(currentChar);
                    continue block9;
                }
                case '/': {
                    if (previousChar == '<') {
                        this.out.append('\\');
                    }
                    this.out.append(currentChar);
                    continue block9;
                }
                case '\t': {
                    this.out.append("\\t");
                    continue block9;
                }
                case '\b': {
                    this.out.append("\\b");
                    continue block9;
                }
                case '\n': {
                    this.out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    this.out.append("\\r");
                    continue block9;
                }
                case '\f': {
                    this.out.append("\\f");
                    continue block9;
                }
                default: {
                    if (currentChar <= '\u001f') {
                        this.out.append(String.format("\\u%04x", currentChar));
                        continue block9;
                    }
                    this.out.append(currentChar);
                }
            }
        }
        this.out.append("\"");
    }

    private void writeJsonNumber(Number number) {
        Objects.requireNonNull(number, "number is null");
        if (number instanceof Double || number instanceof Float) {
            if (number.equals(-0.0)) {
                this.out.append("-0");
                return;
            }
            if (number.doubleValue() == (double)number.longValue()) {
                this.out.append(number.longValue());
                return;
            }
        }
        this.out.append(number);
    }

    private void beforeValue() {
        if (this.scopes.isEmpty()) {
            return;
        }
        Scope context = this.getCurrentScope();
        if (context == Scope.EMPTY_ARRAY) {
            this.replaceCurrentScope(Scope.NONEMPTY_ARRAY);
            return;
        }
        if (context == Scope.NONEMPTY_ARRAY) {
            this.out.append(',');
            return;
        }
        if (context == Scope.DANGLING_FIELD_NAME) {
            this.out.append(":");
            this.replaceCurrentScope(Scope.NONEMPTY_OBJECT);
            return;
        }
        throw new IllegalStateException("Nesting problem");
    }

    private void openNewScope(Scope empty, String openBracket) {
        if (this.scopes.isEmpty() && !this.out.isEmpty()) {
            throw new IllegalStateException("Nesting problem: multiple top-level roots");
        }
        this.beforeValue();
        this.scopes.add(empty);
        this.out.append(openBracket);
    }

    private void closeCurrentScope(Scope empty, Scope nonempty, String closeBracket) {
        Scope context = this.getCurrentScope();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem");
        }
        this.scopes.remove(this.scopes.size() - 1);
        this.out.append(closeBracket);
    }

    private Scope getCurrentScope() {
        if (this.scopes.isEmpty()) {
            throw new IllegalStateException("Nesting problem");
        }
        return this.scopes.get(this.scopes.size() - 1);
    }

    private void replaceCurrentScope(Scope topOfStack) {
        this.scopes.set(this.scopes.size() - 1, topOfStack);
    }

    public String toString() {
        return this.out.isEmpty() ? null : this.out.toString();
    }

    private static enum Scope {
        EMPTY_ARRAY,
        NONEMPTY_ARRAY,
        EMPTY_OBJECT,
        DANGLING_FIELD_NAME,
        NONEMPTY_OBJECT;

    }
}

