/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.openxjson;

import io.trino.hive.formats.line.openxjson.InvalidJsonException;
import io.trino.hive.formats.line.openxjson.JsonString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;

final class JsonReader<T> {
    private final String json;
    private final Function<String, T> keyMap;
    private int position;

    public static <T> Object readJson(String json, Function<String, T> keyMap) throws InvalidJsonException {
        return new JsonReader<T>(json, keyMap).nextValue();
    }

    private JsonReader(String json, Function<String, T> keyMap) {
        Objects.requireNonNull(json, "json is null");
        this.keyMap = keyMap;
        this.json = json;
    }

    private Object nextValue() throws InvalidJsonException {
        int c = this.seekNextToken();
        if (c == -1) {
            throw new InvalidJsonException("End of input", this.position, this.json);
        }
        if (c == 123) {
            return this.readObject();
        }
        if (c == 91) {
            return this.readArray();
        }
        if (c == 39 || c == 34) {
            return this.readQuotedString((char)c);
        }
        --this.position;
        return this.readLiteral();
    }

    private Map<T, Object> readObject() throws InvalidJsonException {
        int c;
        int first = this.seekNextToken();
        if (first == 125) {
            return Collections.emptyMap();
        }
        if (first != -1) {
            --this.position;
        }
        LinkedHashMap<T, Object> jsonObject = new LinkedHashMap<T, Object>();
        do {
            Object name;
            if ((name = this.nextValue()) == null) {
                throw new InvalidJsonException("Field name is null literal", this.position, this.json);
            }
            if (!(name instanceof JsonString)) {
                String message = "Names must be strings, but %s is of type %s".formatted(name, name.getClass().getSimpleName());
                throw new InvalidJsonException(message, this.position, this.json);
            }
            JsonString jsonString = (JsonString)name;
            name = jsonString.value();
            int separator = this.seekNextToken();
            if (separator != 58 && separator != 61) {
                throw new InvalidJsonException("Expected ':' after field " + name, this.position, this.json);
            }
            if (separator == 61 && this.position < this.json.length() && this.json.charAt(this.position) == '>') {
                ++this.position;
            }
            T key = this.keyMap.apply((String)name);
            jsonObject.remove(key);
            jsonObject.put(key, this.nextValue());
            c = this.seekNextToken();
            if (c != 125) continue;
            return Collections.unmodifiableMap(jsonObject);
        } while (c == 44 || c == 59);
        throw new InvalidJsonException("Unterminated object", this.position, this.json);
    }

    private List<Object> readArray() throws InvalidJsonException {
        ArrayList<Object> jsonArray = new ArrayList<Object>();
        boolean hasTrailingSeparator = false;
        while (true) {
            int c;
            if ((c = this.seekNextToken()) == -1) {
                throw new InvalidJsonException("Unterminated array", this.position, this.json);
            }
            if (c == 93) {
                if (hasTrailingSeparator) {
                    jsonArray.add(null);
                }
                return Collections.unmodifiableList(jsonArray);
            }
            if (c == 44 || c == 59) {
                jsonArray.add(null);
                hasTrailingSeparator = true;
                continue;
            }
            --this.position;
            jsonArray.add(this.nextValue());
            c = this.seekNextToken();
            if (c == 93) {
                return Collections.unmodifiableList(jsonArray);
            }
            if (c != 44 && c != 59) {
                throw new InvalidJsonException("Unterminated array", this.position, this.json);
            }
            hasTrailingSeparator = true;
        }
    }

    private JsonString readQuotedString(char quote) throws InvalidJsonException {
        StringBuilder builder = null;
        int start = this.position;
        while (this.position < this.json.length()) {
            char c;
            if ((c = this.json.charAt(this.position++)) == quote) {
                if (builder == null) {
                    return new JsonString(this.json.substring(start, this.position - 1), true);
                }
                builder.append(this.json, start, this.position - 1);
                return new JsonString(builder.toString(), true);
            }
            if (c != '\\') continue;
            if (this.position == this.json.length()) {
                throw new InvalidJsonException("Unterminated escape sequence", this.position, this.json);
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.json, start, this.position - 1);
            builder.append(this.decodeEscapeCharacter());
            start = this.position;
        }
        throw new InvalidJsonException("Unterminated string", this.position, this.json);
    }

    private char decodeEscapeCharacter() throws InvalidJsonException {
        char escaped = this.json.charAt(this.position++);
        switch (escaped) {
            case 'u': {
                if (this.position + 4 > this.json.length()) {
                    throw new InvalidJsonException("Unterminated escape sequence", this.position, this.json);
                }
                String hex = this.json.substring(this.position, this.position + 4);
                this.position += 4;
                try {
                    return (char)Integer.parseInt(hex, 16);
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidJsonException("Invalid escape sequence: " + hex, this.position, this.json);
                }
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'a': {
                return '\u0007';
            }
            case 'v': {
                return '\t';
            }
        }
        return escaped;
    }

    private JsonString readLiteral() throws InvalidJsonException {
        String literal = this.literalToken();
        if (literal.isEmpty()) {
            throw new InvalidJsonException("Expected literal value", this.position, this.json);
        }
        if ("null".equalsIgnoreCase(literal)) {
            return null;
        }
        return new JsonString(literal, false);
    }

    private String literalToken() {
        int start = this.position;
        while (this.position < this.json.length()) {
            char c = this.json.charAt(this.position);
            if (c == ' ' || c == '\r' || c == '\n' || c == '\t' || c == '\f' || c == '{' || c == '}' || c == '[' || c == ']' || c == '/' || c == '\\' || c == ':' || c == ',' || c == '=' || c == ';' || c == '#') {
                return this.json.substring(start, this.position);
            }
            ++this.position;
        }
        return this.json.substring(start);
    }

    private int seekNextToken() throws InvalidJsonException {
        block5: while (this.position < this.json.length()) {
            char c = this.json.charAt(this.position++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block5;
                }
                case '#': {
                    this.skipEndOfLineComment();
                    continue block5;
                }
                case '/': {
                    if (this.position == this.json.length()) {
                        return c;
                    }
                    char peek = this.json.charAt(this.position);
                    if (peek == '*') {
                        ++this.position;
                        int commentEnd = this.json.indexOf("*/", this.position);
                        if (commentEnd == -1) {
                            throw new InvalidJsonException("Unterminated c-style comment", this.position, this.json);
                        }
                        this.position = commentEnd + 2;
                        continue block5;
                    }
                    if (peek == '/') {
                        this.skipEndOfLineComment();
                        continue block5;
                    }
                    return c;
                }
            }
            return c;
        }
        return -1;
    }

    private void skipEndOfLineComment() {
        while (this.position < this.json.length()) {
            char c = this.json.charAt(this.position);
            ++this.position;
            if (c != '\r' && c != '\n') continue;
            return;
        }
    }

    public String toString() {
        return new StringJoiner(", ", JsonReader.class.getSimpleName() + "[", "]").add("in='" + this.json + "'").add("position=" + this.position).toString();
    }
}

