/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import com.google.common.primitives.UnsignedBytes;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.hive.formats.ReadWriteUtils;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.Type;

public class StringEncoding
implements TextColumnEncoding {
    private final Type type;
    private final Slice nullSequence;
    private final byte escapeByte;
    private final boolean[] needsEscape;
    private final DynamicSliceOutput escapeBuffer;

    public StringEncoding(Type type, Slice nullSequence, Byte escapeChar, Slice separators) {
        this.type = type;
        this.nullSequence = nullSequence;
        if (escapeChar == null) {
            this.escapeByte = 0;
            this.escapeBuffer = null;
            this.needsEscape = null;
        } else {
            this.escapeByte = escapeChar;
            this.escapeBuffer = new DynamicSliceOutput(1024);
            this.needsEscape = new boolean[256];
            this.needsEscape[UnsignedBytes.toInt((byte)this.escapeByte)] = true;
            for (int i = 0; i < separators.length(); ++i) {
                this.needsEscape[UnsignedBytes.toInt((byte)separators.getByte((int)i))] = true;
            }
        }
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValue(block, output, position);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        this.encodeValue(block, output, position);
    }

    private void encodeValue(Block block, SliceOutput output, int position) {
        Slice slice = this.type.getSlice(block, position);
        Type type = this.type;
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            slice = Chars.padSpaces((Slice)charType.getSlice(block, position), (CharType)charType);
        }
        if (this.needsEscape == null) {
            output.writeBytes(slice);
            return;
        }
        this.escapeBuffer.reset();
        for (int i = 0; i < slice.length(); ++i) {
            short b = slice.getUnsignedByte(i);
            if (this.needsEscape[b]) {
                output.appendByte((int)this.escapeByte);
            }
            output.appendByte((int)b);
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        if (this.needsEscape != null) {
            columnData = StringEncoding.unescape(columnData, this.escapeByte);
        }
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            length = ReadWriteUtils.calculateTruncationLength(this.type, slice, offset, length);
            this.type.writeSlice(builder, slice, offset, length);
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        if (this.needsEscape != null) {
            Slice newSlice = Slices.allocate((int)slice.length());
            SliceOutput output = newSlice.getOutput();
            StringEncoding.unescape(this.escapeByte, output, slice, offset, length);
            slice = newSlice;
            offset = 0;
            length = output.size();
        }
        length = ReadWriteUtils.calculateTruncationLength(this.type, slice, offset, length);
        this.type.writeSlice(builder, slice, offset, length);
    }

    private static ColumnData unescape(ColumnData columnData, byte escapeByte) {
        Slice slice = columnData.getSlice();
        if (slice.indexOfByte(escapeByte) < 0) {
            return columnData;
        }
        Slice newSlice = Slices.allocate((int)slice.length());
        SliceOutput output = newSlice.getOutput();
        int[] newOffsets = new int[columnData.rowCount() + 1];
        for (int row = 0; row < columnData.rowCount(); ++row) {
            int offset = columnData.getOffset(row);
            int length = columnData.getLength(row);
            StringEncoding.unescape(escapeByte, output, slice, offset, length);
            newOffsets[row + 1] = output.size();
        }
        return new ColumnData(newOffsets, output.slice());
    }

    private static void unescape(byte escapeByte, SliceOutput output, Slice slice, int offset, int length) {
        int i = 0;
        while (i < length) {
            byte value = slice.getByte(offset + i);
            if (value == escapeByte && i + 1 < length) {
                output.write((int)slice.getByte(offset + i + 1));
                i += 2;
                continue;
            }
            output.write((int)value);
            ++i;
        }
    }
}

