/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public class FloatEncoding
implements TextColumnEncoding {
    private final Type type;
    private final Slice nullSequence;
    private final StringBuilder buffer = new StringBuilder();

    public FloatEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                float value = Float.intBitsToFloat((int)this.type.getLong(block, position));
                this.buffer.setLength(0);
                this.buffer.append(value);
                for (int index = 0; index < this.buffer.length(); ++index) {
                    output.writeByte((int)this.buffer.charAt(index));
                }
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        float value = Float.intBitsToFloat((int)this.type.getLong(block, position));
        this.buffer.setLength(0);
        this.buffer.append(value);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) throws FileCorruptionException {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.type.writeLong(builder, (long)Float.floatToIntBits(FloatEncoding.parseFloat(slice, offset, length)));
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) throws FileCorruptionException {
        try {
            float value = Float.parseFloat(slice.toStringAscii(offset, length));
            this.type.writeLong(builder, (long)Float.floatToIntBits(value));
        }
        catch (NumberFormatException e) {
            builder.appendNull();
        }
    }

    private static float parseFloat(Slice slice, int start, int length) throws FileCorruptionException {
        try {
            return Float.parseFloat(slice.toStringAscii(start, length));
        }
        catch (NumberFormatException e) {
            throw new FileCorruptionException(e, "Invalid float value", new Object[0]);
        }
    }
}

