/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public abstract class BlockEncoding
implements TextColumnEncoding {
    private final Type type;
    protected final Slice nullSequence;
    private final Byte escapeByte;

    public BlockEncoding(Type type, Slice nullSequence, Byte escapeByte) {
        this.type = type;
        this.nullSequence = nullSequence;
        this.escapeByte = escapeByte;
    }

    @Override
    public final void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) throws FileCorruptionException {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValueInto(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public final Block decodeColumn(ColumnData columnData) throws FileCorruptionException {
        int size = columnData.rowCount();
        Slice slice = columnData.getSlice();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            int offset = columnData.getOffset(i);
            if (!this.isNullSequence(slice, offset, length)) {
                this.decodeValueInto(builder, slice, offset, length);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    protected final boolean isNullSequence(Slice slice, int offset, int length) {
        return this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length);
    }

    protected final boolean isEscapeByte(byte currentByte) {
        return this.escapeByte != null && currentByte == this.escapeByte;
    }
}

