/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.binary;

import io.trino.hive.formats.encodings.ColumnEncodingFactory;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncoding;
import io.trino.hive.formats.encodings.binary.BinaryEncoding;
import io.trino.hive.formats.encodings.binary.BooleanEncoding;
import io.trino.hive.formats.encodings.binary.ByteEncoding;
import io.trino.hive.formats.encodings.binary.DateEncoding;
import io.trino.hive.formats.encodings.binary.DecimalEncoding;
import io.trino.hive.formats.encodings.binary.DoubleEncoding;
import io.trino.hive.formats.encodings.binary.FloatEncoding;
import io.trino.hive.formats.encodings.binary.ListEncoding;
import io.trino.hive.formats.encodings.binary.LongEncoding;
import io.trino.hive.formats.encodings.binary.MapEncoding;
import io.trino.hive.formats.encodings.binary.ShortEncoding;
import io.trino.hive.formats.encodings.binary.StringEncoding;
import io.trino.hive.formats.encodings.binary.StructEncoding;
import io.trino.hive.formats.encodings.binary.TimestampEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;

public class BinaryColumnEncodingFactory
implements ColumnEncodingFactory {
    private final DateTimeZone timeZone;

    public BinaryColumnEncodingFactory(DateTimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    public BinaryColumnEncoding getEncoding(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanEncoding(type);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return new ByteEncoding(type);
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return new ShortEncoding(type);
        }
        if (IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type)) {
            return new LongEncoding(type);
        }
        if (type instanceof DecimalType) {
            return new DecimalEncoding(type);
        }
        if (RealType.REAL.equals((Object)type)) {
            return new FloatEncoding(type);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleEncoding(type);
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return new StringEncoding(type);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new BinaryEncoding(type);
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateEncoding(type);
        }
        if (type instanceof TimestampType) {
            return new TimestampEncoding((TimestampType)type, this.timeZone);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return new ListEncoding(arrayType, this.getEncoding(arrayType.getElementType()));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return new MapEncoding(mapType, this.getEncoding(mapType.getKeyType()), this.getEncoding(mapType.getValueType()));
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return new StructEncoding(rowType, rowType.getTypeParameters().stream().map(this::getEncoding).collect(Collectors.toList()));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }
}

