/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class DataOutputStream
extends OutputStream
implements DataOutput {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int MINIMUM_CHUNK_SIZE = 1024;
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DataOutputStream.class);
    private final OutputStream outputStream;
    private final Slice slice;
    private final byte[] buffer;
    private long bufferOffset;
    private int bufferPosition;

    public DataOutputStream(OutputStream inputStream) {
        this(inputStream, 4096);
    }

    public DataOutputStream(OutputStream outputStream, int bufferSize) {
        Preconditions.checkArgument((bufferSize >= 1024 ? 1 : 0) != 0, (Object)"minimum buffer size of 1024 required");
        if (outputStream == null) {
            throw new NullPointerException("outputStream is null");
        }
        this.outputStream = outputStream;
        this.buffer = new byte[bufferSize];
        this.slice = Slices.wrappedBuffer((byte[])this.buffer);
    }

    @Override
    public void flush() throws IOException {
        this.flushBufferToOutputStream();
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        try (OutputStream ignored = this.outputStream;){
            this.flushBufferToOutputStream();
        }
    }

    public long longSize() {
        return this.bufferOffset + (long)this.bufferPosition;
    }

    public long getRetainedSize() {
        return this.slice.getRetainedSize() + (long)INSTANCE_SIZE;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writeByte(value ? 1 : 0);
    }

    @Override
    public void write(int value) throws IOException {
        this.writeByte(value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        this.ensureWritableBytes(1);
        this.slice.setByte(this.bufferPosition, value);
        ++this.bufferPosition;
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.ensureWritableBytes(2);
        this.slice.setShort(this.bufferPosition, value);
        this.bufferPosition += 2;
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.ensureWritableBytes(4);
        this.slice.setInt(this.bufferPosition, value);
        this.bufferPosition += 4;
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.ensureWritableBytes(8);
        this.slice.setLong(this.bufferPosition, value);
        this.bufferPosition += 8;
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void write(Slice source) throws IOException {
        this.write(source, 0, source.length());
    }

    public void write(Slice source, int sourceIndex, int length) throws IOException {
        if (length >= 1024) {
            this.flushBufferToOutputStream();
            this.writeToOutputStream(source, sourceIndex, length);
            this.bufferOffset += (long)length;
        } else {
            this.ensureWritableBytes(length);
            this.slice.setBytes(this.bufferPosition, source, sourceIndex, length);
            this.bufferPosition += length;
        }
    }

    @Override
    public void write(byte[] source) throws IOException {
        this.write(source, 0, source.length);
    }

    @Override
    public void write(byte[] source, int sourceIndex, int length) throws IOException {
        if (length >= 1024) {
            this.flushBufferToOutputStream();
            this.writeToOutputStream(source, sourceIndex, length);
            this.bufferOffset += (long)length;
        } else {
            this.ensureWritableBytes(length);
            this.slice.setBytes(this.bufferPosition, source, sourceIndex, length);
            this.bufferPosition += length;
        }
    }

    public void write(InputStream in, int length) throws IOException {
        while (length > 0) {
            int batch = this.ensureBatchSize(length);
            this.slice.setBytes(this.bufferPosition, in, batch);
            this.bufferPosition += batch;
            length -= batch;
        }
    }

    public void writeZero(int length) throws IOException {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be 0 or greater than 0.");
        while (length > 0) {
            int batch = this.ensureBatchSize(length);
            Arrays.fill(this.buffer, this.bufferPosition, this.bufferPosition + batch, (byte)0);
            this.bufferPosition += batch;
            length -= batch;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OutputStreamSliceOutputAdapter{");
        builder.append("outputStream=").append(this.outputStream);
        builder.append("bufferSize=").append(this.slice.length());
        builder.append('}');
        return builder.toString();
    }

    private void ensureWritableBytes(int minWritableBytes) throws IOException {
        if (this.bufferPosition + minWritableBytes > this.slice.length()) {
            this.flushBufferToOutputStream();
        }
    }

    private int ensureBatchSize(int length) throws IOException {
        this.ensureWritableBytes(Math.min(1024, length));
        return Math.min(length, this.slice.length() - this.bufferPosition);
    }

    private void flushBufferToOutputStream() throws IOException {
        this.writeToOutputStream(this.buffer, 0, this.bufferPosition);
        this.bufferOffset += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    private void writeToOutputStream(byte[] source, int sourceIndex, int length) throws IOException {
        this.outputStream.write(source, sourceIndex, length);
    }

    private void writeToOutputStream(Slice source, int sourceIndex, int length) throws IOException {
        source.getBytes(sourceIndex, this.outputStream, length);
    }

    @Override
    @Deprecated
    public void writeChar(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void writeChars(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void writeUTF(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void writeBytes(String s) {
        throw new UnsupportedOperationException();
    }
}

