/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.core.exception.AzureException;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import io.trino.filesystem.azure.AzureLocation;
import java.io.FileNotFoundException;
import java.io.IOException;

final class AzureUtils {
    private AzureUtils() {
    }

    public static IOException handleAzureException(RuntimeException exception, String action, AzureLocation location) throws IOException {
        DataLakeStorageException dataLakeStorageException;
        BlobStorageException blobStorageException;
        if (exception instanceof BlobStorageException && BlobErrorCode.BLOB_NOT_FOUND.equals((Object)(blobStorageException = (BlobStorageException)exception).getErrorCode())) {
            throw AzureUtils.withCause(new FileNotFoundException(location.toString()), exception);
        }
        if (exception instanceof DataLakeStorageException && "PathNotFound".equals((dataLakeStorageException = (DataLakeStorageException)((Object)exception)).getErrorCode())) {
            throw AzureUtils.withCause(new FileNotFoundException(location.toString()), exception);
        }
        if (exception instanceof AzureException) {
            throw new IOException("Azure service error %s file: %s".formatted(action, location), exception);
        }
        throw new IOException("Error %s file: %s".formatted(action, location), exception);
    }

    private static <T extends Throwable> T withCause(T throwable, Throwable cause) {
        throwable.initCause(cause);
        return throwable;
    }
}

