/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.google.common.base.Preconditions;
import io.trino.filesystem.azure.AzureLocation;
import io.trino.filesystem.azure.AzureUtils;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

class AzureOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 8192;
    private final AzureLocation location;
    private final long writeBlockSizeBytes;
    private final OutputStream stream;
    private final LocalMemoryContext memoryContext;
    private long writtenBytes;
    private boolean closed;

    public AzureOutputStream(AzureLocation location, BlobClient blobClient, boolean overwrite, AggregatedMemoryContext memoryContext, long writeBlockSizeBytes, int maxWriteConcurrency, long maxSingleUploadSizeBytes) throws IOException {
        Objects.requireNonNull(location, "location is null");
        Objects.requireNonNull(blobClient, "blobClient is null");
        Preconditions.checkArgument((writeBlockSizeBytes >= 0L ? 1 : 0) != 0, (Object)"writeBlockSizeBytes is negative");
        Preconditions.checkArgument((maxWriteConcurrency >= 0 ? 1 : 0) != 0, (Object)"maxWriteConcurrency is negative");
        Preconditions.checkArgument((maxSingleUploadSizeBytes >= 0L ? 1 : 0) != 0, (Object)"maxSingleUploadSizeBytes is negative");
        this.location = location;
        this.writeBlockSizeBytes = writeBlockSizeBytes;
        BlockBlobOutputStreamOptions streamOptions = new BlockBlobOutputStreamOptions();
        streamOptions.setParallelTransferOptions(new ParallelTransferOptions().setBlockSizeLong(Long.valueOf(writeBlockSizeBytes)).setMaxConcurrency(Integer.valueOf(maxWriteConcurrency)).setMaxSingleUploadSizeLong(Long.valueOf(maxSingleUploadSizeBytes)));
        if (!overwrite) {
            streamOptions.setRequestConditions(new BlobRequestConditions().setIfNoneMatch("*"));
        }
        try {
            this.stream = new BufferedOutputStream((OutputStream)blobClient.getBlockBlobClient().getBlobOutputStream(streamOptions), 8192);
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "creating file", location);
        }
        this.memoryContext = memoryContext.newLocalMemoryContext(AzureOutputStream.class.getSimpleName());
        this.memoryContext.setBytes(8192L);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        try {
            this.stream.write(b);
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "writing file", this.location);
        }
        this.recordBytesWritten(1);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.ensureOpen();
        try {
            this.stream.write(buffer, offset, length);
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "writing file", this.location);
        }
        this.recordBytesWritten(length);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        try {
            this.stream.flush();
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "writing file", this.location);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + this.location);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw new IOException("Error closing file: " + this.location, e);
            }
            finally {
                this.memoryContext.close();
            }
        }
    }

    private void recordBytesWritten(int size) {
        if (this.writtenBytes < this.writeBlockSizeBytes) {
            this.memoryContext.setBytes(8192L + Math.min(this.writtenBytes + (long)size, this.writeBlockSizeBytes));
        }
        this.writtenBytes += (long)size;
    }
}

