/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.storage.file.datalake.models.PathItem;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.azure.AzureLocation;
import io.trino.filesystem.azure.AzureUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

final class AzureDataLakeFileIterator
implements FileIterator {
    private final AzureLocation location;
    private final Iterator<PathItem> iterator;
    private final Location baseLocation;

    AzureDataLakeFileIterator(AzureLocation location, Iterator<PathItem> iterator) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
        this.baseLocation = location.baseLocation();
    }

    public boolean hasNext() throws IOException {
        try {
            return this.iterator.hasNext();
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "listing files", this.location);
        }
    }

    public FileEntry next() throws IOException {
        try {
            PathItem pathItem = this.iterator.next();
            return new FileEntry(this.baseLocation.appendPath(pathItem.getName()), pathItem.getContentLength(), pathItem.getLastModified().toInstant(), Optional.empty());
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "listing files", this.location);
        }
    }
}

