/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.journal.JournalType;
import alluxio.master.metastore.MetastoreType;
import alluxio.worker.block.BlockStoreType;

public final class FeatureUtils {
    public static boolean isEmbeddedJournal() {
        return JournalType.EMBEDDED == Configuration.get(PropertyKey.MASTER_JOURNAL_TYPE);
    }

    public static boolean isInodeStoreRocks() {
        if (Configuration.isSetByUser(PropertyKey.MASTER_INODE_METASTORE)) {
            return Configuration.get(PropertyKey.MASTER_INODE_METASTORE) == MetastoreType.ROCKS;
        }
        return Configuration.get(PropertyKey.MASTER_METASTORE) == MetastoreType.ROCKS;
    }

    public static boolean isBlockStoreRocks() {
        if (Configuration.isSetByUser(PropertyKey.MASTER_BLOCK_METASTORE)) {
            return Configuration.get(PropertyKey.MASTER_BLOCK_METASTORE) == MetastoreType.ROCKS;
        }
        return Configuration.get(PropertyKey.MASTER_METASTORE) == MetastoreType.ROCKS;
    }

    public static boolean isZookeeperEnabled() {
        return Configuration.getBoolean(PropertyKey.ZOOKEEPER_ENABLED);
    }

    public static boolean isBackupDelegationEnabled() {
        return Configuration.getBoolean(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED);
    }

    public static boolean isDailyBackupEnabled() {
        return Configuration.getBoolean(PropertyKey.MASTER_DAILY_BACKUP_ENABLED);
    }

    public static boolean isPersistenceBlacklistEmpty() {
        return !Configuration.isSet(PropertyKey.MASTER_PERSISTENCE_BLACKLIST) || Configuration.getList(PropertyKey.MASTER_PERSISTENCE_BLACKLIST).isEmpty();
    }

    public static boolean isUnsafeDirectPersistEnabled() {
        return Configuration.getBoolean(PropertyKey.MASTER_UNSAFE_DIRECT_PERSIST_OBJECT_ENABLED);
    }

    public static boolean isMasterAuditLoggingEnabled() {
        return Configuration.getBoolean(PropertyKey.MASTER_AUDIT_LOGGING_ENABLED);
    }

    public static boolean isPageStoreEnabled() {
        return Configuration.get(PropertyKey.WORKER_BLOCK_STORE_TYPE) == BlockStoreType.PAGE;
    }
}

