/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.lite;

import alluxio.shaded.client.software.amazon.ionIntegerSize;
import alluxio.shaded.client.software.amazon.ionIonInt;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionNullValueException;
import alluxio.shaded.client.software.amazon.ionValueVisitor;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonValue;
import alluxio.shaded.client.software.amazon.ionimpl.lite.ContainerlessContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonValueLite;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

final class IonIntLite
extends IonValueLite
implements ionIonInt {
    private static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final int HASH_SIGNATURE = ionIonType.INT.toString().hashCode();
    private static final int INT_SIZE_MASK = 24;
    private static final int INT_SIZE_SHIFT = 3;
    private static final ionIntegerSize[] SIZES = ionIntegerSize.values();
    private long _long_value;
    private BigInteger _big_int_value;

    IonIntLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonIntLite(IonIntLite existing, IonContext context) {
        super(existing, context);
        this._long_value = existing._long_value;
        this._big_int_value = existing._big_int_value;
    }

    IonIntLite clone(IonContext context) {
        return new IonIntLite(this, context);
    }

    public IonIntLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int result = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            if (this._big_int_value == null) {
                long lv = this.longValue();
                result ^= (int)lv;
                int hi_word = (int)(lv >>> 32);
                if (hi_word != 0 && hi_word != -1) {
                    result ^= hi_word;
                }
            } else {
                result = this._big_int_value.hashCode();
            }
        }
        return this.hashTypeAnnotations(result, symbolTableProvider);
    }

    public ionIonType getType() {
        return ionIonType.INT;
    }

    public int intValue() throws ionNullValueException {
        this.validateThisNotNull();
        if (this._big_int_value == null) {
            return (int)this._long_value;
        }
        return this._big_int_value.intValue();
    }

    public long longValue() throws ionNullValueException {
        this.validateThisNotNull();
        if (this._big_int_value == null) {
            return this._long_value;
        }
        return this._big_int_value.longValue();
    }

    public BigInteger bigIntegerValue() throws ionNullValueException {
        if (this.isNullValue()) {
            return null;
        }
        if (this._big_int_value == null) {
            return BigInteger.valueOf(this._long_value);
        }
        return this._big_int_value;
    }

    public void setValue(int value) {
        this.setValue((long)value);
    }

    public void setValue(long value) {
        this.checkForLock();
        this.doSetValue(value, false);
    }

    public void setValue(Number value) {
        this.checkForLock();
        if (value == null) {
            this.doSetValue(0L, true);
        } else if (value instanceof BigInteger) {
            BigInteger big = (BigInteger)value;
            this.doSetValue(big);
        } else if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            this.doSetValue(bd.toBigInteger());
        } else {
            this.doSetValue(value.longValue(), false);
        }
    }

    final void writeBodyTo(ionIonWriter writer, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        if (this.isNullValue()) {
            writer.writeNull(ionIonType.INT);
        } else if (this._big_int_value != null) {
            writer.writeInt(this._big_int_value);
        } else {
            writer.writeInt(this._long_value);
        }
    }

    private void doSetValue(long value, boolean isNull) {
        this._long_value = value;
        this._big_int_value = null;
        this._isNullValue(isNull);
        if (!isNull) {
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                this.setSize(ionIntegerSize.LONG);
            } else {
                this.setSize(ionIntegerSize.INT);
            }
        }
    }

    private void doSetValue(BigInteger value) {
        if (value.compareTo(LONG_MIN_VALUE) < 0 || value.compareTo(LONG_MAX_VALUE) > 0) {
            this.setSize(ionIntegerSize.BIG_INTEGER);
            this._long_value = 0L;
            this._big_int_value = value;
            this._isNullValue(false);
        } else {
            this.doSetValue(value.longValue(), false);
        }
    }

    private void setSize(ionIntegerSize size) {
        this._setMetadata(size.ordinal(), 24, 3);
    }

    public void accept(ionValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public ionIntegerSize getIntegerSize() {
        if (this.isNullValue()) {
            return null;
        }
        return SIZES[this._getMetadata(24, 3)];
    }
}

