/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class ionDecimal
extends BigDecimal {
    private static final long serialVersionUID = 1L;
    public static final ionDecimal ZERO = new ionDecimal(0);
    public static final ionDecimal NEGATIVE_ZERO = new NegativeZero(0);

    public static boolean isNegativeZero(BigDecimal val) {
        return val.getClass() == NegativeZero.class;
    }

    public static BigDecimal bigDecimalValue(BigDecimal val) {
        if (val == null || val.getClass() == BigDecimal.class) {
            return val;
        }
        return new BigDecimal(val.unscaledValue(), val.scale());
    }

    public static boolean equals(BigDecimal v1, BigDecimal v2) {
        return ionDecimal.isNegativeZero(v1) == ionDecimal.isNegativeZero(v2) && v1.equals(v2);
    }

    public static ionDecimal negativeZero(int scale) {
        return new NegativeZero(scale);
    }

    public static ionDecimal negativeZero(int scale, MathContext mc) {
        return new NegativeZero(scale, mc);
    }

    public static ionDecimal valueOf(BigInteger unscaledVal, int scale) {
        return new ionDecimal(unscaledVal, scale);
    }

    public static ionDecimal valueOf(BigInteger unscaledVal, int scale, MathContext mc) {
        return new ionDecimal(unscaledVal, scale, mc);
    }

    public static ionDecimal valueOf(BigInteger val) {
        return new ionDecimal(val);
    }

    public static ionDecimal valueOf(BigInteger val, MathContext mc) {
        return new ionDecimal(val, mc);
    }

    public static ionDecimal valueOf(int val) {
        return new ionDecimal(val);
    }

    public static ionDecimal valueOf(int val, MathContext mc) {
        return new ionDecimal(val, mc);
    }

    public static ionDecimal valueOf(long val) {
        return new ionDecimal(val);
    }

    public static ionDecimal valueOf(long val, MathContext mc) {
        return new ionDecimal(val, mc);
    }

    public static ionDecimal valueOf(double val) {
        if (Double.compare(val, -0.0) == 0) {
            return new NegativeZero(1);
        }
        return new ionDecimal(Double.toString(val));
    }

    public static ionDecimal valueOf(double val, MathContext mc) {
        if (Double.compare(val, -0.0) == 0) {
            return new NegativeZero(1, mc);
        }
        return new ionDecimal(Double.toString(val), mc);
    }

    public static ionDecimal valueOf(BigDecimal val) {
        if (val == null || val instanceof ionDecimal) {
            return (ionDecimal)val;
        }
        return new ionDecimal(val.unscaledValue(), val.scale());
    }

    public static ionDecimal valueOf(BigDecimal val, MathContext mc) {
        return new ionDecimal(val.unscaledValue(), val.scale(), mc);
    }

    public static ionDecimal valueOf(String val) {
        boolean negative = val.startsWith("-");
        ionDecimal ibd = new ionDecimal(val);
        if (negative && ibd.signum() == 0) {
            ibd = new NegativeZero(ibd.scale());
        }
        return ibd;
    }

    public static ionDecimal valueOf(String val, MathContext mc) {
        boolean negative = val.startsWith("-");
        ionDecimal ibd = new ionDecimal(val, mc);
        if (negative && ibd.signum() == 0) {
            ibd = new NegativeZero(ibd.scale(), mc);
        }
        return ibd;
    }

    private ionDecimal(BigInteger unscaledVal, int scale) {
        super(unscaledVal, scale);
    }

    private ionDecimal(BigInteger unscaledVal, int scale, MathContext mc) {
        super(unscaledVal, scale, mc);
    }

    private ionDecimal(BigInteger val) {
        super(val);
    }

    private ionDecimal(BigInteger val, MathContext mc) {
        super(val, mc);
    }

    private ionDecimal(int val) {
        super(val);
    }

    private ionDecimal(int val, MathContext mc) {
        super(val, mc);
    }

    private ionDecimal(long val) {
        super(val);
    }

    private ionDecimal(long val, MathContext mc) {
        super(val, mc);
    }

    private ionDecimal(double val) {
        super(val);
    }

    private ionDecimal(double val, MathContext mc) {
        super(val, mc);
    }

    private ionDecimal(char[] in, int offset, int len) {
        super(in, offset, len);
    }

    private ionDecimal(char[] in, int offset, int len, MathContext mc) {
        super(in, offset, len, mc);
    }

    private ionDecimal(char[] in) {
        super(in);
    }

    private ionDecimal(char[] in, MathContext mc) {
        super(in, mc);
    }

    private ionDecimal(String val) {
        super(val);
    }

    private ionDecimal(String val, MathContext mc) {
        super(val, mc);
    }

    public final boolean isNegativeZero() {
        return this.getClass() == NegativeZero.class;
    }

    public final BigDecimal bigDecimalValue() {
        return new BigDecimal(this.unscaledValue(), this.scale());
    }

    private static final class NegativeZero
    extends ionDecimal {
        private static final long serialVersionUID = 1L;

        private NegativeZero(int scale) {
            super(BigInteger.ZERO, scale);
        }

        private NegativeZero(int scale, MathContext mc) {
            super(BigInteger.ZERO, scale, mc);
        }

        public float floatValue() {
            float v = super.floatValue();
            if (Float.compare(0.0f, v) <= 0) {
                v = -1.0f * v;
            }
            return v;
        }

        public double doubleValue() {
            double v = super.doubleValue();
            if (Double.compare(0.0, v) <= 0) {
                v = -1.0 * v;
            }
            return v;
        }

        public BigDecimal abs() {
            return new BigDecimal(this.unscaledValue(), this.scale());
        }

        public BigDecimal abs(MathContext mc) {
            return new BigDecimal(this.unscaledValue(), this.scale(), mc);
        }

        public String toString() {
            return '-' + super.toString();
        }

        public String toEngineeringString() {
            return '-' + super.toEngineeringString();
        }

        public String toPlainString() {
            return '-' + super.toPlainString();
        }
    }
}

