/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.services;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.io.grpc.Context;
import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6012")
@ThreadSafe
public final class CallMetricRecorder {
    private static final CallMetricRecorder NOOP = new CallMetricRecorder().disable();
    static final Context.Key<CallMetricRecorder> CONTEXT_KEY = Context.key("alluxio.shaded.client.io.grpc.services.CallMetricRecorder");
    private final AtomicReference<ConcurrentHashMap<String, Double>> metrics = new AtomicReference();
    private volatile boolean disabled;

    CallMetricRecorder() {
    }

    public static CallMetricRecorder getCurrent() {
        CallMetricRecorder recorder = CONTEXT_KEY.get();
        return recorder != null ? recorder : NOOP;
    }

    public CallMetricRecorder recordCallMetric(String name, double value) {
        if (this.disabled) {
            return this;
        }
        if (this.metrics.get() == null) {
            this.metrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.metrics.get().put(name, value);
        return this;
    }

    Map<String, Double> finalizeAndDump() {
        this.disabled = true;
        Map savedMetrics = this.metrics.get();
        if (savedMetrics == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(savedMetrics);
    }

    @VisibleForTesting
    boolean isDisabled() {
        return this.disabled;
    }

    private CallMetricRecorder disable() {
        this.disabled = true;
        return this;
    }
}

