/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.internal;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.javax.annotation.Nonnull;
import alluxio.shaded.client.javax.annotation.concurrent.Immutable;
import java.util.Set;

@Immutable
final class RetryPolicy {
    final int maxAttempts;
    final long initialBackoffNanos;
    final long maxBackoffNanos;
    final double backoffMultiplier;
    final Set<Status.Code> retryableStatusCodes;

    RetryPolicy(int maxAttempts, long initialBackoffNanos, long maxBackoffNanos, double backoffMultiplier, @Nonnull Set<Status.Code> retryableStatusCodes) {
        this.maxAttempts = maxAttempts;
        this.initialBackoffNanos = initialBackoffNanos;
        this.maxBackoffNanos = maxBackoffNanos;
        this.backoffMultiplier = backoffMultiplier;
        this.retryableStatusCodes = ImmutableSet.copyOf(retryableStatusCodes);
    }

    public int hashCode() {
        return Objects.hashCode(this.maxAttempts, this.initialBackoffNanos, this.maxBackoffNanos, this.backoffMultiplier, this.retryableStatusCodes);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RetryPolicy)) {
            return false;
        }
        RetryPolicy that = (RetryPolicy)other;
        return this.maxAttempts == that.maxAttempts && this.initialBackoffNanos == that.initialBackoffNanos && this.maxBackoffNanos == that.maxBackoffNanos && Double.compare(this.backoffMultiplier, that.backoffMultiplier) == 0 && Objects.equal(this.retryableStatusCodes, that.retryableStatusCodes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxAttempts", this.maxAttempts).add("initialBackoffNanos", this.initialBackoffNanos).add("maxBackoffNanos", this.maxBackoffNanos).add("backoffMultiplier", this.backoffMultiplier).add("retryableStatusCodes", this.retryableStatusCodes).toString();
    }
}

